/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.extractTag;

import com.intellij.lang.StdLanguages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.lang.jsp.extractTag.ExtractTagHandler;
import org.jetbrains.annotations.Nullable;

public class ExtractJspTagHandler
extends ExtractTagHandler {
    @Override
    @Nullable
    public String getExistingPrefix(BaseJspFile jspFile, String tagdir) {
        XmlTag[] tags;
        for (XmlTag tag : tags = jspFile.getDirectiveTags(JspDirectiveKind.TAGLIB, true)) {
            String value = tag.getAttributeValue("tagdir");
            if (!tagdir.equals(value)) continue;
            return tag.getAttributeValue("prefix");
        }
        return null;
    }

    @Override
    public void addDeclaration(XmlTag rootTag, BaseJspFile jspFile, String prefix, String tagdir) {
        XmlTag directive = jspFile.createDirective(rootTag, JspDirectiveKind.TAGLIB);
        directive.setAttribute("prefix", prefix);
        directive.setAttribute("tagdir", tagdir);
        rootTag.addBefore((PsiElement)directive, rootTag.getFirstChild());
    }

    @Override
    protected boolean acceptFile(BaseJspFile file) {
        return file.getLanguage() == StdLanguages.JSP;
    }

    @Override
    public String getTagExtension() {
        return "tag";
    }
}

