/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.el.impl;

import com.intellij.jsp.impl.ExtendedTEI;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.jsp.impl.JspElementDescriptorEx;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.jsp.JspImplUtil;
import com.intellij.psi.impl.source.jsp.JspImplicitVariableImpl;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.JspManagerImpl;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.impl.source.jsp.el.ElContextProviderEx;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ELExpressionBase;
import com.intellij.psi.impl.source.jsp.el.impl.ELReference;
import com.intellij.psi.impl.source.jsp.el.impl.ElVariablesProvider;
import com.intellij.psi.impl.source.jsp.el.impl.JspElVariablesProvider;
import com.intellij.psi.impl.source.jsp.el.impl.JspImplicitVariableWithCustomResolve;
import com.intellij.psi.impl.source.jsp.el.impl.MethodSignatureFilter;
import com.intellij.psi.impl.source.jsp.el.impl.TagImplicitVariable;
import com.intellij.psi.impl.source.jsp.el.impl.TypedELExpression;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.jsp.el.ELBinaryExpression;
import com.intellij.psi.jsp.el.ELCallExpression;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELLambdaExpression;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.jsp.el.ELMethodCallExpression;
import com.intellij.psi.jsp.el.ELSelectExpression;
import com.intellij.psi.jsp.el.ELSliceExpression;
import com.intellij.psi.jsp.el.ELUnaryExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.scope.processor.MethodResolveProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ELResolveUtil {
    @NonNls
    public static final String VALUE_ATTRIBUTE_NAME = "value";
    public static final Key<PsiSubstitutor> SUBSTITUTOR = Key.create((String)"substitutor");
    private static final Key<Boolean> STATIC_CONTEXT = Key.create((String)"el.static.context");
    @NonNls
    static final String FOR_TOKENS_TAG_NAME = "forTokens";
    @NonNls
    static final String FOR_EACH_TAG_NAME = "forEach";
    @NonNls
    static final String ITEMS_ATTR_NAME = "items";
    @NonNls
    static final String VALUE_ATTR_NAME = "value";
    private static final Key<CachedValue<List<JspImplicitVariable>>> EL_VARS_MAP = Key.create((String)"el vars");
    private static final Key<CachedValue<List<JspImplicitVariable>>> EL_TEI_VARS_MAP = Key.create((String)"el vars");
    @NonNls
    private static final String SERVLET_PACKAGE = "javax.servlet";
    @NonNls
    private static final String WRAPPER_CLASS_SUFFIX = "Wrapper";
    @NonNls
    private static final String SERVLET_HTTP_PACKAGE = "javax.servlet.http.";
    @NonNls
    private static final String VAR_STATUS_ATTR_NAME = "varStatus";
    private static final JspElVariablesProvider ourJspElVariablesProvider = new JspElVariablesProvider();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil");
    private static final ThreadLocal<Set<PsiFile>> VISITED = ThreadLocal.withInitial(HashSet::new);
    private static final UserDataCache<CachedValue<List<JspImplicitVariable>>, XmlTag, Object> ourCachedTeiVarsCache = new UserDataCache<CachedValue<List<JspImplicitVariable>>, XmlTag, Object>(){

        protected CachedValue<List<JspImplicitVariable>> compute(XmlTag tag, Object p) {
            return CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue(() -> {
                VariableInfo[] variableInfos;
                SmartList resultVars = null;
                XmlElementDescriptor descriptor = tag.getDescriptor();
                PsiFile psiFile = tag.getContainingFile().getOriginalFile();
                VirtualFile file = psiFile.getVirtualFile();
                TagExtraInfo extraInfo = descriptor instanceof JspElementDescriptorEx && file != null ? ((JspElementDescriptorEx)descriptor).getExtraInfo(ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex().getModuleForFile(file)) : null;
                VariableInfo[] variableInfoArray = variableInfos = extraInfo != null ? extraInfo.getVariableInfo(JspImplUtil.getTagData(tag)) : null;
                if (variableInfos != null && variableInfos.length > 0) {
                    resultVars = new SmartList();
                    for (VariableInfo info : variableInfos) {
                        if (info == null) continue;
                        PsiElement identifierForVariable = null;
                        if (extraInfo instanceof ExtendedTEI) {
                            identifierForVariable = ((ExtendedTEI)extraInfo).getIdentifierForVariable(info, tag);
                        }
                        String className = info.getClassName() != null ? info.getClassName() : "java.lang.Object";
                        PsiType type = PsiImplUtil.buildTypeFromTypeString((String)className, (PsiElement)tag, (PsiFile)psiFile);
                        resultVars.add(new JspImplicitVariableImpl((PsiElement)psiFile, info.getVarName(), type, (PsiElement)(identifierForVariable != null ? identifierForVariable : tag), info.getScope() == 1 ? "AT_BEGIN" : (info.getScope() == 2 ? "AT_END" : null)));
                    }
                }
                return new CachedValueProvider.Result((Object)resultVars, new Object[]{descriptor != null ? descriptor.getDependencies() : ArrayUtil.EMPTY_OBJECT_ARRAY, psiFile, JspManagerImpl.getInstance(psiFile.getProject()).getRootsModificationTracker(), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }, false);
        }
    };
    private static final UserDataCache<CachedValue<List<JspImplicitVariable>>, XmlTag, NotNullFunction<XmlTag, String>> ourCachedELVarsCache = new UserDataCache<CachedValue<List<JspImplicitVariable>>, XmlTag, NotNullFunction<XmlTag, String>>(){

        protected CachedValue<List<JspImplicitVariable>> compute(XmlTag tag, NotNullFunction<XmlTag, String> defaultVarTypeProvider) {
            return CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue(() -> {
                List resultVars = (List)((CachedValue)ourCachedTeiVarsCache.get(EL_TEI_VARS_MAP, (UserDataHolder)tag, null)).getValue();
                if (resultVars == null) {
                    resultVars = ELResolveUtil.computeTagVariables(tag, (NotNullFunction<XmlTag, String>)defaultVarTypeProvider);
                }
                Object[] deps = new Object[]{tag.getContainingFile(), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT};
                return new CachedValueProvider.Result((Object)resultVars, deps);
            }, false);
        }
    };
    private static final UserDataCache<CachedValue<Map<String, JspImplicitVariable>>, PsiFile, VariableInfoData> ourCachedPredefinedVarsCache = new UserDataCache<CachedValue<Map<String, JspImplicitVariable>>, PsiFile, VariableInfoData>(){

        protected CachedValue<Map<String, JspImplicitVariable>> compute(PsiFile file, VariableInfoData data) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                HashMap<String, JspImplicitVariableImpl> predefinedVars = new HashMap<String, JspImplicitVariableImpl>(data.myVars.size());
                Project project = file.getProject();
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
                for (VariableInfoBean variableInfoBean : data.myVars) {
                    JspImplicitVariable var = new JspImplicitVariableImpl((PsiElement)file, variableInfoBean.getName(), (PsiType)(variableInfoBean.isMapValue() ? ELResolveUtil.createTypedMapType((PsiElement)file, "java.lang.String", variableInfoBean.getType()) : elementFactory.createTypeByFQClassName(variableInfoBean.getType(), allScope)), null);
                    predefinedVars.put(var.getName(), (JspImplicitVariableImpl)var);
                }
                if (file instanceof JspFile) {
                    ArrayList tagFileVars = new ArrayList();
                    JspImplUtil.addSharedImplicitVars((PsiElement)file, (JspFile)file, tagFileVars);
                    JspElVariablesProvider.collectVariablesFromFile((JspFile)file, tagFileVars);
                    for (JspImplicitVariable var : tagFileVars) {
                        predefinedVars.put(var.getName(), (JspImplicitVariableImpl)var);
                    }
                }
                Object[] deps = new Object[]{file, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT};
                return CachedValueProvider.Result.create(predefinedVars, (Object[])deps);
            }, false);
        }
    };
    public static final Key<PsiType> EL_VARS_TYPE = Key.create((String)"el var type");
    public static final Key<FunctionDescriptor> EL_FUNCTION_DESCRIPTOR = Key.create((String)"el function descriptor");

    private ELResolveUtil() {
    }

    @Nullable
    public static List<JspImplicitVariable> createOrGetVariables(XmlTag element, NotNullFunction<XmlTag, String> defaultVarTypeProvider) {
        return (List)((CachedValue)ourCachedELVarsCache.get(EL_VARS_MAP, (UserDataHolder)element, defaultVarTypeProvider)).getValue();
    }

    private static List<JspImplicitVariable> computeTagVariables(XmlTag tag, NotNullFunction<XmlTag, String> defaultVarTypeProvider) {
        SmartList resultVars = new SmartList();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)tag.getProject());
        JspElVariablesProvider.addVarsFromComments(tag, (List<? super JspImplicitVariable>)resultVars);
        XmlAttribute attribute = tag.getAttribute("var");
        if (attribute != null && attribute.getValue() != null) {
            String localName = tag.getLocalName();
            String range = localName.equals(FOR_EACH_TAG_NAME) || localName.equals(FOR_TOKENS_TAG_NAME) ? "NESTED" : "AT_BEGIN";
            TagImplicitVariable variable = new TagImplicitVariable(tag, attribute, range, defaultVarTypeProvider);
            resultVars.add(variable);
        }
        if ((attribute = tag.getAttribute(VAR_STATUS_ATTR_NAME)) != null && attribute.getValue() != null) {
            resultVars.add(new JspImplicitVariableImpl((PsiElement)tag, attribute.getValue(), (PsiType)facade.getElementFactory().createTypeByFQClassName("javax.servlet.jsp.jstl.core.LoopTagStatus"), (PsiElement)attribute.getValueElement(), "NESTED"));
        }
        return resultVars;
    }

    @Nullable
    public static ELExpression getContext(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof ELSelectExpression && ((ELSelectExpression)parent).getField() == element) {
            return ((ELSelectExpression)parent).getFrom();
        }
        if (parent instanceof ELSliceExpression && ((ELSliceExpression)parent).getIndex() == element) {
            return ((ELSliceExpression)parent).getFrom();
        }
        if (parent instanceof ELMethodCallExpression && ((ELMethodCallExpression)parent).getMethod() == element) {
            return ((ELMethodCallExpression)parent).getQualifier();
        }
        if (parent instanceof ELBinaryExpression) {
            return ELResolveUtil.getContext(parent);
        }
        return null;
    }

    @NotNull
    public static ResolveResult[] resolveElement(PsiElement element, Class<? extends PsiElement> targetClass) {
        String text = StringUtil.unquoteString((String)element.getText());
        SmartList result = new SmartList();
        ELResolveUtil.process(element, ELResolveUtil.getResolver(text, (List<ResolveResult>)result, element, targetClass));
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            ELResolveUtil.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    private static ELElementProcessor getResolver(final String text, final List<ResolveResult> result, final PsiElement context, final Class<? extends PsiElement> targetClass) {
        return new ELElementProcessor(){
            private final boolean allowPropertyMethodName;
            private PsiSubstitutor mySubstitutor;
            {
                this.allowPropertyMethodName = context.getParent() instanceof ELMethodCallExpression || ELResolveUtil.allowPropertyMethodName(context);
            }

            @Override
            public boolean processNSPrefix(String prefix) {
                return true;
            }

            @Override
            public boolean processVariable(ELVariable variable) {
                if (text.equals(variable.getText())) {
                    this.addResult((PsiElement)variable);
                    return false;
                }
                return true;
            }

            @Override
            public boolean processVariable(PsiVariable variable) {
                if (text.equals(variable.getName())) {
                    PsiElement resolve;
                    PsiReference reference;
                    PsiElement declaration;
                    if (variable instanceof JspImplicitVariable && (declaration = ((JspImplicitVariable)variable).getDeclaration()) instanceof XmlAttributeValue && (reference = declaration.getReference()) != null && (resolve = reference.resolve()) instanceof PsiVariable) {
                        this.addResult(resolve);
                        return false;
                    }
                    this.addResult((PsiElement)variable);
                    return false;
                }
                return true;
            }

            @Override
            public boolean processMethod(PsiMethod method) {
                String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
                if (propertyName != null && text.equals(propertyName)) {
                    this.createResult(method);
                }
                if ((propertyName == null || this.allowPropertyMethodName) && text.equals(method.getName())) {
                    this.createResult(method);
                    return true;
                }
                return true;
            }

            private void createResult(PsiMethod method) {
                this.addResult((PsiElement)method);
                method.putUserData(SUBSTITUTOR, (Object)this.mySubstitutor);
            }

            private void addResult(PsiElement element) {
                result.add(new PsiElementResolveResult(element));
            }

            @Override
            public boolean processField(PsiField field) {
                if (text.equals(field.getName())) {
                    this.addResult((PsiElement)field);
                    return false;
                }
                return true;
            }

            @Override
            public boolean processClass(PsiClass psiClass, PsiImportStatement importStatement) {
                if (text.equals(psiClass.getName())) {
                    result.add(new CandidateInfo((PsiElement)psiClass, PsiSubstitutor.EMPTY, null, null, false, (PsiElement)importStatement));
                    return false;
                }
                return true;
            }

            @Override
            public boolean processProperty(IProperty property) {
                if (text.equals(property.getName())) {
                    this.addResult(property.getPsiElement());
                }
                return true;
            }

            @Override
            public void setSubstitutor(PsiSubstitutor substitutor) {
                this.mySubstitutor = substitutor;
            }

            @Override
            @Nullable
            public String getNameHint() {
                return text;
            }

            @Override
            @Nullable
            public Class<? extends PsiElement> getTargetClass() {
                return targetClass;
            }
        };
    }

    private static boolean isSpecialType(PsiClass psiClass, PsiFile psiFile, String clazzName) {
        String qualifiedName = psiClass.getQualifiedName();
        if (clazzName.equals(qualifiedName)) {
            return true;
        }
        PsiClass listClass = TagImplicitVariable.getCachedClass(psiFile, clazzName);
        return listClass != null && psiClass.isInheritor(listClass, true);
    }

    public static boolean isMapOrListSpecialType(PsiClass psiClass, PsiFile psiFile) {
        return ELResolveUtil.isSpecialType(psiClass, psiFile, "java.util.List") || !ELResolveUtil.isSpecialType(psiClass, psiFile, "java.util.Properties") && ELResolveUtil.isSpecialType(psiClass, psiFile, "java.util.Map");
    }

    public static PsiType createTypedMapType(@NotNull PsiElement context, @NotNull String keyClass, @NotNull String valueClass) {
        PsiClass mapKeyClass;
        PsiClass valuePsiClass;
        PsiClassType mapValueType;
        if (context == null) {
            ELResolveUtil.$$$reportNull$$$0(1);
        }
        if (keyClass == null) {
            ELResolveUtil.$$$reportNull$$$0(2);
        }
        if (valueClass == null) {
            ELResolveUtil.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scope = TagImplicitVariable.getElementDependenciesScope(context);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        PsiClass mapClass = facade.findClass("java.util.Map", scope);
        PsiElementFactory elementFactory = facade.getElementFactory();
        if (mapClass == null) {
            return elementFactory.createTypeByFQClassName("java.util.Map");
        }
        int arrIndex = valueClass.indexOf("[]");
        if (arrIndex != -1) {
            valueClass = valueClass.substring(0, arrIndex);
        }
        PsiClassType psiClassType = mapValueType = (valuePsiClass = facade.findClass(valueClass, scope)) != null ? elementFactory.createType(valuePsiClass) : elementFactory.createTypeByFQClassName(valueClass);
        if (arrIndex != -1) {
            mapValueType = new PsiArrayType((PsiType)mapValueType);
        }
        PsiClassType keyType = (mapKeyClass = facade.findClass(keyClass, scope)) != null ? elementFactory.createType(mapKeyClass) : elementFactory.createTypeByFQClassName(keyClass);
        PsiSubstitutor rawSubstitutor = elementFactory.createRawSubstitutor((PsiTypeParameterListOwner)mapClass);
        PsiSubstitutor psiSubstitutor = rawSubstitutor.putAll(mapClass, new PsiType[]{keyType, mapValueType});
        return elementFactory.createType(mapClass, psiSubstitutor);
    }

    public static boolean isFromInjectedEL(ELExpression variable) {
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)variable, ELExpressionHolder.class);
        assert (expressionHolder != null);
        PsiElement parent = expressionHolder.getParent();
        if (parent instanceof PsiFile) {
            return true;
        }
        return parent.getParent() instanceof PsiFile;
    }

    @Nullable
    public static FunctionDescriptor getFunctionDescriptor(ELCallExpression functionExpr) {
        if (functionExpr != null) {
            ELVariable method = functionExpr.getMethod();
            if (method == null) {
                return null;
            }
            PsiElement element = method.getReferences()[0].resolve();
            if (element instanceof XmlTag) {
                return ELReference.getFunctionDescriptor((XmlTag)element);
            }
        }
        return null;
    }

    public static Map<String, JspImplicitVariable> createOrGetPredefinedVariablesMapImpl(PsiFile file, VariableInfoData data) {
        return (Map)((CachedValue)ourCachedPredefinedVarsCache.get(data.cachingKey, (UserDataHolder)file, (Object)data)).getValue();
    }

    private static void evaluate(PsiType type, ELElementProcessor processor, @NotNull MethodSignatureFilter methodSignature) {
        String qualifiedName;
        if (methodSignature == null) {
            ELResolveUtil.$$$reportNull$$$0(4);
        }
        if (!(type instanceof PsiClassType) || !type.isValid()) {
            return;
        }
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            return;
        }
        PsiElement parent = psiClass.getParent();
        if (parent instanceof PsiJavaFile && SERVLET_PACKAGE.equals(qualifiedName = ((PsiJavaFile)parent).getPackageName())) {
            for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)psiClass, (boolean)false)) {
                if (inheritor.getName() == null || inheritor.getQualifiedName() == null || inheritor.getName().endsWith(WRAPPER_CLASS_SUFFIX) || !inheritor.getQualifiedName().startsWith(SERVLET_HTTP_PACKAGE)) continue;
                psiClass = inheritor;
                break;
            }
        }
        PsiSubstitutor mySubstitutor = classResolveResult.getSubstitutor();
        mySubstitutor = TagImplicitVariable.fillSubstitutionMapFromSupers(psiClass, mySubstitutor);
        processor.setSubstitutor(mySubstitutor);
        ELResolveUtil.iterateClassProperties(psiClass, processor, methodSignature);
    }

    private static boolean iterateClassProperties(PsiClass psiClass, ELElementProcessor processor, @NotNull MethodSignatureFilter signature) {
        PsiMethod[] methods;
        PsiModifierList modifierList;
        if (signature == null) {
            ELResolveUtil.$$$reportNull$$$0(5);
        }
        boolean myClassIsAbstract = psiClass.isInterface() || (modifierList = psiClass.getModifierList()) != null && modifierList.hasModifierProperty("abstract");
        for (PsiMethod psiMethod : methods = MethodResolveProcessor.getAllMethods((PsiClass)psiClass)) {
            if (!psiMethod.hasModifierProperty("public") || psiMethod.isConstructor() || !myClassIsAbstract && psiMethod.hasModifierProperty("abstract") || !signature.isAcceptable(psiMethod) || processor.processMethod(psiMethod)) continue;
            return false;
        }
        if (signature.shouldProcessFields()) {
            for (PsiMethod psiMethod : psiClass.getAllFields()) {
                if (processor.processField((PsiField)psiMethod)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean iterateClassProperties(PsiClass psiClass, ELElementProcessor processor, boolean readable) {
        return ELResolveUtil.iterateClassProperties(psiClass, processor, new PropertyAccessorMethodSignatureFilter(readable));
    }

    @Nullable
    private static PsiType getContextType(@Nullable PsiElement resolvedContext) {
        if (resolvedContext == null) {
            return null;
        }
        if (resolvedContext instanceof PsiExpression && !(resolvedContext instanceof PsiLiteralExpression)) {
            return ((PsiExpression)resolvedContext).getType();
        }
        if (resolvedContext instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)resolvedContext;
            PsiType type = psiMethod.getReturnType();
            PsiSubstitutor psiSubstitutor = (PsiSubstitutor)psiMethod.getUserData(SUBSTITUTOR);
            if (psiSubstitutor != null) {
                while (type instanceof PsiClassReferenceType) {
                    PsiType originalType = type;
                    PsiClassType.ClassResolveResult classResolveResult = ((PsiClassReferenceType)originalType).resolveGenerics();
                    PsiClass returnedPsiClass = classResolveResult.getElement();
                    if (!(returnedPsiClass instanceof PsiTypeParameter)) {
                        PsiTypeParameter[] returnedClassTypeParameters;
                        if (returnedPsiClass == null || (returnedClassTypeParameters = returnedPsiClass.getTypeParameters()).length == 0) break;
                        String qName = returnedPsiClass.getQualifiedName();
                        StringBuilder builder = new StringBuilder();
                        builder.append(qName).append('<');
                        int builderLengthBeforeAppendingTypeParameters = builder.length();
                        LinkedHashSet<PsiTypeParameter> paramsUsedInMethodReturnType = new LinkedHashSet<PsiTypeParameter>();
                        for (PsiType substitutionType : classResolveResult.getSubstitutor().getSubstitutionMap().values()) {
                            PsiClass psiClass;
                            if (!(substitutionType instanceof PsiClassType) || !((psiClass = ((PsiClassType)substitutionType).resolve()) instanceof PsiTypeParameter)) continue;
                            paramsUsedInMethodReturnType.add((PsiTypeParameter)psiClass);
                        }
                        if (paramsUsedInMethodReturnType.isEmpty()) break;
                        for (PsiTypeParameter containingClassTypeParameter : paramsUsedInMethodReturnType) {
                            PsiType psiType;
                            if (builderLengthBeforeAppendingTypeParameters != builder.length()) {
                                builder.append(',');
                            }
                            builder.append((psiType = psiSubstitutor.substitute(containingClassTypeParameter)) != null ? psiType.getCanonicalText() : "java.lang.Object");
                        }
                        builder.append('>');
                        try {
                            return JavaPsiFacade.getInstance((Project)returnedPsiClass.getProject()).getElementFactory().createTypeFromText(builder.toString(), null);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.warn((Throwable)e);
                            return null;
                        }
                    }
                    type = psiSubstitutor.substitute((PsiTypeParameter)returnedPsiClass);
                    if (type != null) continue;
                    type = psiSubstitutor.substitute(originalType);
                }
            }
            return type;
        }
        if (resolvedContext instanceof PsiVariable) {
            return (PsiType)RecursionManager.doPreventingRecursion((Object)resolvedContext, (boolean)true, () -> ((PsiVariable)resolvedContext).getType());
        }
        return (PsiType)resolvedContext.getUserData(EL_VARS_TYPE);
    }

    public static boolean allowPropertyMethodName(PsiElement element1) {
        String text;
        PsiElement parent = element1.getParent();
        if (ELResolveUtil.canBeRootMethodExpression(parent)) {
            return true;
        }
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)parent, ELExpressionHolder.class);
        if (expressionHolder != null && !expressionHolder.isJSFELHolder()) {
            return false;
        }
        return parent instanceof ELSelectExpression && ((text = element1.getText()).startsWith("get") || text.startsWith("set") || text.startsWith("is"));
    }

    private static boolean canBeRootMethodExpression(PsiElement parent) {
        if (parent instanceof ELExpressionHolder) {
            return true;
        }
        if (parent instanceof ELUnaryExpression && parent.getParent() instanceof ELMethodCallExpression) {
            return true;
        }
        return parent instanceof ELBinaryExpression && parent.getParent() instanceof ELExpressionHolder;
    }

    public static boolean allowMethodNameCompletion(PsiElement element) {
        return !ELResolveUtil.isJspContext(element) || ELResolveUtil.isNewJsp(element);
    }

    public static boolean allowMethodParameters(ELExpression element, PsiMethod method) {
        ELContextProvider elContextData;
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ELExpressionHolder.class);
        if (expressionHolder != null && (elContextData = ELResolveUtil.getELContextData(expressionHolder)) instanceof ElContextProviderEx) {
            return elContextData.allowMethodParameters(element, method);
        }
        return ELResolveUtil.isNewJsp((PsiElement)element);
    }

    private static boolean isNewJsp(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return true;
        }
        return JspManager.getInstance((Project)element.getProject()).getJspVersion((PsiFileSystemItem)containingFile).betterThan(JspVersion.JSP_2_1);
    }

    private static boolean isJspContext(PsiElement element) {
        PsiElement parent = element.getParent();
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)parent, ELExpressionHolder.class);
        return expressionHolder != null && !expressionHolder.isJSFELHolder();
    }

    @Nullable
    public static PsiType resolveContextAsType(ELExpression context) {
        if (context instanceof ELSelectExpression) {
            PsiType fromResolved;
            PsiType componentType;
            PsiType type;
            ELSelectExpression expression = (ELSelectExpression)context;
            ELVariable field = expression.getField();
            PsiType psiType = type = field != null ? ELResolveUtil.getContextType(field.getReferences()[0].resolve()) : null;
            if (type == null && field != null && (componentType = TagImplicitVariable.evaluateComponentType(fromResolved = ELResolveUtil.resolveContextAsType(expression.getFrom()), (PsiElement)context)) != null) {
                return componentType;
            }
            return type;
        }
        if (context instanceof ELMethodCallExpression) {
            ELVariable field = ((ELMethodCallExpression)context).getMethod();
            return field != null ? ELResolveUtil.getContextType(field.getReferences()[0].resolve()) : null;
        }
        if (context instanceof ELVariable) {
            PsiElement resolve = context.getReferences()[0].resolve();
            if (resolve instanceof PsiClass) {
                context.putUserData(STATIC_CONTEXT, Boolean.TRUE);
                return PsiTypesUtil.getClassType((PsiClass)((PsiClass)resolve));
            }
            context.putUserData(STATIC_CONTEXT, null);
            return ELResolveUtil.getContextType(resolve);
        }
        if (context instanceof ELSliceExpression) {
            PsiType fromResolved = ELResolveUtil.resolveContextAsType(((ELSliceExpression)context).getFrom());
            ELExpression index = ((ELSliceExpression)context).getIndex();
            if (fromResolved != null) {
                PsiType componentType = TagImplicitVariable.evaluateComponentType(fromResolved, (PsiElement)context);
                if (componentType != null) {
                    return componentType;
                }
                if (index instanceof ELLiteralExpression) {
                    final PsiType[] result = new PsiType[1];
                    final String text = index.getText();
                    ELResolveUtil.evaluate(fromResolved, new ELElementProcessor(){
                        private PsiSubstitutor mySubstitutor;

                        @Override
                        public boolean processNSPrefix(String prefix) {
                            return true;
                        }

                        @Override
                        public boolean processVariable(PsiVariable variable) {
                            if (text.equals(variable.getName())) {
                                result[0] = variable.getType();
                                return false;
                            }
                            return true;
                        }

                        @Override
                        public boolean processMethod(PsiMethod method) {
                            if (text.equals(PropertyUtilBase.getPropertyName((PsiMethod)method))) {
                                PsiType returnType = method.getReturnType();
                                result[0] = this.mySubstitutor != null ? this.mySubstitutor.substitute(returnType) : returnType;
                                return false;
                            }
                            return true;
                        }

                        @Override
                        public boolean processField(PsiField field) {
                            if (text.equals(field.getName())) {
                                result[0] = field.getType();
                                return false;
                            }
                            return true;
                        }

                        @Override
                        public boolean processProperty(IProperty property) {
                            return !text.equals(property.getName());
                        }

                        @Override
                        public void setSubstitutor(PsiSubstitutor substitutor) {
                            this.mySubstitutor = substitutor;
                        }

                        @Override
                        @Nullable
                        public String getNameHint() {
                            return text;
                        }
                    }, new PropertyAccessorMethodSignatureFilter(true));
                    return result[0];
                }
            }
        } else if (context instanceof ELFunctionCallExpression) {
            FunctionDescriptor descriptor;
            PsiMetaData metaData;
            ELVariable method = ((ELFunctionCallExpression)context).getMethod();
            if (method == null) {
                return null;
            }
            PsiElement psiElement = method.getReferences()[0].resolve();
            if (psiElement instanceof XmlTag && (metaData = ((XmlTag)psiElement).getMetaData()) instanceof FunctionDescriptor && (descriptor = (FunctionDescriptor)metaData).getFunctionReturnType() != null) {
                return JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeByFQClassName(descriptor.getFunctionReturnType(), GlobalSearchScope.allScope((Project)context.getProject()));
            }
        } else {
            Class typeClass;
            if (context instanceof TypedELExpression) {
                return ((TypedELExpression)context).getType();
            }
            if (context instanceof ELExpressionBase && (typeClass = ((ELExpressionBase)context).getTypeClass()) != null) {
                return PsiType.getTypeByName((String)typeClass.getName(), (Project)context.getProject(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)context.getProject()));
            }
        }
        return null;
    }

    public static void process(PsiElement element, ELElementProcessor processor) {
        ELExpression context = ELResolveUtil.getContext(element);
        if (context == null) {
            ELLambdaExpression lambdaExpression = (ELLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ELLambdaExpression.class);
            if (lambdaExpression != null) {
                for (ELVariable variable : lambdaExpression.getVariables()) {
                    processor.processVariable(variable);
                }
            }
            ELResolveUtil.processEmptyContext(element, processor);
        } else {
            boolean b;
            PsiElement contextResolve;
            ELVariable field;
            PsiReference[] references = context.getReferences();
            if (context instanceof ELSelectExpression && (field = ((ELSelectExpression)context).getField()) != null) {
                references = field.getReferences();
            }
            PsiElement psiElement = contextResolve = references.length > 0 ? references[0].resolve() : null;
            if (contextResolve instanceof JspImplicitVariableWithCustomResolve && (b = ((JspImplicitVariableWithCustomResolve)contextResolve).process((ELExpression)element, processor))) {
                return;
            }
            PsiType resolvedContext = ELResolveUtil.resolveContextAsType(context);
            if (resolvedContext != null) {
                if (resolvedContext instanceof PsiClassType && resolvedContext.isValid()) {
                    String qName;
                    PsiClassType[] classTypes;
                    PsiReferenceList list;
                    PsiClass psiClass;
                    PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)resolvedContext).resolveGenerics();
                    PsiClass psiClass2 = psiClass = classResolveResult.isValidResult() ? classResolveResult.getElement() : null;
                    if (psiClass instanceof PsiTypeParameter && (list = psiClass.getExtendsList()) != null && (classTypes = list.getReferencedTypes()).length > 0) {
                        resolvedContext = classTypes[0];
                        psiClass = ((PsiClassType)resolvedContext).resolve();
                    }
                    String string = qName = psiClass != null ? psiClass.getQualifiedName() : null;
                    if ("java.util.PropertyResourceBundle".equals(qName) || "java.util.Properties".equals(qName)) {
                        ELResolveUtil.processProperties(element, processor);
                    } else if (element.getParent() instanceof ELSliceExpression && psiClass != null && ELResolveUtil.isMapOrListSpecialType(psiClass, element.getContainingFile())) {
                        ELResolveUtil.processEmptyContext(element, processor);
                    } else if (!(element.getParent() instanceof ELSliceExpression) || !(element instanceof ELVariable)) {
                        MethodSignatureFilter signature = ELResolveUtil.getMethodSignatureFilter(element, context);
                        ELResolveUtil.evaluate(resolvedContext, processor, signature);
                        if (element instanceof ELLiteralExpression) {
                            ELResolveUtil.processProperties(element, processor);
                        }
                    }
                } else if (resolvedContext instanceof PsiArrayType) {
                    ELResolveUtil.processEmptyContext(element, processor);
                }
            } else if (element instanceof ELLiteralExpression) {
                ELResolveUtil.processProperties(element, processor);
            }
        }
    }

    private static void processProperties(PsiElement element, ELElementProcessor processor) {
        PsiManager psiManager = element.getManager();
        String key = processor.getNameHint();
        if (key != null) {
            IProperty property;
            Iterator iterator = PropertiesImplUtil.findPropertiesByKey((Project)psiManager.getProject(), (String)key).iterator();
            while (iterator.hasNext() && processor.processProperty(property = (IProperty)iterator.next())) {
            }
            return;
        }
        PropertiesReferenceManager.getInstance((Project)element.getProject()).processAllPropertiesFiles((baseName, propertiesFile) -> {
            for (IProperty property : propertiesFile.getProperties()) {
                if (processor.processProperty(property)) continue;
                return false;
            }
            return true;
        });
    }

    private static MethodSignatureFilter getMethodSignatureFilter(PsiElement element, ELExpression context) {
        ELExpressionHolder holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ELExpressionHolder.class);
        assert (holder != null);
        final ELContextProvider contextProvider = ELResolveUtil.getELContextData(holder);
        if (contextProvider != null) {
            return new MethodSignatureFilter(){

                @Override
                public boolean isAcceptable(PsiMethod method) {
                    boolean propertyGetter = PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method);
                    if (contextProvider.acceptsGetMethodForLastReference(method) && propertyGetter) {
                        return true;
                    }
                    boolean propertySetter = PropertyUtilBase.isSimplePropertySetter((PsiMethod)method);
                    if (contextProvider.acceptsSetMethodForLastReference(method) && propertySetter) {
                        return true;
                    }
                    return contextProvider.acceptsNonPropertyMethodForLastReference(method) && !propertyGetter && !propertySetter;
                }

                @Override
                public boolean shouldProcessFields() {
                    return contextProvider instanceof ElContextProviderEx ? ((ElContextProviderEx)contextProvider).shouldProcessFields() : super.shouldProcessFields();
                }
            };
        }
        Boolean staticContext = (Boolean)context.getUserData(STATIC_CONTEXT);
        if (staticContext != null) {
            return new MethodSignatureFilter(){

                @Override
                public boolean isAcceptable(PsiMethod method) {
                    return method.hasModifierProperty("static");
                }

                @Override
                public boolean shouldProcessFields() {
                    return true;
                }
            };
        }
        return ELResolveUtil.isJspContext(element) ? new MethodSignatureFilter(){

            @Override
            public boolean isAcceptable(PsiMethod method) {
                if (method.hasModifierProperty("static")) {
                    return false;
                }
                return !PropertyUtilBase.isSimplePropertySetter((PsiMethod)method);
            }

            @Override
            @Nullable
            public String getSignature() {
                return null;
            }
        } : MethodSignatureFilter.ANY;
    }

    private static void processEmptyContext(PsiElement element, ELElementProcessor processor) {
        ELExpressionHolder expressionHolder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ELExpressionHolder.class);
        assert (expressionHolder != null);
        if (ELResolveUtil.processJavaClasses(processor, expressionHolder) || processor.getTargetClass() == PsiClass.class) {
            return;
        }
        ELContextProvider data = ELResolveUtil.getELContextData(expressionHolder);
        if (data != null) {
            String nameHint = processor.getNameHint();
            Iterator<? extends PsiVariable> iterator = data.getTopLevelElVariables(nameHint);
            if (iterator != null) {
                while (iterator.hasNext() && processor.processVariable(iterator.next())) {
                }
            }
            Collection<PsiMethod> methods = data.getRootMethods(nameHint);
            for (PsiMethod method : methods) {
                if (!processor.processMethod(method)) break;
            }
            if (iterator != null || methods.size() > 0) {
                return;
            }
        }
        for (ElVariablesProvider provider : ELResolveUtil.getProviders()) {
            if (provider.processImplicitVariables(element, expressionHolder, processor)) continue;
            return;
        }
    }

    private static boolean processJavaClasses(ELElementProcessor processor, ELExpressionHolder expressionHolder) {
        PsiImportList importList;
        PsiFile file = expressionHolder.getContainingFile();
        PsiJavaFile javaFile = (PsiJavaFile)file.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE);
        if (javaFile != null && (importList = javaFile.getImportList()) != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement resolve = statement.resolve();
                if (!(resolve instanceof PsiClass) || processor.processClass((PsiClass)resolve, statement)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static ELContextProvider getELContextData(@NotNull ELExpressionHolder expressionHolder) {
        if (expressionHolder == null) {
            ELResolveUtil.$$$reportNull$$$0(6);
        }
        ELContextProvider data = (ELContextProvider)expressionHolder.getUserData(ELContextProvider.ourContextProviderKey);
        PsiElement expressionHolderParent = expressionHolder.getParent();
        if (data == null && expressionHolderParent instanceof ELExpressionHolder) {
            expressionHolder = (ELExpressionHolder)expressionHolderParent;
            expressionHolderParent = expressionHolder.getParent();
        }
        if (data == null && expressionHolderParent instanceof PsiFile) {
            PsiElement context = expressionHolderParent.getContext();
            ELContextProvider eLContextProvider = data = context != null ? (ELContextProvider)context.getUserData(ELContextProvider.ourContextProviderKey) : null;
            if (data == null) {
                data = (ELContextProvider)expressionHolderParent.getUserData(ELContextProvider.ourContextProviderKey);
            }
        }
        if (data == null) {
            for (ElContextProviderEx contextProvider : ElContextProviderEx.EXTENSION_POINT.getExtensionList()) {
                if (!contextProvider.accept(expressionHolder)) continue;
                return contextProvider;
            }
        }
        return data;
    }

    static List<ElVariablesProvider> getProviders() {
        SmartList list = new SmartList();
        ContainerUtil.addAll((Collection)list, (Iterable)ElVariablesProvider.JSP_EL_IMPLICIT_VARIABLES_PROVIDER_EXTENSION_POINT.getExtensionList());
        list.add((Object)ourJspElVariablesProvider);
        return list;
    }

    public static XmlTag getParentTagToStartResolving(PsiElement element, ELExpressionHolder expressionHolder) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (tag != null && expressionHolder.getParent() instanceof XmlAttributeValue) {
            tag = tag.getParentTag();
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean walkFromContext(@Nullable XmlTag tag, ELElementProcessor processor, NotNullFunction<XmlTag, String> defaultVarTypeProvider, PsiElement expressionHolder) {
        PsiFile psiFile;
        String attrName;
        int childIndexOffset;
        XmlTag prevContextTag;
        XmlTag nearestTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)expressionHolder, XmlTag.class);
        MyXmlTagProcessor tagProcessor = null;
        if (expressionHolder.getParent() == tag) {
            prevContextTag = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)expressionHolder, XmlTag.class);
            childIndexOffset = 0;
        } else {
            prevContextTag = nearestTag != null ? (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)nearestTag, XmlTag.class) : null;
            childIndexOffset = 0;
        }
        if (expressionHolder.getParent() instanceof XmlAttributeValue && nearestTag != null && nearestTag.isEmpty() && nearestTag.getAttributeValue("var") != null && !"value".equals(attrName = ((XmlAttribute)expressionHolder.getParent().getParent()).getName()) && !ITEMS_ATTR_NAME.equals(attrName)) {
            tagProcessor = new MyXmlTagProcessor(defaultVarTypeProvider, processor);
            nearestTag.accept((PsiElementVisitor)tagProcessor);
            if (tagProcessor.result) {
                return false;
            }
        }
        XmlTag contextTag = tag;
        while (contextTag != null) {
            int indexOfPrevContextInParent = -1;
            XmlTag[] subTags = contextTag.getSubTags();
            if (prevContextTag != null) {
                for (XmlTag subTag : subTags) {
                    ++indexOfPrevContextInParent;
                    if (subTag != prevContextTag) {
                        continue;
                    }
                    break;
                }
            } else {
                indexOfPrevContextInParent = subTags.length;
            }
            if (indexOfPrevContextInParent < subTags.length) {
                if (tagProcessor == null) {
                    tagProcessor = new MyXmlTagProcessor(defaultVarTypeProvider, processor);
                }
                for (int i = indexOfPrevContextInParent - childIndexOffset; i >= 0; --i) {
                    subTags[i].accept((PsiElementVisitor)tagProcessor);
                    if (!tagProcessor.result) continue;
                    return false;
                }
            }
            childIndexOffset = 1;
            if (ELResolveUtil.doEval(contextTag, defaultVarTypeProvider, processor, true)) {
                return false;
            }
            prevContextTag = contextTag;
            contextTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)contextTag, XmlTag.class);
        }
        PsiFile psiFile2 = psiFile = tag != null ? tag.getContainingFile() : expressionHolder.getContainingFile();
        if (psiFile instanceof JspFile && psiFile == expressionHolder.getContainingFile()) {
            if (VISITED.get().add(psiFile)) {
                if (tagProcessor == null) {
                    tagProcessor = new MyXmlTagProcessor(defaultVarTypeProvider, processor);
                }
                try {
                    JspUtil.visitAllIncludedFilesRecursively((JspFile)psiFile, tagProcessor, false);
                }
                finally {
                    VISITED.get().remove(psiFile);
                }
                if (tagProcessor.result) {
                    return false;
                }
            } else {
                LOG.error("Recursion occurred", new Throwable());
            }
        }
        return true;
    }

    private static boolean doEval(XmlTag contextTag, NotNullFunction<XmlTag, String> defaultVarTypeProvider, ELElementProcessor processor, boolean insideOut) {
        List<JspImplicitVariable> variables = ELResolveUtil.createOrGetVariables(contextTag, defaultVarTypeProvider);
        if (variables != null) {
            boolean processedParent = false;
            for (JspImplicitVariable variable : variables) {
                int declarationRange = variable.getDeclarationRange();
                if ((!insideOut || (declarationRange & 1) == 0) && (insideOut || (declarationRange & 2) == 0)) continue;
                PsiElement declarationScope = variable.getDeclarationScope();
                if (declarationScope instanceof XmlTag && processor.getNameHint() != null && ((XmlTag)declarationScope).getValue().getTextRange().getLength() == 0 && !processedParent) {
                    processedParent = true;
                    PsiElement parent = declarationScope.getParent();
                    if (parent instanceof XmlTag && ELResolveUtil.doEval((XmlTag)parent, defaultVarTypeProvider, processor, true)) {
                        return true;
                    }
                }
                if (processor.processVariable((PsiVariable)variable)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/jsp/el/impl/ELResolveUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/el/impl/ELResolveUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypedMapType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateClassProperties";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getELContextData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PropertyAccessorMethodSignatureFilter
    extends MethodSignatureFilter {
        private final boolean myReadable;

        PropertyAccessorMethodSignatureFilter(boolean readable) {
            this.myReadable = readable;
        }

        @Override
        public boolean isAcceptable(PsiMethod method) {
            if (method.hasModifierProperty("static")) {
                return false;
            }
            return this.myReadable ? PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method) : PropertyUtilBase.isSimplePropertySetter((PsiMethod)method);
        }

        @Override
        @Nullable
        public String getSignature() {
            return null;
        }
    }

    private static class MyXmlTagProcessor
    extends XmlRecursiveElementVisitor
    implements Processor<JspFile> {
        private final NotNullFunction<XmlTag, String> myDefaultVarTypeProvider;
        private final ELElementProcessor myProcessor;
        boolean result;

        MyXmlTagProcessor(NotNullFunction<XmlTag, String> defaultVarTypeProvider, ELElementProcessor processor) {
            this.myDefaultVarTypeProvider = defaultVarTypeProvider;
            this.myProcessor = processor;
        }

        public void visitXmlTag(XmlTag tag) {
            if (!ELResolveUtil.doEval(tag, (NotNullFunction<XmlTag, String>)this.myDefaultVarTypeProvider, this.myProcessor, false)) {
                for (XmlTag subTag : tag.getSubTags()) {
                    subTag.accept((PsiElementVisitor)this);
                    if (!this.result) {
                        continue;
                    }
                    break;
                }
            } else {
                this.result = true;
            }
        }

        public boolean process(JspFile jspFile) {
            if (!this.result) {
                this.visitFile((PsiFile)jspFile);
            }
            return !this.result;
        }
    }

    public static class VariableInfoData {
        final Key<CachedValue<Map<String, JspImplicitVariable>>> cachingKey;
        private final List<VariableInfoBean> myVars = new ArrayList<VariableInfoBean>();

        public VariableInfoData(Key<CachedValue<Map<String, JspImplicitVariable>>> _cachingKey) {
            this.cachingKey = _cachingKey;
        }

        public void add(String name, String type) {
            this.add(name, type, false);
        }

        public void add(String name, String type, boolean mapValue) {
            this.myVars.add(new VariableInfoBean(name, type, mapValue));
        }
    }

    public static class VariableInfoBean {
        private final String name;
        private final String type;
        private final boolean mapValue;

        private VariableInfoBean(String name, String type) {
            this(name, type, false);
        }

        private VariableInfoBean(String name, String type, boolean mapValue) {
            this.name = name;
            this.type = type;
            this.mapValue = mapValue;
        }

        public static VariableInfoBean create(String name, String type) {
            return new VariableInfoBean(name, type);
        }

        public static VariableInfoBean create(String name, String type, boolean mapvalue) {
            return new VariableInfoBean(name, type, mapvalue);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isMapValue() {
            return this.mapValue;
        }
    }
}

