/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagdirSupport {
    @NonNls
    public static final String TAG_EXTENSION = "tag";
    @NonNls
    public static final String TAGX_EXTENSION = "tagx";
    @NonNls
    public static final String WEB_INF = "/WEB-INF/";
    private static final Key<VirtualFilePointer[]> DIRECTORIES_KEY = Key.create((String)"TagDirOriginalDirs");

    @Nullable
    public static XmlFile getImplicitTagLibForTagDir(String tagdir, PsiManager manager, WebDirectoryElement directoryElement) {
        return TagdirSupport.getImplicitTagLibForTagDir(tagdir, manager, directoryElement.getOriginalVirtualFiles());
    }

    @Nullable
    public static XmlFile getImplicitTagLibForTagDir(String tagdir, PsiManager manager, @NotNull List<? extends VirtualFile> directories) {
        if (directories == null) {
            TagdirSupport.$$$reportNull$$$0(0);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<taglib>\n<tlib-version>1.0</tlib-version>\n<short-name>").append(tagdir.substring(WEB_INF.length()).replace('/', '-'));
        buf.append("</short-name>\n");
        buf.append("<uri>").append("urn:jsptagdir:");
        buf.append(tagdir);
        buf.append("</uri>");
        for (VirtualFile virtualFile2 : directories) {
            VirtualFile[] children;
            for (VirtualFile child : children = virtualFile2.getChildren()) {
                String extension = child.getExtension();
                if (!TAG_EXTENSION.equals(extension) && !TAGX_EXTENSION.equals(extension)) continue;
                buf.append("  <tag-file>\n");
                buf.append("    <name>");
                buf.append(child.getNameWithoutExtension());
                buf.append("</name>\n");
                buf.append("    <path>");
                buf.append(child.getPresentableUrl());
                buf.append("</path>\n");
                buf.append("  </tag-file>\n");
            }
        }
        buf.append("</taglib>");
        PsiFile file = PsiFileFactory.getInstance((Project)manager.getProject()).createFileFromText("__unnamed.tld", buf.toString());
        if (file instanceof XmlFile) {
            file.putUserData(DIRECTORIES_KEY, (Object)ContainerUtil.map2Array(directories, VirtualFilePointer.class, virtualFile -> VirtualFilePointerManager.getInstance().create(virtualFile, (Disposable)file.getProject(), null)));
            return (XmlFile)file;
        }
        return null;
    }

    @Nullable
    public static List<VirtualFile> getTagFiles(XmlFile xmlFile) {
        Object[] pointers = (VirtualFilePointer[])xmlFile.getUserData(DIRECTORIES_KEY);
        return pointers == null ? null : ContainerUtil.mapNotNull((Object[])pointers, (Function)((NullableFunction)virtualFilePointer -> virtualFilePointer.getFile()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/psi/impl/source/jsp/TagdirSupport", "getImplicitTagLibForTagDir"));
    }
}

