/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.jsp.impl.FunctionDescriptorImpl;
import com.intellij.jsp.impl.JspElementDescriptor;
import com.intellij.jsp.impl.JspElementDescriptorEx;
import com.intellij.jsp.impl.JspValidationContext;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.jsp.impl.TldTagDescriptorImpl;
import com.intellij.jsp.impl.TldTagFileDescriptorImpl;
import com.intellij.jsp.impl.UserClassLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SimpleFieldCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.TagdirSupport;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TldDescriptorImpl
implements TldDescriptor,
DumbAware {
    private static final Logger LOG = Logger.getInstance(TldDescriptorImpl.class);
    private static final TObjectHashingStrategy<ValidationMessage> VALIDATION_MESSAGE_HASHING_STRATEGY = new TObjectHashingStrategy<ValidationMessage>(){

        public int computeHashCode(ValidationMessage object) {
            return object.getId() == null ? 0 : object.getId().hashCode();
        }

        public boolean equals(ValidationMessage o1, ValidationMessage o2) {
            return Comparing.equal((String)o1.getId(), (String)o2.getId()) && Comparing.equal((String)o1.getMessage(), (String)o2.getMessage());
        }
    };
    private XmlFile myFile;
    private XmlElement myElement;
    private boolean hasValidatorProblems;
    private static final SimpleFieldCache<CachedValue<Map<String, XmlElementDescriptor>>, TldDescriptorImpl> myCachedDeclsCache = new SimpleFieldCache<CachedValue<Map<String, XmlElementDescriptor>>, TldDescriptorImpl>(){

        protected final CachedValue<Map<String, XmlElementDescriptor>> compute(TldDescriptorImpl tldDescriptor) {
            return tldDescriptor.doCreateCachedMethods();
        }

        protected final CachedValue<Map<String, XmlElementDescriptor>> getValue(TldDescriptorImpl tldDescriptor) {
            return tldDescriptor.myCachedDecls;
        }

        protected final void putValue(CachedValue<Map<String, XmlElementDescriptor>> cachedValue, TldDescriptorImpl tldDescriptor) {
            tldDescriptor.myCachedDecls = cachedValue;
        }
    };
    private volatile CachedValue<Map<String, XmlElementDescriptor>> myCachedDecls;
    private static final SimpleFieldCache<CachedValue<Map<String, FunctionDescriptorImpl>>, TldDescriptorImpl> myCachedFuncsCache = new SimpleFieldCache<CachedValue<Map<String, FunctionDescriptorImpl>>, TldDescriptorImpl>(){

        protected final CachedValue<Map<String, FunctionDescriptorImpl>> compute(TldDescriptorImpl tldDescriptor) {
            return tldDescriptor.doBuildCachedFuncs();
        }

        protected final CachedValue<Map<String, FunctionDescriptorImpl>> getValue(TldDescriptorImpl tldDescriptor) {
            return tldDescriptor.myCachedFuncs;
        }

        protected final void putValue(CachedValue<Map<String, FunctionDescriptorImpl>> cachedValue, TldDescriptorImpl tldDescriptor) {
            tldDescriptor.myCachedFuncs = cachedValue;
        }
    };
    private volatile CachedValue<Map<String, FunctionDescriptorImpl>> myCachedFuncs;
    private String myUri;
    private String myDefaultPrefix;
    private Object[] myDependencies;

    public TldDescriptorImpl() {
    }

    public TldDescriptorImpl(XmlTag dcl) {
        this.init((PsiElement)dcl);
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            TldDescriptorImpl.$$$reportNull$$$0(0);
        }
        return this.getElementDescriptor(tag.getLocalName());
    }

    public final XmlElementDescriptor getElementDescriptor(String name) {
        return this.buildDeclarationMap().get(name);
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        Collection<XmlElementDescriptor> descriptors = this.buildDeclarationMap().values();
        XmlElementDescriptor[] xmlElementDescriptorArray = descriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
        if (xmlElementDescriptorArray == null) {
            TldDescriptorImpl.$$$reportNull$$$0(1);
        }
        return xmlElementDescriptorArray;
    }

    public XmlFile getDescriptorFile() {
        return this.myFile;
    }

    public PsiElement getDeclaration() {
        return this.myElement;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myFile.getName();
    }

    public void init(PsiElement element) {
        this.myFile = (XmlFile)element.getContainingFile();
        this.myElement = (XmlElement)element;
        if (element instanceof XmlDocument) {
            this.myElement = ((XmlDocument)element).getRootTag();
        }
        List<VirtualFile> files = TagdirSupport.getTagFiles(this.myFile);
        this.myDependencies = this.myFile.isPhysical() || files == null ? new Object[]{this.myFile} : ContainerUtil.mapNotNull(files, virtualFile -> {
            PsiDirectory directory = this.myFile.getManager().findDirectory(virtualFile);
            LOG.assertTrue(directory != null, (Object)(virtualFile + " not found"));
            return directory;
        }).toArray();
    }

    @NotNull
    public Object[] getDependencies() {
        if (this.myDependencies == null) {
            TldDescriptorImpl.$$$reportNull$$$0(2);
        }
        return this.myDependencies;
    }

    private Map<String, FunctionDescriptorImpl> buildFunctionMap() {
        return (Map)((CachedValue)myCachedFuncsCache.get((Object)this)).getValue();
    }

    private CachedValue<Map<String, FunctionDescriptorImpl>> doBuildCachedFuncs() {
        return CachedValuesManager.getManager((Project)this.myElement.getProject()).createCachedValue(() -> {
            LinkedHashMap<String, FunctionDescriptorImpl> ret = new LinkedHashMap<String, FunctionDescriptorImpl>();
            XmlTag tag = (XmlTag)this.myElement;
            this.doBuildFunctionMap(tag, ret);
            return new CachedValueProvider.Result(ret, new Object[]{this.myFile});
        }, false);
    }

    protected void doBuildFunctionMap(XmlTag tag, Map<String, FunctionDescriptorImpl> ret) {
        XmlTag[] subTags;
        for (XmlTag subTag : subTags = tag.findSubTags("function", null)) {
            FunctionDescriptorImpl value = new FunctionDescriptorImpl(subTag);
            String name = value.getName();
            if (name == null) continue;
            ret.put(name, value);
        }
    }

    private Map<String, XmlElementDescriptor> buildDeclarationMap() {
        return (Map)((CachedValue)myCachedDeclsCache.get((Object)this)).getValue();
    }

    private CachedValue<Map<String, XmlElementDescriptor>> doCreateCachedMethods() {
        return CachedValuesManager.getManager((Project)this.myElement.getProject()).createCachedValue(() -> {
            LinkedHashMap<String, XmlElementDescriptor> ret = new LinkedHashMap<String, XmlElementDescriptor>();
            this.doBuildDeclarationsMap((XmlTag)this.myElement, ret);
            return new CachedValueProvider.Result(ret, new Object[]{this.myFile});
        }, false);
    }

    protected void doBuildDeclarationsMap(XmlTag tag, Map<String, XmlElementDescriptor> ret) {
        XmlTag[] subTags2;
        XmlTag[] subTags;
        for (XmlTag subTag : subTags = tag.findSubTags("tag", null)) {
            JspElementDescriptor value = this.createTagDescriptor(subTag);
            ret.put(value.getName(), (XmlElementDescriptor)value);
        }
        for (XmlTag aSubTags2 : subTags2 = tag.findSubTags("tag-file", null)) {
            TldTagFileDescriptorImpl value = new TldTagFileDescriptorImpl(aSubTags2, this);
            String name = value.getName();
            if (name == null || name.length() <= 0) continue;
            ret.put(name, (XmlElementDescriptor)value);
        }
    }

    protected JspElementDescriptor createTagDescriptor(XmlTag tag) {
        return new TldTagDescriptorImpl(tag);
    }

    public String getUri() {
        if (this.myUri == null) {
            XmlTag firstSubTag = ((XmlTag)this.myElement).findFirstSubTag("uri");
            this.myUri = firstSubTag != null ? firstSubTag.getValue().getTrimmedText() : null;
        }
        return this.myUri;
    }

    public String getDefaultPrefix() {
        if (this.myDefaultPrefix == null) {
            XmlTag firstSubTag = ((XmlTag)this.myElement).findFirstSubTag("short-name");
            if (firstSubTag == null) {
                firstSubTag = ((XmlTag)this.myElement).findFirstSubTag("shortname");
            }
            this.myDefaultPrefix = firstSubTag != null ? firstSubTag.getValue().getTrimmedText() : "";
        }
        return StringUtil.isEmpty((String)this.myDefaultPrefix) ? null : this.myDefaultPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(JspValidationContext context, Validator.ValidationHost host) {
        XmlTag validatorTag = ((XmlTag)this.myElement).findFirstSubTag("validator");
        XmlTag xmlTag = validatorTag = validatorTag != null ? validatorTag.findFirstSubTag("validator-class") : null;
        if (validatorTag != null && !this.hasValidatorProblems) {
            String validatorClassName = validatorTag.getValue().getTrimmedText();
            XmlTag tag = context.getRootTag();
            Module module = JspUtil.getModuleForPsiElement((PsiElement)tag);
            if (module == null) {
                return;
            }
            TagLibraryValidator validator = null;
            ValidationMessage[] validationMessages = null;
            try {
                Class aClass = UserClassLoader.loadClass(validatorClassName, module, (PsiFile)this.getDescriptorFile());
                if (aClass == null) {
                    throw new NoClassDefFoundError(validatorClassName);
                }
                validator = (TagLibraryValidator)aClass.newInstance();
                validator.setInitParameters(new HashMap());
                validationMessages = validator.validate(tag.getPrefixByNamespace(this.getUri()), this.getUri(), context.getPageData());
            }
            catch (Throwable t) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.warn(t);
                }
                this.hasValidatorProblems = true;
            }
            finally {
                if (validator != null) {
                    validator.release();
                }
            }
            if (validationMessages != null) {
                THashSet messages = new THashSet(Arrays.asList(validationMessages), VALIDATION_MESSAGE_HASHING_STRATEGY);
                for (ValidationMessage validationMessage : messages) {
                    String id = validationMessage.getId();
                    PsiElement elementById = context.getElementById(id);
                    if (elementById != null && TldDescriptorImpl.thereIsNoMentionAboutTag(validationMessage, (XmlTag)elementById) && id != null && validatorClassName.contains("org.apache.taglibs.standard.tlv")) {
                        PsiElement oldElementById = elementById;
                        elementById = context.getElementById(Integer.toString(Integer.parseInt(id) + 1));
                        if (elementById == null) {
                            elementById = oldElementById;
                        }
                    }
                    if (elementById == null) continue;
                    host.addMessage(elementById, validationMessage.getMessage(), Validator.ValidationHost.ErrorType.ERROR);
                }
            }
        }
    }

    private static boolean thereIsNoMentionAboutTag(ValidationMessage validationMessage, XmlTag tag) {
        return !validationMessage.getMessage().contains(tag.getLocalName());
    }

    public int getFunctionsCount() {
        return this.buildFunctionMap().size();
    }

    public FunctionDescriptor getFunctionDescriptor(String name) {
        return this.buildFunctionMap().get(name);
    }

    public String[] getFunctionNames() {
        Set<String> strings = this.buildFunctionMap().keySet();
        return ArrayUtil.toStringArray(strings);
    }

    public XmlFile getDeclarationFile() {
        return this.myFile;
    }

    public void resetClassloaderState() {
        this.hasValidatorProblems = false;
        for (XmlElementDescriptor descriptor : this.buildDeclarationMap().values()) {
            if (!(descriptor instanceof JspElementDescriptorEx)) continue;
            ((JspElementDescriptorEx)descriptor).resetClassloaderState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/impl/TldDescriptorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/impl/TldDescriptorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

