/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.jsp.el.impl.ELReference;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.jsp.el.ELElementVisitor;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.jsp.el.ELMethodCallExpression;
import com.intellij.psi.jsp.el.ELSelectExpression;
import com.intellij.psi.jsp.el.ELSliceExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ELValidationInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "ELValidationInJSP";

    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            ELValidationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            ELValidationInspection.$$$reportNull$$$0(1);
        }
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ELValidationInspection.$$$reportNull$$$0(2);
        }
        ELElementVisitor eLElementVisitor = new ELElementVisitor(){

            @Override
            public void visitELVariable(@NotNull ELVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(0);
                }
                ELValidationInspection.this.visitVariable(variable, isOnTheFly, holder);
            }

            @Override
            public void visitELLiteralExpression(@NotNull ELLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                ELValidationInspection.this.visitLiteral(expression, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/jsp/ELValidationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (eLElementVisitor == null) {
            ELValidationInspection.$$$reportNull$$$0(3);
        }
        return eLElementVisitor;
    }

    public void visitLiteral(ELLiteralExpression expression, ProblemsHolder holder) {
        PsiReference[] references = expression.getReferences();
        if (references.length == 0) {
            return;
        }
        PsiReference psiReference = references[0];
        if (!(psiReference.isSoft() || ELReference.isSoftContext(ELResolveUtil.getContext((PsiElement)expression), expression.getContainingFile()) || ((PsiPolyVariantReference)psiReference).multiResolve(false).length != 0 || ELResolveUtil.isFromInjectedEL(expression))) {
            String message = PsiBundle.message((String)"el.cannot.resolve.property", (Object[])new Object[]{psiReference.getCanonicalText()});
            holder.registerProblem((PsiElement)expression, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])null);
        }
    }

    public void visitVariable(ELVariable variable, boolean isOnTheFly, ProblemsHolder holder) {
        for (PsiReference reference : variable.getReferences()) {
            this.checkVariableReference(variable, reference, isOnTheFly, holder);
        }
    }

    protected void checkVariableReference(ELVariable variable, PsiReference reference1, boolean isOnTheFly, ProblemsHolder holder) {
        if (!(reference1 instanceof ELReference) || reference1.isSoft()) {
            return;
        }
        ELReference reference = (ELReference)reference1;
        ResolveResult[] results = reference.multiResolve(false);
        if (results.length == 0) {
            String message = reference.getUnresolvedMessagePattern();
            String id = reference.getCanonicalText();
            String formattedMessage = MessageFormat.format(message, id);
            LocalQuickFix[] fixes = null;
            if (!ELResolveUtil.isFromInjectedEL(variable) && ELResolveUtil.getContext((PsiElement)variable) == null && isOnTheFly) {
                PsiElement parentElement = variable.getParent();
                if (parentElement instanceof ELFunctionCallExpression) {
                    ELVariable function;
                    XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)variable, XmlTag.class);
                    if (tag != null && (function = ((ELFunctionCallExpression)parentElement).getMethod()) != null) {
                        String s = function.getText();
                        ELVariable ns = ((ELFunctionCallExpression)parentElement).getNamespace();
                        if (!"}".equals(s) && ns != null && isOnTheFly) {
                            LocalQuickFix[] localQuickFixArray;
                            LocalQuickFix fix;
                            LocalQuickFix localQuickFix = fix = ns.getContainingFile() instanceof XmlFile ? XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)ns, ns.getText(), null) : null;
                            if (fix == null) {
                                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                            } else {
                                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                                localQuickFixArray = localQuickFixArray2;
                                localQuickFixArray2[0] = fix;
                            }
                            fixes = localQuickFixArray;
                        }
                    }
                } else {
                    fixes = new LocalQuickFix[]{new DeclareELVarViaUseBeanFix(id), new DeclareELVarViaCommentAnnotationFix(id)};
                }
            } else {
                fixes = reference.getQuickFixes();
            }
            holder.registerProblem((PsiElement)variable, formattedMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/jsp/ELValidationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/jsp/ELValidationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DeclareELVarFix
    implements LocalQuickFix {
        protected String myVarId;

        protected DeclareELVarFix(String varId) {
            this.myVarId = varId;
        }

        @NotNull
        public String getFamilyName() {
            String string = PsiBundle.message((String)"el.declare.variable.intention.family", (Object[])new Object[0]);
            if (string == null) {
                DeclareELVarFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement holderParent;
            if (project == null) {
                DeclareELVarFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DeclareELVarFix.$$$reportNull$$$0(2);
            }
            PsiElement psiElement = descriptor.getPsiElement();
            PsiFile file = psiElement.getContainingFile();
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file.getVirtualFile()), false);
            if (editor == null) {
                return;
            }
            ELExpressionHolder holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)psiElement, ELExpressionHolder.class);
            TemplateManager manager = TemplateManager.getInstance((Project)project);
            Template template = manager.createTemplate("", "");
            final Set<String> guess = this.findAcceptableClassNames(psiElement, holder);
            Object selectClassExpression = guess == null || guess.isEmpty() ? new MacroCallNode(MacroFactory.createMacro((String)"complete")) : new Expression(){
                private LookupElement[] items;
                private final Result textResult;
                {
                    this.textResult = new TextResult(ApplicationManager.getApplication().isUnitTestMode() && guess.contains("java.lang.String") ? "java.lang.String" : (String)guess.iterator().next());
                }

                public Result calculateResult(ExpressionContext context) {
                    return this.textResult;
                }

                public Result calculateQuickResult(ExpressionContext context) {
                    return null;
                }

                public LookupElement[] calculateLookupItems(ExpressionContext context) {
                    this.createLookups();
                    return this.items;
                }

                private void createLookups() {
                    if (this.items == null) {
                        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
                        for (String suffix : guess) {
                            if (suffix == null) continue;
                            set.add(LookupElementBuilder.create((String)suffix));
                        }
                        this.items = new LookupElement[set.size()];
                        set.toArray(this.items);
                    }
                }
            };
            PsiElement psiElement2 = holderParent = holder == null ? psiElement : holder.getParent();
            int templateStartOffset = holderParent instanceof XmlAttributeValue ? holderParent.getParent().getParent().getTextOffset() : (holderParent instanceof XmlTag ? ((XmlTag)holderParent).getValue().getTextRange().getStartOffset() : (holder == null ? psiElement.getTextOffset() : holder.getTextOffset()));
            this.buildPresentationTemplate(editor, templateStartOffset, template, (Expression)selectClassExpression);
            editor.getCaretModel().moveToOffset(templateStartOffset);
            manager.startTemplate(editor, template);
        }

        protected abstract void buildPresentationTemplate(Editor var1, int var2, Template var3, Expression var4);

        public Set<String> findAcceptableClassNames(PsiElement context, ELExpressionHolder holder) {
            ELVariable variable;
            PsiElement xmlAttr;
            PsiElement parentElement = context.getParent();
            if (parentElement instanceof ELExpressionHolder && parentElement.getParent() instanceof XmlAttributeValue && (xmlAttr = parentElement.getParent().getParent()) instanceof XmlAttribute && "items".equals(((XmlAttribute)xmlAttr).getName())) {
                return new LinkedHashSet<String>(Collections.singletonList("java.util.List"));
            }
            if (parentElement instanceof ELSliceExpression) {
                return new LinkedHashSet<String>(Arrays.asList("java.util.List", "java.util.Map"));
            }
            boolean parentIsSelect = parentElement instanceof ELSelectExpression;
            if (!parentIsSelect && !(parentElement instanceof ELMethodCallExpression)) {
                return null;
            }
            ELVariable eLVariable = variable = parentIsSelect ? ((ELSelectExpression)parentElement).getField() : ((ELMethodCallExpression)parentElement).getMethod();
            if (variable == null) {
                return null;
            }
            HashSet<String> possibleClassNames = new HashSet<String>();
            boolean isMethodReference = holder.isJSFELHolder() && (parentElement.getParent() instanceof ELMethodCallExpression || parentElement.getParent() instanceof ELExpressionHolder);
            String getterName = "get" + StringUtil.capitalize((String)variable.getText());
            String nameToLookFor = isMethodReference ? variable.getText() : getterName;
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            Project project = context.getProject();
            Runnable process = () -> {
                PsiFile file = context.getContainingFile();
                CreateFromUsageUtils.addClassesWithMember((String)nameToLookFor, (PsiFile)file, (Set)possibleClassNames, (boolean)true, (boolean)false, (boolean)false);
                CreateFromUsageUtils.addClassesWithMember((String)nameToLookFor, (PsiFile)file, (Set)possibleClassNames, (boolean)true, (boolean)true, (boolean)false);
                if (isMethodReference) {
                    CreateFromUsageUtils.addClassesWithMember((String)getterName, (PsiFile)file, (Set)possibleClassNames, (boolean)true, (boolean)false, (boolean)false);
                    CreateFromUsageUtils.addClassesWithMember((String)getterName, (PsiFile)file, (Set)possibleClassNames, (boolean)true, (boolean)true, (boolean)false);
                }
            };
            if (unitTestMode) {
                process.run();
            } else {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(process, PsiBundle.message((String)"el.declare.variable.find.acceptable.class", (Object[])new Object[0]), false, project);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Object[] strings = ArrayUtil.toStringArray(possibleClassNames);
                Arrays.sort(strings);
                return new LinkedHashSet<Object>(Arrays.asList(strings));
            }
            return possibleClassNames;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/jsp/ELValidationInspection$DeclareELVarFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/jsp/ELValidationInspection$DeclareELVarFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DeclareELVarViaUseBeanFix
    extends DeclareELVarFix {
        DeclareELVarViaUseBeanFix(String varId) {
            super(varId);
        }

        @NotNull
        public String getName() {
            String string = PsiBundle.message((String)"el.declare.variable.via.usebean.intention.name", (Object[])new Object[0]);
            if (string == null) {
                DeclareELVarViaUseBeanFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void buildPresentationTemplate(Editor editor, int offset, Template template, Expression selectClassExpression) {
            template.addTextSegment("<jsp:useBean id=\"" + this.myVarId + "\" scope=\"");
            Expression expression = new Expression(){
                private final TextResult myTextResult = new TextResult("request");
                private LookupElement[] myItems;

                public Result calculateResult(ExpressionContext context) {
                    return this.myTextResult;
                }

                public Result calculateQuickResult(ExpressionContext context) {
                    return this.myTextResult;
                }

                public LookupElement[] calculateLookupItems(ExpressionContext context) {
                    if (this.myItems == null) {
                        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
                        set.add(LookupElementBuilder.create((String)"request"));
                        set.add(LookupElementBuilder.create((String)"application"));
                        set.add(LookupElementBuilder.create((String)"page"));
                        set.add(LookupElementBuilder.create((String)"session"));
                        this.myItems = set.toArray(LookupElement.EMPTY_ARRAY);
                    }
                    return this.myItems;
                }
            };
            template.addVariable("varScope", expression, expression, true);
            template.addTextSegment("\" type=\"");
            template.addVariable("type", selectClassExpression, selectClassExpression, true);
            template.addTextSegment("\"");
            template.addEndVariable();
            template.addTextSegment("/>\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELValidationInspection$DeclareELVarViaUseBeanFix", "getName"));
        }
    }

    public static class DeclareELVarViaCommentAnnotationFix
    extends DeclareELVarFix {
        public DeclareELVarViaCommentAnnotationFix(String varId) {
            super(varId);
        }

        @NotNull
        public String getName() {
            String string = PsiBundle.message((String)"el.declare.variable.via.comment.annotation.intention.name", (Object[])new Object[0]);
            if (string == null) {
                DeclareELVarViaCommentAnnotationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void buildPresentationTemplate(Editor editor, int offset, Template template, Expression selectClassExpression) {
            boolean jspx = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument()).getFileType() == StdFileTypes.JSPX;
            template.addTextSegment((jspx ? "<!--" : "<%--") + "@elvariable id=\"" + this.myVarId + "\"");
            template.addTextSegment(" type=\"");
            template.addVariable("type", selectClassExpression, selectClassExpression, true);
            template.addTextSegment("\"");
            template.addEndVariable();
            template.addTextSegment(jspx ? "-->" : "--%>");
            if (editor.getDocument().getCharsSequence().charAt(offset) != '\n') {
                template.addTextSegment("\n");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ELValidationInspection$DeclareELVarViaCommentAnnotationFix", "getName"));
        }
    }
}

