/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.BeanPropertyRenameHandler;
import com.intellij.spring.webflow.model.xml.Binding;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nullable;

public class BindingPropertyBeanPropertyRenameHandler
extends BeanPropertyRenameHandler {
    protected BeanProperty getProperty(DataContext context) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (editor == null || !(file instanceof XmlFile)) {
            return BindingPropertyBeanPropertyRenameHandler.resolveByPsiElement(context);
        }
        int offset = editor.getCaretModel().getOffset();
        DomElement value = DomUtil.getContextElement((Editor)editor);
        Binding bindingElement = (Binding)DomUtil.getParentOfType((DomElement)value, Binding.class, (boolean)false);
        if (bindingElement == null) {
            return null;
        }
        PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)offset);
        return BindingPropertyBeanPropertyRenameHandler.createBeanProperty(reference);
    }

    @Nullable
    private static BeanProperty resolveByPsiElement(DataContext context) {
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (!(psiElement instanceof XmlTag)) {
            return null;
        }
        DomElement value = DomUtil.getDomElement((PsiElement)psiElement);
        Binding bindingElement = (Binding)DomUtil.getParentOfType((DomElement)value, Binding.class, (boolean)false);
        if (bindingElement == null) {
            return null;
        }
        XmlAttributeValue xmlAttributeValue = bindingElement.getProperty().getXmlAttributeValue();
        if (xmlAttributeValue == null) {
            return null;
        }
        PsiReference reference = xmlAttributeValue.getReference();
        return BindingPropertyBeanPropertyRenameHandler.createBeanProperty(reference);
    }

    @Nullable
    private static BeanProperty createBeanProperty(@Nullable PsiReference reference) {
        if (reference == null) {
            return null;
        }
        PsiElement resolvedReference = reference.resolve();
        if (resolvedReference instanceof PsiMethod && resolvedReference.getLanguage() == JavaLanguage.INSTANCE) {
            return BeanProperty.createBeanProperty((PsiMethod)((PsiMethod)resolvedReference.getOriginalElement()));
        }
        return null;
    }
}

