/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.managers;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.util.Key;
import com.intellij.spring.webflow.diagram.WebflowDiagramPresentationConstants;
import com.intellij.spring.webflow.diagram.beans.WebflowDiagramEdge;
import com.intellij.spring.webflow.diagram.beans.WebflowEdgeType;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowDomElementWrapper;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class WebflowDiagramColorManager
extends DiagramColorManagerBase {
    public static final Key<Color> CUSTOM_NODE_HEADER_COLOR = Key.create((String)"CUSTOM_NODE_HEADER_COLOR");

    public Color getEdgeColor(DiagramEdge edge) {
        if (edge instanceof WebflowDiagramEdge) {
            WebflowDiagramEdge webflowDiagramEdge = (WebflowDiagramEdge)edge;
            WebflowEdgeType edgeType = webflowDiagramEdge.getEdgeType();
            if (edgeType == WebflowEdgeType.ON_EXCEPTION) {
                return WebflowDiagramPresentationConstants.EDGE_EXCEPTION_COLOR;
            }
            if (edgeType == WebflowEdgeType.GLOBAL_TO) {
                return WebflowDiagramPresentationConstants.EDGE_GLOBAL_TRANSITIONS_COLOR;
            }
            if (edgeType == WebflowEdgeType.EVENT) {
                return WebflowDiagramPresentationConstants.EDGE_EVENT_COLOR;
            }
            if (edgeType == WebflowEdgeType.PARENT) {
                return WebflowDiagramPresentationConstants.EDGE_PARENT_COLOR;
            }
            if (edgeType == WebflowEdgeType.SUBFLOW) {
                return WebflowDiagramPresentationConstants.EDGE_SUBFLOW_COLOR;
            }
        }
        return super.getEdgeColor(edge);
    }

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        Color customColor;
        if (node != null && node.getIdentifyingElement() instanceof WebflowDomElementWrapper && (customColor = (Color)node.getUserData(CUSTOM_NODE_HEADER_COLOR)) != null) {
            return customColor;
        }
        return super.getNodeHeaderColor(builder, node);
    }
}

