/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.editor;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.webflow.diagram.WebflowDiagramDataModel;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowDomElementWrapper;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.WebflowDomElement;
import com.intellij.util.xml.DomElement;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class CreateWebflowElementActionBase<T extends WebflowDomElement>
extends DiagramCreateNewElementAction<WebflowElementWrapper, Pair<WebflowModel, String>> {
    private final Class<T> myElementClazz;

    protected CreateWebflowElementActionBase(Class<T> elementClazz) {
        super(TypePresentationService.getDefaultTypeName(elementClazz), "Create New " + TypePresentationService.getDefaultTypeName(elementClazz), TypePresentationService.getService().getTypeIcon(elementClazz));
        this.myElementClazz = elementClazz;
    }

    public Pair<WebflowModel, String> prepare(@NotNull AnActionEvent e) {
        String s;
        if (e == null) {
            CreateWebflowElementActionBase.$$$reportNull$$$0(0);
        }
        if ((s = Messages.showInputDialog((Project)((Project)e.getData(CommonDataKeys.PROJECT)), (String)"Enter name", (String)("Create New " + TypePresentationService.getDefaultTypeName(this.myElementClazz)), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new NonEmptyInputValidator())) == null) {
            return null;
        }
        DiagramBuilder builder = CreateWebflowElementActionBase.getBuilder((AnActionEvent)e);
        assert (builder != null);
        WebflowDiagramDataModel myModel = (WebflowDiagramDataModel)builder.getDataModel();
        List<WebflowModel> flowModels = myModel.getFlowModels();
        if (flowModels.size() != 1) {
            Messages.showErrorDialog((Component)((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT)), (String)"Multiple Flows not supported currently");
            return null;
        }
        WebflowModel webflowModel = flowModels.get(0);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)webflowModel.getFlow().getXmlElement())) {
            return null;
        }
        return Pair.create((Object)webflowModel, (Object)s);
    }

    public WebflowElementWrapper createElement(DiagramDataModel<WebflowElementWrapper> model, Pair<WebflowModel, String> p, AnActionEvent event) {
        return new WebflowDomElementWrapper((DomElement)this.create((WebflowModel)p.first, (String)p.second));
    }

    protected abstract T create(WebflowModel var1, String var2);

    public String getActionName() {
        return this.getTemplatePresentation().getText();
    }

    public PsiFile[] getAffectedFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateWebflowElementActionBase.$$$reportNull$$$0(1);
        }
        WebflowDiagramDataModel model = (WebflowDiagramDataModel)DiagramAction.getDataModel((AnActionEvent)e);
        assert (model != null);
        return model.getAffectedFiles();
    }

    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder builder) {
        if (e == null) {
            CreateWebflowElementActionBase.$$$reportNull$$$0(2);
        }
        if (builder.isPopupMode()) {
            return false;
        }
        return ((WebflowDiagramDataModel)builder.getDataModel()).getFlowModels().size() == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/spring/webflow/diagram/editor/CreateWebflowElementActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

