/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.actions.patterns;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.actions.generate.SpringBeanGenerateProvider;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowSpringBeanGenerateProvider
extends SpringBeanGenerateProvider {
    private static final String WEBFLOW_NS_PREFIX_VARIABLE = "WEBFLOW_NS_PREFIX";

    public WebflowSpringBeanGenerateProvider(String description, @NonNls String template) {
        super(description, template);
    }

    protected Map<String, String> getPredefinedVars(@Nullable DomElement parentDomElement, @Nullable SpringBean springBean, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            WebflowSpringBeanGenerateProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            WebflowSpringBeanGenerateProvider.$$$reportNull$$$0(1);
        }
        Map map = super.getPredefinedVars(parentDomElement, (DomElement)springBean, editor, file);
        return WebflowSpringBeanGenerateProvider.addWebflowNamespacePrefix(file, map);
    }

    public static Map<String, String> addWebflowNamespacePrefix(@NotNull PsiFile file, @NotNull Map<String, String> map) {
        String prefix;
        if (file == null) {
            WebflowSpringBeanGenerateProvider.$$$reportNull$$$0(2);
        }
        if (map == null) {
            WebflowSpringBeanGenerateProvider.$$$reportNull$$$0(3);
        }
        if (file instanceof XmlFile && !StringUtil.isEmptyOrSpaces((String)(prefix = WebflowSpringBeanGenerateProvider.getWebflowNamespacePrefix((XmlFile)file)))) {
            map.put(WEBFLOW_NS_PREFIX_VARIABLE, prefix + ":");
        }
        return map;
    }

    @Nullable
    public static String getWebflowNamespacePrefix(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            WebflowSpringBeanGenerateProvider.$$$reportNull$$$0(4);
        }
        return XmlUtil.findNamespacePrefixByURI((XmlFile)xmlFile, (String)"http://www.springframework.org/schema/webflow-config");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/webflow/actions/patterns/WebflowSpringBeanGenerateProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPredefinedVars";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addWebflowNamespacePrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getWebflowNamespacePrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

