/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.model.constant.contributor;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.struts2.dom.ConverterUtil;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.ResultType;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class ResultTypeConverter
extends DelimitedListConverter<ResultType> {
    private static final Function<StrutsPackage, Collection<? extends ResultType>> RESULT_TYPE_GETTER = strutsPackage -> strutsPackage.getResultTypes();

    ResultTypeConverter() {
        super(",");
    }

    protected ResultType convertString(@Nullable String s, ConvertContext convertContext) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        StrutsModel strutsModel = ConverterUtil.getStrutsModelOrCombined(convertContext);
        if (strutsModel == null) {
            return null;
        }
        List resultTypes = ContainerUtil.concat(strutsModel.getStrutsPackages(), RESULT_TYPE_GETTER);
        return (ResultType)ContainerUtil.find((Iterable)resultTypes, resultType -> Comparing.strEqual((String)s, (String)resultType.getName().getStringValue()));
    }

    protected String toString(@Nullable ResultType resultType) {
        return resultType != null ? resultType.getName().getStringValue() : null;
    }

    protected Object[] getReferenceVariants(ConvertContext convertContext, GenericDomValue<? extends List<ResultType>> listGenericDomValue) {
        StrutsModel strutsModel = ConverterUtil.getStrutsModelOrCombined(convertContext);
        if (strutsModel == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return ElementPresentationManager.getInstance().createVariants((Collection)ContainerUtil.concat(strutsModel.getStrutsPackages(), RESULT_TYPE_GETTER));
    }

    protected PsiElement resolveReference(@Nullable ResultType resultType, ConvertContext convertContext) {
        return resultType != null ? resultType.getXmlTag() : null;
    }

    protected String getUnresolvedMessage(String s) {
        return "Cannot resolve result-type '" + s + "'";
    }
}

