/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.facet.ui;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.facet.ui.StrutsConfigsSearcher;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import com.intellij.struts2.facet.ui.StrutsFilesTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.config.ConfigFileSearcher;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSetEditor
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField mySetName;
    private StrutsFilesTree myFilesTree;
    private final StrutsFileSet myFileSet;
    private final StrutsFileSet myOriginalSet;

    protected FileSetEditor(Component parent, StrutsFileSet fileSet, FacetEditorContext context, StrutsConfigsSearcher searcher) {
        super(parent, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(StrutsBundle.message("facet.fileset.editor.title", objectArray));
        this.myOriginalSet = fileSet;
        this.myFileSet = new StrutsFileSet(fileSet);
        ConfigFilesTreeBuilder builder = new ConfigFilesTreeBuilder((JTree)((Object)this.myFilesTree)){

            protected DefaultMutableTreeNode createFileNode(Object file) {
                CheckedTreeNode node = new CheckedTreeNode(file);
                if (file instanceof PsiFile && FileSetEditor.this.myFileSet.hasFile(((PsiFile)file).getVirtualFile()) || file instanceof VirtualFile && FileSetEditor.this.myFileSet.hasFile((VirtualFile)file)) {
                    node.setChecked(true);
                } else {
                    node.setChecked(false);
                }
                return node;
            }
        };
        CheckedTreeNode myRoot = new CheckedTreeNode(null);
        this.myFilesTree.setModel(new DefaultTreeModel((TreeNode)myRoot));
        searcher.search();
        Set psiFiles = builder.buildTree((DefaultMutableTreeNode)myRoot, new ConfigFileSearcher[]{searcher});
        PsiManager psiManager = PsiManager.getInstance((Project)context.getProject());
        List<VirtualFilePointer> list = fileSet.getFiles();
        for (VirtualFilePointer pointer : list) {
            PsiFile psiFile;
            VirtualFile file = pointer.getFile();
            if (file == null || (psiFile = psiManager.findFile(file)) != null && psiFiles.contains(psiFile)) continue;
            builder.addFile(file);
        }
        TreeUtil.expandAll((JTree)((Object)this.myFilesTree));
        this.myFilesTree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent e) {
                FileSetEditor.this.updateFileSet();
            }
        });
        this.mySetName.setText(fileSet.getName());
        this.mySetName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileSetEditor.this.updateFileSet();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/struts2/facet/ui/FileSetEditor$3", "textChanged"));
            }
        });
        this.init();
        this.getOKAction().setEnabled(fileSet.isNew());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "struts2 file set editor";
    }

    public boolean isOKActionEnabled() {
        if (this.myOriginalSet.isNew()) {
            return true;
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySetName.getText())) {
            return false;
        }
        int selectedFilesCount = this.myFileSet.getFiles().size();
        if (selectedFilesCount == 0) {
            return false;
        }
        if (selectedFilesCount != this.myOriginalSet.getFiles().size()) {
            return true;
        }
        List<VirtualFilePointer> pointers = this.myFileSet.getFiles();
        for (int i = 0; i < pointers.size(); ++i) {
            if (Comparing.equal((String)pointers.get(i).getUrl(), (String)this.myOriginalSet.getFiles().get(i).getUrl())) continue;
            return true;
        }
        return !Comparing.equal((String)this.myFileSet.getName(), (String)this.myOriginalSet.getName());
    }

    protected void doOKAction() {
        this.updateFileSet();
        super.doOKAction();
    }

    private void updateFileSet() {
        this.myFileSet.setName(this.mySetName.getText());
        this.myFilesTree.updateFileSet(this.myFileSet);
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    public StrutsFileSet getEditedFileSet() {
        return this.myFileSet;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        StrutsFilesTree strutsFilesTree;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myFilesTree = strutsFilesTree = new StrutsFilesTree();
        strutsFilesTree.putClientProperty("JTree.lineStyle", "Angled");
        jBScrollPane.setViewportView((Component)((Object)strutsFilesTree));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/Struts2Bundle").getString("facet.fileset.editor.label.fileset.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(65, 14), null));
        this.mySetName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

