/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl.path;

import com.intellij.struts2.dom.struts.impl.path.StrutsResultContributor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultTypeResolver {
    @NonNls
    private static final String[] RESULT_TYPES_CHAIN_REDIRECT = new String[]{"chain", "redirect-action", "redirectAction"};
    @NonNls
    private static final String[] RESULT_TYPES_DISPATCH = new String[]{"dispatcher", "plainText", "redirect"};

    private ResultTypeResolver() {
    }

    public static boolean isChainOrRedirectType(@NotNull String resultType) {
        if (resultType == null) {
            ResultTypeResolver.$$$reportNull$$$0(0);
        }
        return Arrays.binarySearch(RESULT_TYPES_CHAIN_REDIRECT, resultType) >= 0;
    }

    public static boolean isDispatchType(@NotNull String resultType) {
        if (resultType == null) {
            ResultTypeResolver.$$$reportNull$$$0(1);
        }
        return Arrays.binarySearch(RESULT_TYPES_DISPATCH, resultType) >= 0;
    }

    public static boolean hasResultTypeContributor(@Nullable String resultType) {
        if (resultType == null) {
            return false;
        }
        if (ResultTypeResolver.isDispatchType(resultType) || ResultTypeResolver.isChainOrRedirectType(resultType)) {
            return true;
        }
        return ContainerUtil.find((Iterable)StrutsResultContributor.EP_NAME.getExtensionList(), strutsResultContributor -> strutsResultContributor.matchesResultType(resultType)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "resultType";
        objectArray2[1] = "com/intellij/struts2/dom/struts/impl/path/ResultTypeResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isChainOrRedirectType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDispatchType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

