/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom;

import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConverterUtil {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\{\\d}");

    private ConverterUtil() {
    }

    @Nullable
    public static StrutsModel getStrutsModel(ConvertContext context) {
        XmlFile xmlFile = context.getFile();
        return StrutsManager.getInstance(xmlFile.getProject()).getModelByFile(xmlFile);
    }

    @Nullable
    public static StrutsModel getStrutsModelOrCombined(ConvertContext context) {
        StrutsModel modelByFile = ConverterUtil.getStrutsModel(context);
        if (modelByFile != null) {
            return modelByFile;
        }
        return StrutsManager.getInstance(context.getFile().getProject()).getCombinedModel(context.getModule());
    }

    @NotNull
    public static StrutsPackage getCurrentStrutsPackage(ConvertContext context) {
        StrutsPackage strutsPackage = (StrutsPackage)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), StrutsPackage.class, (boolean)true);
        assert (strutsPackage != null) : context.getInvocationElement();
        StrutsPackage strutsPackage2 = strutsPackage;
        if (strutsPackage2 == null) {
            ConverterUtil.$$$reportNull$$$0(0);
        }
        return strutsPackage2;
    }

    public static boolean hasWildcardReference(@Nullable String value) {
        return value != null && WILDCARD_PATTERN.matcher(value).find();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/ConverterUtil", "getCurrentStrutsPackage"));
    }
}

