/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.action;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.diagnostic.ex.TraceCompilationException;
import com.intellij.debugger.streams.diagnostic.ex.TraceEvaluationException;
import com.intellij.debugger.streams.lib.LibrarySupport;
import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.psi.DebuggerPositionResolver;
import com.intellij.debugger.streams.psi.impl.DebuggerPositionResolverImpl;
import com.intellij.debugger.streams.trace.EvaluateExpressionTracer;
import com.intellij.debugger.streams.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.trace.TracingCallback;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.TraceResultInterpreterImpl;
import com.intellij.debugger.streams.ui.ChooserOption;
import com.intellij.debugger.streams.ui.impl.ElementChooserImpl;
import com.intellij.debugger.streams.ui.impl.EvaluationAwareTraceWindow;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceStreamAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(TraceStreamAction.class);
    private final DebuggerPositionResolver myPositionResolver = new DebuggerPositionResolverImpl();
    private final List<SupportedLibrary> mySupportedLibraries = LibrarySupportProvider.getList().stream().map(SupportedLibrary::new).collect(Collectors.toList());
    private final Set<String> mySupportedLanguages = StreamEx.of(this.mySupportedLibraries).map(x -> x.languageId).toSet();
    private int myLastVisitedPsiElementHash;

    public void update(@NotNull AnActionEvent e) {
        XDebugSession session;
        if (e == null) {
            TraceStreamAction.$$$reportNull$$$0(0);
        }
        PsiElement element = (session = TraceStreamAction.getCurrentSession(e)) == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        Presentation presentation = e.getPresentation();
        if (element == null) {
            presentation.setVisible(true);
            presentation.setEnabled(false);
        } else {
            String languageId = element.getLanguage().getID();
            if (this.mySupportedLanguages.contains(languageId)) {
                presentation.setVisible(true);
                boolean chainExists = this.isChainExists(element);
                presentation.setEnabled(chainExists);
                int elementHash = System.identityHashCode(element);
                if (chainExists && this.myLastVisitedPsiElementHash != elementHash) {
                    this.myLastVisitedPsiElementHash = elementHash;
                }
            } else {
                presentation.setEnabledAndVisible(false);
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element;
        if (e == null) {
            TraceStreamAction.$$$reportNull$$$0(1);
        }
        XDebugSession session = TraceStreamAction.getCurrentSession(e);
        LibrarySupportProvider.EP_NAME.getExtensionList();
        PsiElement psiElement = element = session == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        if (element != null) {
            List chains = this.mySupportedLibraries.stream().filter(library -> library.languageId.equals(element.getLanguage().getID())).filter(library -> library.builder.isChainExists(element)).flatMap(library -> library.builder.build(element).stream().map(x -> new StreamChainWithLibrary((StreamChain)x, (SupportedLibrary)library))).collect(Collectors.toList());
            if (chains.isEmpty()) {
                LOG.warn("stream chain is not built");
                return;
            }
            if (chains.size() == 1) {
                TraceStreamAction.runTrace(((StreamChainWithLibrary)chains.get((int)0)).chain, ((StreamChainWithLibrary)chains.get((int)0)).library, session);
            } else {
                Editor editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(element);
                if (editor == null) {
                    throw new RuntimeException("editor not found");
                }
                new MyStreamChainChooser(editor).show(chains.stream().map(StreamChainOption::new).collect(Collectors.toList()), provider -> TraceStreamAction.runTrace(provider.chain, provider.library, session));
            }
        } else {
            LOG.info("element at cursor not found");
        }
    }

    private boolean isChainExists(@NotNull PsiElement element) {
        if (element == null) {
            TraceStreamAction.$$$reportNull$$$0(2);
        }
        for (SupportedLibrary library : this.mySupportedLibraries) {
            if (!element.getLanguage().getID().equals(library.languageId) || !library.builder.isChainExists(element)) continue;
            return true;
        }
        return false;
    }

    private static void runTrace(@NotNull StreamChain chain, final @NotNull SupportedLibrary library, @NotNull XDebugSession session) {
        if (chain == null) {
            TraceStreamAction.$$$reportNull$$$0(3);
        }
        if (library == null) {
            TraceStreamAction.$$$reportNull$$$0(4);
        }
        if (session == null) {
            TraceStreamAction.$$$reportNull$$$0(5);
        }
        final EvaluationAwareTraceWindow window = new EvaluationAwareTraceWindow(session, chain);
        ApplicationManager.getApplication().invokeLater(() -> ((EvaluationAwareTraceWindow)window).show());
        Project project = session.getProject();
        TraceExpressionBuilder expressionBuilder = library.createExpressionBuilder(project);
        TraceResultInterpreterImpl resultInterpreter = new TraceResultInterpreterImpl(library.librarySupport.getInterpreterFactory());
        EvaluateExpressionTracer tracer = new EvaluateExpressionTracer(session, expressionBuilder, resultInterpreter);
        tracer.trace(chain, new TracingCallback(){

            @Override
            public void evaluated(@NotNull TracingResult result, @NotNull EvaluationContextImpl context) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                ResolvedTracingResult resolvedTrace = result.resolve(library.librarySupport.getResolverFactory());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (context == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    window.setTrace(resolvedTrace, context);
                });
            }

            @Override
            public void evaluationFailed(@NotNull String traceExpression, @NotNull String message) {
                if (traceExpression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.notifyUI(message);
                throw new TraceEvaluationException(message, traceExpression);
            }

            @Override
            public void compilationFailed(@NotNull String traceExpression, @NotNull String message) {
                if (traceExpression == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.notifyUI(message);
                throw new TraceCompilationException(message, traceExpression);
            }

            private void notifyUI(@NotNull String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(6);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (message == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    window.setFailMessage(message);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "traceExpression";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/streams/action/TraceStreamAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluationFailed";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compilationFailed";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "notifyUI";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$notifyUI$1";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$evaluated$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    private static XDebugSession getCurrentSession(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TraceStreamAction.$$$reportNull$$$0(6);
        }
        return (project = e.getProject()) == null ? null : XDebuggerManager.getInstance((Project)project).getCurrentSession();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/streams/action/TraceStreamAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isChainExists";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runTrace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentSession";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StreamChainOption
    implements ChooserOption {
        final StreamChain chain;
        final SupportedLibrary library;

        StreamChainOption(@NotNull StreamChainWithLibrary chain) {
            if (chain == null) {
                StreamChainOption.$$$reportNull$$$0(0);
            }
            this.chain = chain.chain;
            this.library = chain.library;
        }

        @Override
        @NotNull
        public Stream<TextRange> rangeStream() {
            Stream<TextRange> stream = Stream.of(new TextRange(this.chain.getQualifierExpression().getTextRange().getStartOffset(), this.chain.getTerminationCall().getTextRange().getEndOffset()));
            if (stream == null) {
                StreamChainOption.$$$reportNull$$$0(1);
            }
            return stream;
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.chain.getCompactText();
            if (string == null) {
                StreamChainOption.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chain";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/streams/action/TraceStreamAction$StreamChainOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/streams/action/TraceStreamAction$StreamChainOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rangeStream";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StreamChainWithLibrary {
        final StreamChain chain;
        final SupportedLibrary library;

        StreamChainWithLibrary(@NotNull StreamChain chain, @NotNull SupportedLibrary library) {
            if (chain == null) {
                StreamChainWithLibrary.$$$reportNull$$$0(0);
            }
            if (library == null) {
                StreamChainWithLibrary.$$$reportNull$$$0(1);
            }
            this.chain = chain;
            this.library = library;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "chain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "library";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/streams/action/TraceStreamAction$StreamChainWithLibrary";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SupportedLibrary {
        final String languageId;
        final StreamChainBuilder builder;
        final LibrarySupport librarySupport;
        private final LibrarySupportProvider mySupportProvider;

        SupportedLibrary(@NotNull LibrarySupportProvider provider) {
            if (provider == null) {
                SupportedLibrary.$$$reportNull$$$0(0);
            }
            this.languageId = provider.getLanguageId();
            this.builder = provider.getChainBuilder();
            this.librarySupport = provider.getLibrarySupport();
            this.mySupportProvider = provider;
        }

        TraceExpressionBuilder createExpressionBuilder(@NotNull Project project) {
            if (project == null) {
                SupportedLibrary.$$$reportNull$$$0(1);
            }
            return this.mySupportProvider.getExpressionBuilder(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/streams/action/TraceStreamAction$SupportedLibrary";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createExpressionBuilder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyStreamChainChooser
    extends ElementChooserImpl<StreamChainOption> {
        MyStreamChainChooser(@NotNull Editor editor) {
            if (editor == null) {
                MyStreamChainChooser.$$$reportNull$$$0(0);
            }
            super(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/debugger/streams/action/TraceStreamAction$MyStreamChainChooser", "<init>"));
        }
    }
}

