/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ContextThreadAgentProxyFactory;
import com.intellij.javaee.oss.agent.ProcessAgentProxyFactory;
import com.intellij.javaee.oss.glassfish.GlassfishUtil;
import com.intellij.javaee.oss.glassfish.admin.Glassfish2AdminServerImpl;
import com.intellij.javaee.oss.glassfish.admin.Glassfish31AdminServerImpl;
import com.intellij.javaee.oss.glassfish.admin.Glassfish3AdminServerImpl;
import com.intellij.javaee.oss.glassfish.admin.Glassfish51AdminServerImpl;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.run.configuration.LogCustomizer;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class GlassfishServerModel
extends JavaeeServerModel
implements LogCustomizer {
    @NonNls
    private static final String GLASSFISH_LOG_FILE_ID = "GlassFish";
    private static final String ADMIN_PROCESS_VM_OPTION_NAME = "idea.glassfish.v2.use.process.proxy";
    public boolean PRESERVE;
    public boolean COMPATIBILITY;
    public String VIRTUAL_SERVER;

    protected String getLogFileId() {
        return GLASSFISH_LOG_FILE_ID;
    }

    @NonNls
    protected String getDefaultUsername() {
        return GlassfishServerModel.doGetDefaultUsername();
    }

    @NonNls
    protected String getDefaultPassword() {
        return GlassfishServerModel.doGetDefaultPassword();
    }

    public String getVirtualServer() {
        return this.VIRTUAL_SERVER;
    }

    @NonNls
    protected static String doGetDefaultUsername() {
        return "admin";
    }

    @NonNls
    protected static String doGetDefaultPassword() {
        return "";
    }

    protected boolean isEmptyPasswordAllowed() {
        return true;
    }

    protected JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        boolean secured = this.isSecured();
        ProcessAgentProxyFactory processAgentFactory = new ProcessAgentProxyFactory(serverInstance){

            protected Sdk getJdk() {
                return GlassfishServerModel.this.getJre();
            }
        };
        if (this.isGlassfish5Higher()) {
            return new Glassfish51AdminServerImpl((AgentProxyFactory)processAgentFactory, this.getLibraries(), secured, this);
        }
        if (this.isGlassfish4Plus()) {
            return new Glassfish31AdminServerImpl((AgentProxyFactory)processAgentFactory, this.getLibraries(), secured, this, true);
        }
        if (this.isGlassfish3Plus()) {
            if (GlassfishUtil.isGlassfish31Plus(this.getVersion())) {
                return new Glassfish31AdminServerImpl((AgentProxyFactory)new ContextThreadAgentProxyFactory(), this.getLibraries(), secured, this, false);
            }
            return new Glassfish3AdminServerImpl((AgentProxyFactory)new ContextThreadAgentProxyFactory(), this.getLibraries(), secured, this);
        }
        return new Glassfish2AdminServerImpl((AgentProxyFactory)(SystemProperties.getBooleanProperty((String)ADMIN_PROCESS_VM_OPTION_NAME, (boolean)false) ? processAgentFactory : new ContextThreadAgentProxyFactory()), this.getLibraries());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.isGlassfish4Plus()) {
            this.checkHasJdk();
            if (this.isGlassfish5()) {
                this.doCheckJdkAtLeast(JavaSdkVersion.JDK_1_8);
            }
            if (this.isGlassfish4()) {
                this.checkJdkAtLeast7();
            }
        } else {
            this.checkJdkAtMost7();
        }
        super.checkConfiguration();
    }

    protected List<File> getLibraries() throws ExecutionException {
        List libraries = super.getLibraries();
        libraries.add(this.getPathUnderHome("lib/appserv-deployment-client.jar"));
        libraries.add(this.getPathUnderHome("lib/appserv-ext.jar"));
        libraries.add(this.getPathUnderHome("glassfish/modules"));
        return libraries;
    }

    public String getServerSpecificContext(File source) {
        Version version = new Version(this.getVersion());
        return this.isGlassfish4Plus() || version.compare(3, 0, 0) > 0 && version.compare(3, 1, 1) <= 0 ? GlassfishServerModel.cutWarExtension((File)source) : source.getName();
    }

    public void customizeLogConsole(LogConsole console) {
        final LogFilterModel delegate = console.getFilterModel();
        console.setFilterModel(new LogFilterModel(){

            public boolean isApplicable(String line) {
                if (line != null && line.isEmpty()) {
                    return false;
                }
                return delegate.isApplicable(line);
            }

            public void updateCustomFilter(String filter) {
                delegate.updateCustomFilter(filter);
            }

            public String getCustomFilter() {
                return delegate.getCustomFilter();
            }

            public void addFilterListener(LogFilterListener listener) {
                delegate.addFilterListener(listener);
            }

            public void removeFilterListener(LogFilterListener listener) {
                delegate.removeFilterListener(listener);
            }

            public List<? extends LogFilter> getLogFilters() {
                return delegate.getLogFilters();
            }

            public boolean isFilterSelected(LogFilter filter) {
                return delegate.isFilterSelected(filter);
            }

            public void selectFilter(LogFilter filter) {
                delegate.selectFilter(filter);
            }

            @NotNull
            public LogFilterModel.MyProcessingResult processLine(String line) {
                LogFilterModel.MyProcessingResult myProcessingResult = delegate.processLine(line);
                if (myProcessingResult == null) {
                    2.$$$reportNull$$$0(0);
                }
                return myProcessingResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/server/GlassfishServerModel$2", "processLine"));
            }
        });
    }

    public boolean isGlassfish3Plus() {
        return GlassfishUtil.isGlassfish3Plus(this.getVersion());
    }

    public boolean isGlassfish4() {
        return GlassfishUtil.isGlassfish4(this.getVersion());
    }

    public boolean isGlassfish5() {
        return GlassfishUtil.isGlassfish5(this.getVersion());
    }

    public boolean isGlassfish4Plus() {
        return GlassfishUtil.isGlassfish4Plus(this.getVersion());
    }

    public boolean isGlassfish5Higher() {
        return GlassfishUtil.isGlassfish5Higher(this.getVersion());
    }

    public boolean undeployBeforeDeploy() {
        return !this.isGlassfish3Plus();
    }

    protected abstract boolean isSecured();
}

