/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.glassfish.GlassfishBundle;
import com.intellij.javaee.oss.glassfish.GlassfishUtil;
import com.intellij.javaee.oss.glassfish.server.GlassfishRemoteEditor;
import com.intellij.javaee.oss.glassfish.server.GlassfishServerModel;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModel;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelData;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModelDelegate;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GlassfishRemoteModel
extends GlassfishServerModel
implements SimpleRemoteServerModel {
    @NonNls
    private static final String DATA_ELEMENT = "data";
    public static final int DEFAULT_ADMIN_PORT = 4848;
    private static final boolean DEFAULT_UPLOAD_WITH_GLASSFISH = true;
    private static final boolean DEFAULT_SECURED = false;
    public int ADMIN_PORT = 4848;
    private boolean myUploadWithGlassfish = true;
    private boolean mySecured = false;
    public String ADMIN_SERVER_HOST;
    public String CLUSTER_NAME;
    public boolean DEPLOY_ON_CLUSTER = false;
    private SimpleRemoteServerModelDelegate myTransportDelegate = new SimpleRemoteServerModelDelegate().init((SimpleRemoteServerModel)this);

    public SettingsEditor<CommonModel> getEditor() {
        return new GlassfishRemoteEditor();
    }

    public boolean isUploadWithGlassfish() {
        return this.myUploadWithGlassfish;
    }

    public void setUploadWithGlassfish(boolean uploadWithGlassfish) {
        this.myUploadWithGlassfish = uploadWithGlassfish;
    }

    public String getTransportHostId() {
        return this.myTransportDelegate.getTransportHostId();
    }

    public void setTransportHostId(String transportHostId) {
        this.myTransportDelegate.setTransportHostId(transportHostId);
    }

    public TransportTarget getTransportStagingTarget() {
        return this.myTransportDelegate.getTransportStagingTarget();
    }

    public void setTransportStagingTarget(TransportTarget transportStagingTarget) {
        this.myTransportDelegate.setTransportStagingTarget(transportStagingTarget);
    }

    public String getStagingRemotePath() {
        return this.myTransportDelegate.getStagingRemotePath();
    }

    public void setStagingRemotePath(String stagingRemotePath) {
        this.myTransportDelegate.setStagingRemotePath(stagingRemotePath);
    }

    @Override
    public boolean isSecured() {
        return this.mySecured;
    }

    public void setSecured(boolean secured) {
        this.mySecured = secured;
    }

    public String prepareDeployment(String sourcePath, boolean prepareNameOnly) throws RuntimeConfigurationException {
        return this.myTransportDelegate.prepareDeployment(sourcePath, prepareNameOnly);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.ADMIN_PORT <= 0) {
            throw new RuntimeConfigurationError(GlassfishBundle.getText("GlassfishRemoteModel.error.admin", new Object[0]));
        }
        if (this.myUploadWithGlassfish) {
            for (DeploymentModel deploymentModel : this.getCommonModel().getDeploymentModels()) {
                if (deploymentModel.getDeploymentSource().isArchive()) continue;
                throw new RuntimeConfigurationError(GlassfishBundle.getText("GlassfishRemoteModel.error.cant.upload.exploded", new Object[0]));
            }
        } else {
            this.myTransportDelegate.checkConfiguration();
        }
        super.checkConfiguration();
    }

    public boolean isDeployAllowed() {
        return this.myUploadWithGlassfish || this.myTransportDelegate.isDeployAllowed();
    }

    public boolean isClusterSupported() {
        return GlassfishUtil.isGlassfish31Plus(this.getVersion());
    }

    public boolean isDeployOnCluster() {
        return this.DEPLOY_ON_CLUSTER;
    }

    public String getAdminServerHost() {
        return this.isDeployOnCluster() ? this.ADMIN_SERVER_HOST : this.getServerHost();
    }

    public int getAdminServerPort() {
        return this.ADMIN_PORT;
    }

    protected int getServerPort() {
        return this.isDeployOnCluster() ? this.getCommonModel().getPort() : this.ADMIN_PORT;
    }

    protected void read(@NotNull Element element, boolean isPersistent) throws InvalidDataException {
        Element dataElement;
        if (element == null) {
            GlassfishRemoteModel.$$$reportNull$$$0(0);
        }
        if ((dataElement = element.getChild(DATA_ELEMENT)) == null) {
            super.read(element, isPersistent);
            this.myUploadWithGlassfish = true;
            this.mySecured = false;
        } else {
            GlassfishRemoteModelData settings = (GlassfishRemoteModelData)((Object)XmlSerializer.deserialize((Element)dataElement, GlassfishRemoteModelData.class));
            this.myTransportDelegate.readFromData((SimpleRemoteServerModelData)settings);
            this.myUploadWithGlassfish = settings.isUploadWithGlassfish();
            this.mySecured = settings.isSecured();
            this.ADMIN_PORT = settings.getAdminPort();
            this.USERNAME = settings.getUsername();
            this.PRESERVE = settings.isPreserve();
            this.COMPATIBILITY = settings.isCompatibility();
            this.VIRTUAL_SERVER = settings.getVirtualServer();
            this.ADMIN_SERVER_HOST = settings.getAdminServerHost();
            this.CLUSTER_NAME = settings.getClusterName();
            this.DEPLOY_ON_CLUSTER = settings.isDeployOnCluster();
            if (!isPersistent) {
                this.TEMPLATE = settings.isTemplate();
            }
            if (!this.TEMPLATE) {
                this.PASSWORD = settings.getPassword();
                this.CREDENTIAL_ALIAS = settings.getCredentialAlias();
            }
        }
    }

    protected void write(@NotNull Element element, boolean isPersistent) throws WriteExternalException {
        if (element == null) {
            GlassfishRemoteModel.$$$reportNull$$$0(1);
        }
        GlassfishRemoteModelData settings = new GlassfishRemoteModelData();
        this.myTransportDelegate.writeToData((SimpleRemoteServerModelData)settings);
        settings.setUploadWithGlassfish(this.myUploadWithGlassfish);
        settings.setSecured(this.mySecured);
        settings.setAdminPort(this.ADMIN_PORT);
        settings.setUsername(this.USERNAME);
        settings.setPreserve(this.PRESERVE);
        settings.setCompatibility(this.COMPATIBILITY);
        settings.setVirtualServer(this.VIRTUAL_SERVER);
        settings.setAdminServerHost(this.ADMIN_SERVER_HOST);
        settings.setClusterName(this.CLUSTER_NAME);
        settings.setDeployOnCluster(this.DEPLOY_ON_CLUSTER);
        if (!this.TEMPLATE) {
            if (!isPersistent) {
                settings.setPassword(this.PASSWORD);
            }
            settings.setCredentialAlias(this.CREDENTIAL_ALIAS);
        }
        if (!isPersistent) {
            settings.setTemplate(this.TEMPLATE);
        }
        Element dataElement = XmlSerializer.serialize((Object)((Object)settings), (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(dataElement);
    }

    public Object clone() throws CloneNotSupportedException {
        GlassfishRemoteModel result = (GlassfishRemoteModel)((Object)super.clone());
        result.myTransportDelegate = ((SimpleRemoteServerModelDelegate)this.myTransportDelegate.clone()).init((SimpleRemoteServerModel)result);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/javaee/oss/glassfish/server/GlassfishRemoteModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="data")
    public static class GlassfishRemoteModelData
    extends SimpleRemoteServerModelData {
        @Tag(value="username")
        private String myUsername = GlassfishServerModel.doGetDefaultUsername();
        @Tag(value="password")
        private String myPassword = GlassfishServerModel.doGetDefaultPassword();
        @Tag(value="credential-alias")
        private String myCredentialAlias;
        @Tag(value="preserve")
        private boolean myPreserve;
        @Tag(value="compatibility")
        private boolean myCompatibility;
        @Tag(value="admin-port")
        private int myAdminPort = 4848;
        @Tag(value="upload-with-glassfish")
        private boolean myUploadWithGlassfish = true;
        @Tag(value="secured")
        private boolean mySecured = false;
        @Tag(value="virtual-server")
        private String myVirtualServer;
        @Tag(value="admin-server-host")
        private String myAdminServerHost;
        @Tag(value="cluster-name")
        private String myClusterName;
        @Tag(value="deploy-\u043en-\u0441luster")
        private boolean myDeployOnCluster;
        @Tag(value="template")
        private boolean myIsTemplate;

        public int getAdminPort() {
            return this.myAdminPort;
        }

        public void setAdminPort(int adminPort) {
            this.myAdminPort = adminPort;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public void setUsername(String username) {
            this.myUsername = username;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public void setPassword(String password) {
            this.myPassword = password;
        }

        public String getCredentialAlias() {
            return this.myCredentialAlias;
        }

        public void setCredentialAlias(String credentialAlias) {
            this.myCredentialAlias = credentialAlias;
        }

        public boolean isPreserve() {
            return this.myPreserve;
        }

        public boolean isCompatibility() {
            return this.myCompatibility;
        }

        public void setPreserve(boolean preserve) {
            this.myPreserve = preserve;
        }

        public void setCompatibility(boolean compatibility) {
            this.myCompatibility = compatibility;
        }

        public boolean isUploadWithGlassfish() {
            return this.myUploadWithGlassfish;
        }

        public void setUploadWithGlassfish(boolean uploadWithGlassfish) {
            this.myUploadWithGlassfish = uploadWithGlassfish;
        }

        public boolean isSecured() {
            return this.mySecured;
        }

        public void setSecured(boolean secured) {
            this.mySecured = secured;
        }

        public String getVirtualServer() {
            return this.myVirtualServer;
        }

        public void setVirtualServer(String virtualServer) {
            this.myVirtualServer = virtualServer;
        }

        public String getAdminServerHost() {
            return this.myAdminServerHost;
        }

        public void setAdminServerHost(String adminServerHost) {
            this.myAdminServerHost = adminServerHost;
        }

        public String getClusterName() {
            return this.myClusterName;
        }

        public void setClusterName(String clusterName) {
            this.myClusterName = clusterName;
        }

        public boolean isDeployOnCluster() {
            return this.myDeployOnCluster;
        }

        public void setDeployOnCluster(boolean deployOnCluster) {
            this.myDeployOnCluster = deployOnCluster;
        }

        public boolean isTemplate() {
            return this.myIsTemplate;
        }

        public void setTemplate(boolean isTemplate) {
            this.myIsTemplate = isTemplate;
        }
    }
}

