/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.admin;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.admin.JavaeeAgentAdminServerBase;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.glassfish.GlassfishUtil;
import com.intellij.javaee.oss.glassfish.model.GlassfishWebRoot;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Glassfish2AdminServerImpl
extends JavaeeAgentAdminServerBase {
    private static final String SPECIFICS_MODULE_NAME = "intellij.javaee.appServers.glassfish.v2.agent.rt";
    private static final String SPECIFICS_JAR_PATH = "specifics/glassfish2-specifics.jar";

    public Glassfish2AdminServerImpl(AgentProxyFactory agentProxyFactory, List<File> libraries) throws Exception {
        super(agentProxyFactory, libraries, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, "com.intellij.javaee.oss.glassfish.agent.Glassfish2Agent");
    }

    @NotNull
    protected String getDeploymentName(DeploymentModel deployment, File source) {
        String string = source.isDirectory() ? source.getName() : FileUtil.getNameWithoutExtension((File)source);
        if (string == null) {
            Glassfish2AdminServerImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void setupDeployParameters(DeploymentModel deployment, File source, ParametersMap deployParameters) {
        deployParameters.put((Object)"need.context.root", (Object)Glassfish2AdminServerImpl.isNeedContextRoot(deployment).toString());
    }

    private static Boolean isNeedContextRoot(DeploymentModel deployment) {
        Ref resultRef = new Ref((Object)false);
        if (JavaeeServerInstanceImpl.isRemote((DeploymentModel)deployment)) {
            Project project = deployment.getCommonModel().getProject();
            Artifact artifact = deployment.getArtifact();
            if (artifact != null) {
                for (JavaeeFacet facet : JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(project, artifact, null)) {
                    GlassfishWebRoot web = GlassfishUtil.getWebRoot(facet);
                    if (web == null) continue;
                    ApplicationManager.getApplication().runReadAction(() -> {
                        if (StringUtil.isEmpty((String)((String)web.getContextRoot().getValue()))) {
                            resultRef.set((Object)true);
                        }
                    });
                    break;
                }
            }
        }
        return (Boolean)resultRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/admin/Glassfish2AdminServerImpl", "getDeploymentName"));
    }
}

