/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.common.ParseUtil;
import com.intellij.dmserver.run.DMServerModelBase;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.ServerModelBase;
import com.intellij.javaee.run.configuration.view.JavaeeRunConfigurationEditorUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.PropertyKey;

public abstract class DMRunConfigurationEditorBase
extends SettingsEditor<CommonModel> {
    private final Project myProject;

    public DMRunConfigurationEditorBase(Project project) {
        this.myProject = project;
    }

    protected abstract JTextField getJmxPortField();

    protected abstract JTextField getJmxUserField();

    protected abstract JPasswordField getJmxPasswordField();

    protected abstract JLabel getJmxPasswordLabel();

    protected Project getProject() {
        return this.myProject;
    }

    protected void resetJmxConfiguration(DMServerModelBase serverModel) {
        this.getJmxPortField().setText(String.valueOf(serverModel.getMBeanServerPort()));
        JavaeeRunConfigurationEditorUtil.resetPasswordFrom((ServerModelBase)serverModel, (JPasswordField)this.getJmxPasswordField(), (JLabel)this.getJmxPasswordLabel());
        this.getJmxUserField().setText(DMRunConfigurationEditorBase.notNull(serverModel.getMBeanServerUserName()));
    }

    protected void applyJmxConfiguration(DMServerModelBase serverModel) throws ConfigurationException {
        JavaeeRunConfigurationEditorUtil.applyPasswordTo((ServerModelBase)serverModel, (JPasswordField)this.getJmxPasswordField());
        serverModel.setMBeanServerUserName(this.getJmxUserField().getText());
        serverModel.setMBeanServerPort(DMRunConfigurationEditorBase.parseInt(this.getJmxPortField(), "DMRunConfigurationEditorBase.bad.port"));
    }

    protected static int parseInt(JTextField text, final @PropertyKey(resourceBundle="com.intellij.dmserver.util.DmServer") String errorKey) throws ConfigurationException {
        return new ParseUtil(){

            @Override
            protected String getErrorMessage(String unparsableValue) {
                return DmServerBundle.message(errorKey, unparsableValue);
            }
        }.parseInt(text);
    }

    protected static String notNull(String s) {
        return s == null ? "" : s;
    }
}

