/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.obr.data;

import com.intellij.dmserver.libraries.ProgressListener;
import com.intellij.dmserver.libraries.obr.HttpRetriever;
import com.intellij.dmserver.libraries.obr.XPathUtils;
import com.intellij.dmserver.libraries.obr.data.BundleData;
import com.intellij.dmserver.libraries.obr.data.CodeDataDetails;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.jetbrains.annotations.NonNls;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractCodeDataDetails<D extends BundleData>
implements CodeDataDetails<D> {
    private final ArrayList<D> myDependencies;

    public AbstractCodeDataDetails(String link, ProgressListener progressListener) throws IOException, XPathExpressionException {
        Node root = XPathUtils.getInstance().createHtmlRoot(HttpRetriever.retrievePage(link, progressListener));
        this.myDependencies = new ArrayList();
        NodeList bundleNodeList = AbstractCodeDataDetails.scrapTableRows(root, "dependencies");
        for (int iBundle = 0; iBundle < bundleNodeList.getLength(); ++iBundle) {
            Node bundleNode = bundleNodeList.item(iBundle);
            this.myDependencies.add(this.createDependency(this.evaluateXpath("td[2]/a/text()", bundleNode).trim(), this.evaluateXpath("td[3]/text()", bundleNode).trim(), AbstractCodeDataDetails.resolveUrl(this.evaluateXpath("td[2]/a/@href", bundleNode).trim())));
        }
        this.retrieveCustomDetails(root);
    }

    protected String evaluateXpath(@NonNls String xPath, Object item) throws XPathExpressionException {
        return AbstractCodeDataDetails.getXPath().evaluate(xPath, item);
    }

    protected static Object evaluateXpath(@NonNls String xPath, Object item, QName returnType) throws XPathExpressionException {
        return AbstractCodeDataDetails.getXPath().evaluate(xPath, item);
    }

    protected static NodeList scrapTableRows(Node root, @NonNls String tableDivId) throws XPathExpressionException {
        String xPath = "//div[@id='" + tableDivId + "']//table//tr[not(th)]";
        return (NodeList)AbstractCodeDataDetails.getXPath().evaluate(xPath, root, XPathConstants.NODESET);
    }

    protected static XPath getXPath() {
        return XPathUtils.getInstance().getXPath();
    }

    @Override
    public List<D> getDependencies() {
        return this.myDependencies;
    }

    private static String resolveUrl(String suffix) {
        return StringUtil.isEmpty((String)suffix) ? null : "https://www.springsource.com" + suffix;
    }

    protected static String scrapNamedLink(Node root, @NonNls String linkName) throws XPathExpressionException {
        return AbstractCodeDataDetails.resolveUrl((String)AbstractCodeDataDetails.evaluateXpath("//a[text()='" + linkName + "']/@href", root, XPathConstants.STRING));
    }

    protected abstract D createDependency(String var1, String var2, String var3);

    protected abstract void retrieveCustomDetails(Node var1) throws XPathExpressionException;
}

