/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries;

import com.intellij.dmserver.libraries.BundleDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;

public class BundleWrapper
extends BundleDefinition {
    private static final Logger LOG = Logger.getInstance(BundleWrapper.class);
    @NonNls
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private final VirtualFile myJarFile;
    private final VirtualFile myManifestFile;

    @Nullable
    public static BundleWrapper load(VirtualFile jarFile) {
        VirtualFile manifestFile;
        String path = jarFile.getPath();
        if (!CachingBundleInfoProvider.isBundle((String)path)) {
            return null;
        }
        VirtualFile bundleRoot = jarFile.isDirectory() ? jarFile : JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
        VirtualFile virtualFile = manifestFile = bundleRoot == null ? null : bundleRoot.findFileByRelativePath(MANIFEST_PATH);
        if (manifestFile == null) {
            LOG.error("Manifest is expected to exist");
        }
        return new BundleWrapper(CachingBundleInfoProvider.getBundleSymbolicName((String)path), CachingBundleInfoProvider.getBundleVersion((String)path), jarFile, manifestFile);
    }

    private BundleWrapper(String symbolicName, String version, VirtualFile jarFile, VirtualFile manifestFile) {
        super(symbolicName, version);
        this.myJarFile = jarFile;
        this.myManifestFile = manifestFile;
    }

    public VirtualFile getJarFile() {
        return this.myJarFile;
    }

    public VirtualFile getManifestFile() {
        return this.myManifestFile;
    }
}

