/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.WildcardsFinder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class RepositoryPattern {
    public static final String ANY_FILE = "*";
    public static final String RECURSIVE_DIRS = "**";
    public static final Pattern RECURSIVE_PATTERN_MARK = null;
    private static final Pattern BRANCHES_PATTERN = Pattern.compile("\\{.*?\\}");
    private final DMServerRepositoryItem mySource;
    private final String myFixedPath;
    private final List<Pattern> myDirPatterns;
    private final Pattern myFilePattern;
    private final String myFullPattern;

    public static RepositoryPattern create(DMServerRepositoryItem source, String searchPattern) {
        int filePatternStart = (searchPattern = BRANCHES_PATTERN.matcher(searchPattern).replaceAll(ANY_FILE)).lastIndexOf(47);
        boolean hasFilePattern = filePatternStart != -1;
        String filePattern = hasFilePattern ? searchPattern.substring(filePatternStart + 1) : searchPattern;
        String dirs = hasFilePattern ? searchPattern.substring(0, filePatternStart) : "";
        WildcardsFinder wildcardsFinder = new WildcardsFinder(dirs);
        List dirPatterns = wildcardsFinder.hasWildcards() ? StringUtil.split((String)wildcardsFinder.getWildcards(), (String)"/") : Collections.emptyList();
        return new RepositoryPattern(source, wildcardsFinder.getPath(), dirPatterns, "".equals(filePattern) ? ANY_FILE : filePattern);
    }

    public RepositoryPattern(DMServerRepositoryItem source, String fixedPath, List<String> dirPatterns, String filePattern) {
        this.mySource = source;
        this.myFixedPath = fixedPath;
        this.myDirPatterns = new ArrayList<Pattern>();
        for (String dirPattern : dirPatterns) {
            this.myDirPatterns.add(RECURSIVE_DIRS.equals(dirPattern) ? RECURSIVE_PATTERN_MARK : RepositoryPattern.buildPattern(dirPattern));
        }
        this.myFilePattern = RepositoryPattern.buildPattern(filePattern);
        StringBuilder fullPatternBuilder = new StringBuilder();
        fullPatternBuilder.append(fixedPath);
        if (!fixedPath.endsWith("/")) {
            fullPatternBuilder.append("/");
        }
        for (String dirPattern : dirPatterns) {
            fullPatternBuilder.append(dirPattern);
            fullPatternBuilder.append("/");
        }
        fullPatternBuilder.append(filePattern);
        this.myFullPattern = fullPatternBuilder.toString();
    }

    private static Pattern buildPattern(String patternText) {
        String quoted = "\\Q" + patternText + "\\E";
        return Pattern.compile(quoted.replace(ANY_FILE, "\\E.*\\Q"));
    }

    public String getFullPattern() {
        return this.myFullPattern;
    }

    @Nullable
    public VirtualFile findBaseDir() {
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myFixedPath);
    }

    public List<VirtualFile> collectFiles() {
        VirtualFile baseDir = this.findBaseDir();
        if (baseDir == null) {
            return Collections.emptyList();
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        this.walkDirPattern(files, 0, baseDir);
        return new ArrayList<VirtualFile>(files);
    }

    private void walkDirPattern(Set<VirtualFile> files, int iDirPattern, VirtualFile baseDir) {
        baseDir.refresh(false, false);
        if (iDirPattern == this.myDirPatterns.size()) {
            for (VirtualFile childFile : baseDir.getChildren()) {
                if (childFile.isDirectory() || !this.myFilePattern.matcher(childFile.getName()).matches()) continue;
                files.add(childFile);
            }
        } else {
            Pattern dirPattern = this.myDirPatterns.get(iDirPattern);
            if (dirPattern == RECURSIVE_PATTERN_MARK) {
                this.walkDirPattern(files, iDirPattern + 1, baseDir);
                for (VirtualFile childFile : baseDir.getChildren()) {
                    if (!childFile.isDirectory()) continue;
                    this.walkDirPattern(files, iDirPattern, childFile);
                }
            } else {
                for (VirtualFile childFile : baseDir.getChildren()) {
                    if (!childFile.isDirectory() || !dirPattern.matcher(childFile.getName()).matches()) continue;
                    this.walkDirPattern(files, iDirPattern + 1, childFile);
                }
            }
        }
    }

    public DMServerRepositoryItem getSource() {
        return this.mySource;
    }

    public boolean hasDirPatterns() {
        return !this.myDirPatterns.isEmpty();
    }
}

