/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install.impl;

import com.intellij.dmserver.install.impl.ConfigElementWrapper;
import com.intellij.dmserver.install.impl.DMServerConfigSupport20;
import com.intellij.dmserver.install.impl.DMServerConfigSupportBase;
import com.intellij.dmserver.install.impl.PropertiesUtil;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.integration.DMServerRepositoryExternalItem;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.DMServerRepositoryItem20Base;
import com.intellij.dmserver.integration.DMServerRepositoryWatchedItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;

public class DMServerConfigSupport2Base
extends DMServerConfigSupportBase {
    private static final Logger LOG = Logger.getInstance(DMServerConfigSupport20.class);
    private static final ConfigElement<?>[] ourKernelConfigElements = new ConfigElement[]{new BooleanConfigElement("shell.enabled", ourShellEnabledWrapper), new IntegerConfigElement("shell.port", ourShellPortWrapper), new IntegerConfigElement("deployer.timeout", ourDeploymentTimeoutSecsWrapper), new StringConfigElement("deployer.pickupDirectory", ourPickupFolderWrapper)};
    private static final ConfigElement<?>[] ourMedicConfigElements = new ConfigElement[]{new StringConfigElement("dump.root.directory", ourDumpsFolderWrapper), new BooleanConfigElement("log.wrapSysOut", new ConfigElementWrapper<Boolean>(){

        @Override
        public Boolean getValue(DMServerIntegrationData data) {
            return data.isWrapSystemOut();
        }

        @Override
        public void setValue(DMServerIntegrationData data, Boolean value) {
            data.setWrapSystemOut(value);
        }
    }), new BooleanConfigElement("log.wrapSysErr", new ConfigElementWrapper<Boolean>(){

        @Override
        public Boolean getValue(DMServerIntegrationData data) {
            return data.isWrapSystemErr();
        }

        @Override
        public void setValue(DMServerIntegrationData data, Boolean value) {
            data.setWrapSystemErr(value);
        }
    })};
    private static final Map<String, RepositoryItemCreator> ourRepositoryItemType2Creator = new HashMap<String, RepositoryItemCreator>();
    @NonNls
    private static final String ORDER_PROPERTY_NAME = "chain";
    private static final String ORDER_PROPERTY_VALUE_SPLITTER = ",";
    private final VirtualFile myKernelPropertiesFile;
    private final VirtualFile myMedicPropertiesFile;
    private final VirtualFile myRepositoryPropertiesFile;

    public DMServerConfigSupport2Base(@NonNls String kernelPropertiesPath, @NonNls String medicPropertiesPath, @NonNls String repositoryPropertiesPath, VirtualFile home) {
        this.myKernelPropertiesFile = home.findFileByRelativePath(kernelPropertiesPath);
        this.myMedicPropertiesFile = home.findFileByRelativePath(medicPropertiesPath);
        this.myRepositoryPropertiesFile = home.findFileByRelativePath(repositoryPropertiesPath);
    }

    @Override
    protected List<VirtualFile> getFiles() {
        return Arrays.asList(this.myKernelPropertiesFile, this.myMedicPropertiesFile, this.myRepositoryPropertiesFile);
    }

    @Override
    public void readFromServer(DMServerIntegrationData data) {
        try {
            this.myKernelPropertiesFile.refresh(false, false);
            Properties kernelProperties = PropertiesUtil.loadProperties(this.myKernelPropertiesFile);
            for (ConfigElement<?> element : ourKernelConfigElements) {
                element.load(kernelProperties, data);
            }
            this.myMedicPropertiesFile.refresh(false, false);
            Properties medicProperties = PropertiesUtil.loadProperties(this.myMedicPropertiesFile);
            for (ConfigElement<?> element : ourMedicConfigElements) {
                element.load(medicProperties, data);
            }
            this.myRepositoryPropertiesFile.refresh(false, false);
            Properties repositoryProperties = PropertiesUtil.loadProperties(this.myRepositoryPropertiesFile);
            DMServerConfigSupport2Base.readRepositoryProperties(repositoryProperties, data);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void readRepositoryProperties(Properties repositoryProperties, DMServerIntegrationData data) {
        HashMap<String, DMServerRepositoryItem20Base> name2repositoryItem = new HashMap<String, DMServerRepositoryItem20Base>();
        for (String propertyName : repositoryProperties.stringPropertyNames()) {
            String propertyValue;
            RepositoryItemCreator itemCreator;
            String itemName;
            List propertyNameParts = StringUtil.split((String)propertyName, (String)".");
            if (propertyNameParts.size() != 2 || !"type".equals(propertyNameParts.get(1)) || "".equals(itemName = (String)propertyNameParts.get(0)) || (itemCreator = ourRepositoryItemType2Creator.get(propertyValue = repositoryProperties.getProperty(propertyName))) == null) continue;
            DMServerRepositoryItem20Base repositoryItem = itemCreator.createRepositoryItem();
            repositoryItem.setName(itemName);
            repositoryItem.load(repositoryProperties);
            name2repositoryItem.put(itemName, repositoryItem);
        }
        String orderProperty = repositoryProperties.getProperty(ORDER_PROPERTY_NAME);
        List itemsOrder = orderProperty == null ? Collections.emptyList() : StringUtil.split((String)orderProperty, (String)ORDER_PROPERTY_VALUE_SPLITTER);
        ArrayList<DMServerRepositoryItem> repositoryItems = new ArrayList<DMServerRepositoryItem>();
        for (String itemName : itemsOrder) {
            DMServerRepositoryItem repositoryItem = (DMServerRepositoryItem)name2repositoryItem.remove(itemName);
            if (repositoryItem == null) continue;
            repositoryItems.add(repositoryItem);
        }
        repositoryItems.addAll(name2repositoryItem.values());
        data.setRepositoryItems(repositoryItems);
    }

    @Override
    public void writeToServer(DMServerIntegrationData data) {
        try {
            Properties kernelProperties = PropertiesUtil.loadProperties(this.myKernelPropertiesFile);
            for (ConfigElement<?> element : ourKernelConfigElements) {
                element.save(kernelProperties, data);
            }
            PropertiesUtil.saveProperties(this.myKernelPropertiesFile, kernelProperties);
            Properties medicProperties = PropertiesUtil.loadProperties(this.myMedicPropertiesFile);
            for (ConfigElement<?> element : ourMedicConfigElements) {
                element.save(medicProperties, data);
            }
            PropertiesUtil.saveProperties(this.myMedicPropertiesFile, medicProperties);
            Properties repositoryProperties = new Properties();
            DMServerConfigSupport2Base.writeRepositoryProperties(repositoryProperties, data);
            PropertiesUtil.saveProperties(this.myRepositoryPropertiesFile, repositoryProperties);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void writeRepositoryProperties(Properties repositoryProperties, DMServerIntegrationData data) {
        ArrayList<String> itemsOrder = new ArrayList<String>();
        for (DMServerRepositoryItem repositoryItem : data.getRepositoryItems()) {
            if (!(repositoryItem instanceof DMServerRepositoryItem20Base)) continue;
            DMServerRepositoryItem20Base repositoryItem20 = (DMServerRepositoryItem20Base)repositoryItem;
            repositoryItem20.save(repositoryProperties);
            itemsOrder.add(repositoryItem20.getName());
        }
        repositoryProperties.setProperty(ORDER_PROPERTY_NAME, StringUtil.join(itemsOrder, (String)ORDER_PROPERTY_VALUE_SPLITTER));
    }

    static {
        ourRepositoryItemType2Creator.put("watched", new RepositoryItemCreator(){

            @Override
            public DMServerRepositoryItem20Base createRepositoryItem() {
                return new DMServerRepositoryWatchedItem();
            }
        });
        ourRepositoryItemType2Creator.put("external", new RepositoryItemCreator(){

            @Override
            public DMServerRepositoryItem20Base createRepositoryItem() {
                return new DMServerRepositoryExternalItem();
            }
        });
    }

    private static interface RepositoryItemCreator {
        public DMServerRepositoryItem20Base createRepositoryItem();
    }

    private static class StringConfigElement
    extends ConfigElement<String> {
        StringConfigElement(@NonNls String propertyName, ConfigElementWrapper<String> stringConfigElementWrapper) {
            super(propertyName, stringConfigElementWrapper);
        }

        @Override
        protected String toValue(String propertyText) {
            return propertyText;
        }
    }

    private static class IntegerConfigElement
    extends ConfigElement<Integer> {
        IntegerConfigElement(@NonNls String propertyName, ConfigElementWrapper<Integer> integerConfigElementWrapper) {
            super(propertyName, integerConfigElementWrapper);
        }

        @Override
        protected Integer toValue(String propertyText) {
            return Integer.valueOf(propertyText);
        }
    }

    private static class BooleanConfigElement
    extends ConfigElement<Boolean> {
        BooleanConfigElement(@NonNls String propertyName, ConfigElementWrapper<Boolean> booleanConfigElementWrapper) {
            super(propertyName, booleanConfigElementWrapper);
        }

        @Override
        protected Boolean toValue(String propertyText) {
            return Boolean.valueOf(propertyText);
        }
    }

    private static abstract class ConfigElement<T> {
        private final ConfigElementWrapper<T> myElementWrapper;
        private final String myProperyName;

        ConfigElement(@NonNls String propertyName, ConfigElementWrapper<T> elementWrapper) {
            this.myProperyName = propertyName;
            this.myElementWrapper = elementWrapper;
        }

        private String getPropertyName() {
            return this.myProperyName;
        }

        public void load(Properties properties, DMServerIntegrationData data) {
            String propertyText = properties.getProperty(this.getPropertyName());
            if (propertyText != null) {
                this.setValue(data, this.toValue(propertyText));
            }
        }

        public void save(Properties properties, DMServerIntegrationData data) {
            properties.setProperty(this.getPropertyName(), this.toText(this.getValue(data)));
        }

        private String toText(T value) {
            return value.toString();
        }

        private void setValue(DMServerIntegrationData data, T value) {
            this.myElementWrapper.setValue(data, value);
        }

        private T getValue(DMServerIntegrationData data) {
            return this.myElementWrapper.getValue(data);
        }

        protected abstract T toValue(String var1);
    }
}

