/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.facet.DMCompositeType;
import com.intellij.dmserver.facet.DMConfigFacet;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMFacetsSwitch;
import com.intellij.dmserver.facet.DMModuleFacetSettingsPanel;
import com.intellij.dmserver.facet.DMNestedBundlesUpdater;
import com.intellij.dmserver.facet.NestedUnitIdentity;
import com.intellij.dmserver.facet.NestedUnitProvider;
import com.intellij.dmserver.facet.VersionsRangeDialog;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.IconUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import icons.DmServerSupportIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMModuleCompositeFacetSettingsPanel
implements DMModuleFacetSettingsPanel<DMCompositeFacetConfiguration> {
    private DefaultListModel myNestedBundlesListModel;
    private JPanel myMainPanel;
    private JRadioButton myPlanRadio;
    private JRadioButton myPlatformArchiveRadio;
    private JButton myAddBundleButton;
    private JButton myRemoveBundleButton;
    private JList myNestedBundlesList;
    private JLabel myTotalBundlesCountLabel;
    private JPanel myNestedBundlesGroup;
    private JPanel myRadioPanel;
    private JPanel myPlanFlagsPanel;
    private JCheckBox myAtomicCheckBox;
    private JCheckBox myScopedCheckBox;
    private JTextField myVersionTextField;
    private JPanel myVersionPanel;
    private JTextField myNameTextField;
    private JPanel myNamePanel;
    private JButton myVersionsButton;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private JLabel myWarningLabel;
    private final Set<Module> myAvailableNestedModules;
    private boolean myInitialized;
    private Project myProject;
    private NestedUnitProvider myNestedUnitProvider;
    private Behavior myBehavior;
    private Map<DMCompositeType, Behavior> myType2Behavior;
    private Module myConfiguredModule;

    public DMModuleCompositeFacetSettingsPanel() {
        Comparator comparator = (a, b) -> a.getName().compareTo(b.getName());
        this.$$$setupUI$$$();
        this.myAvailableNestedModules = new TreeSet<Module>(comparator);
        this.myInitialized = false;
    }

    @Override
    public void init(@Nullable Project project, @Nullable Module configuredModule, @NotNull ModulesProvider modulesProvider, @NotNull Disposable parentDisposable) {
        if (modulesProvider == null) {
            DMModuleCompositeFacetSettingsPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DMModuleCompositeFacetSettingsPanel.$$$reportNull$$$0(1);
        }
        this.myConfiguredModule = configuredModule;
        if (this.myInitialized) {
            throw new RuntimeException("Should be called once");
        }
        this.myInitialized = true;
        this.myProject = project;
        this.myNestedUnitProvider = new NestedUnitProvider(configuredModule, modulesProvider);
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.myPlanRadio);
        radioGroup.add(this.myPlatformArchiveRadio);
        Behavior[] behaviors = new Behavior[]{new PlanBehavior(), new ParBehavior()};
        this.myType2Behavior = new HashMap<DMCompositeType, Behavior>();
        for (final Behavior behavior : behaviors) {
            this.myType2Behavior.put(behavior.getType(), behavior);
            behavior.getRadioButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DMModuleCompositeFacetSettingsPanel.this.setBehavior(behavior.getType());
                }
            });
        }
        this.myScopedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMModuleCompositeFacetSettingsPanel.this.updateAvailableNestedModules();
            }
        });
        this.myNestedBundlesListModel = new DefaultListModel();
        this.myNestedBundlesList.setModel(this.myNestedBundlesListModel);
        this.myNestedBundlesList.setCellRenderer(new ModuleRenderer(this.myNestedBundlesList.getCellRenderer()));
        this.myNestedBundlesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DMModuleCompositeFacetSettingsPanel.this.updateEnablement();
            }
        });
        this.setBehavior(DMCompositeType.PLAN);
        this.myAddBundleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List toAdd = DMModuleCompositeFacetSettingsPanel.this.chooseNestedModules();
                ArrayList<NestedUnitIdentity> identitiesToAdd = new ArrayList<NestedUnitIdentity>();
                for (Module module : toAdd) {
                    NestedUnitIdentity unitIdentity = new NestedUnitIdentity(module);
                    DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesListModel.addElement(unitIdentity);
                    identitiesToAdd.add(unitIdentity);
                }
                int[] addedIndices = new int[toAdd.size()];
                int nextPosition = 0;
                for (NestedUnitIdentity identity : identitiesToAdd) {
                    addedIndices[nextPosition++] = DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesListModel.indexOf(identity);
                }
                DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesList.setSelectedIndices(addedIndices);
                DMModuleCompositeFacetSettingsPanel.this.nestedBundlesSetChanged();
            }
        });
        this.myRemoveBundleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Object next : DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesList.getSelectedValues()) {
                    DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesListModel.removeElement(next);
                }
                DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesList.setSelectedIndices(new int[0]);
                DMModuleCompositeFacetSettingsPanel.this.nestedBundlesSetChanged();
            }
        });
        this.myVersionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMModuleCompositeFacetSettingsPanel.this.onVersions();
            }
        });
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMModuleCompositeFacetSettingsPanel.this.onMoveUp();
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DMModuleCompositeFacetSettingsPanel.this.onMoveDown();
            }
        });
        IconUtils.setupWarningLabel(this.myWarningLabel);
        if (project != null) {
            new DMNestedBundlesUpdater(project, parentDisposable){

                @Override
                protected Collection<NestedUnitIdentity> getNestedBundles() {
                    return DMModuleCompositeFacetSettingsPanel.this.getNestedModuleIdentities();
                }

                @Override
                protected void setNestedBundles(Collection<NestedUnitIdentity> nestedBundles) {
                    DMModuleCompositeFacetSettingsPanel.this.setNestedModuleIdentities(nestedBundles);
                }

                @Override
                protected void dmFacetAddedOrRemoved(DMFacetBase facet) {
                    DMModuleCompositeFacetSettingsPanel.this.updateAvailableNestedModules();
                }
            };
        }
    }

    private Project getProject() {
        return this.myProject;
    }

    private void setBehavior(DMCompositeType type) {
        this.myBehavior = this.myType2Behavior.get((Object)type);
        this.updateAvailableNestedModules();
    }

    @Override
    public void load(@NotNull DMCompositeFacetConfiguration configuration) {
        if (configuration == null) {
            DMModuleCompositeFacetSettingsPanel.$$$reportNull$$$0(2);
        }
        this.myType2Behavior.get((Object)configuration.getCompositeType()).getRadioButton().setSelected(true);
        this.setBehavior(configuration.getCompositeType());
        this.myNameTextField.setText(configuration.getName(this.myConfiguredModule));
        this.myVersionTextField.setText(configuration.getVersion());
        this.myScopedCheckBox.setSelected(this.myBehavior.transformScoped(configuration.getScoped()));
        this.myAtomicCheckBox.setSelected(this.myBehavior.transformAtomic(configuration.getAtomic()));
        this.setNestedModuleIdentities(configuration.getNestedBundles());
    }

    @Override
    public void apply(@NotNull DMCompositeFacetConfiguration configuration) {
        if (configuration == null) {
            DMModuleCompositeFacetSettingsPanel.$$$reportNull$$$0(3);
        }
        this.save(configuration);
    }

    @Override
    public void save(@NotNull DMCompositeFacetConfiguration configuration) {
        if (configuration == null) {
            DMModuleCompositeFacetSettingsPanel.$$$reportNull$$$0(4);
        }
        configuration.setCompositeType(this.myBehavior.getType());
        configuration.setName(this.myNameTextField.getText());
        configuration.setVersion(this.myVersionTextField.getText());
        configuration.setScoped(this.myBehavior.transformScoped(this.myScopedCheckBox.isSelected()));
        configuration.setAtomic(this.myBehavior.transformAtomic(this.myAtomicCheckBox.isSelected()));
        configuration.setNestedBundles(this.getNestedModuleIdentities());
    }

    private void onMoveUp() {
        if (this.myNestedBundlesList.getSelectedIndices().length != 1) {
            return;
        }
        int selectedIndex = this.myNestedBundlesList.getSelectedIndex();
        if (selectedIndex == 0) {
            return;
        }
        Object selectedElement = this.myNestedBundlesListModel.getElementAt(selectedIndex);
        this.myNestedBundlesListModel.removeElementAt(selectedIndex);
        this.myNestedBundlesListModel.insertElementAt(selectedElement, selectedIndex - 1);
        this.myNestedBundlesList.setSelectedIndex(selectedIndex - 1);
    }

    private void onMoveDown() {
        if (this.myNestedBundlesList.getSelectedIndices().length != 1) {
            return;
        }
        int selectedIndex = this.myNestedBundlesList.getSelectedIndex();
        if (selectedIndex == this.myNestedBundlesListModel.size() - 1) {
            return;
        }
        Object selectedElement = this.myNestedBundlesListModel.getElementAt(selectedIndex);
        this.myNestedBundlesListModel.insertElementAt(selectedElement, selectedIndex + 2);
        this.myNestedBundlesListModel.removeElementAt(selectedIndex);
        this.myNestedBundlesList.setSelectedIndex(selectedIndex + 1);
    }

    private void onVersions() {
        ArrayList<NestedUnitIdentity> unitPlanIdentities = new ArrayList<NestedUnitIdentity>();
        for (Object next : this.myNestedBundlesList.getSelectedValues()) {
            unitPlanIdentities.add((NestedUnitIdentity)next);
        }
        VersionsRangeDialog versionsRangeDialog = new VersionsRangeDialog(this.myProject, unitPlanIdentities);
        if (versionsRangeDialog.showAndGet()) {
            this.myNestedBundlesList.updateUI();
        }
    }

    @Override
    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DMModuleCompositeFacetSettingsPanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private Set<Module> getNestedModules() {
        HashSet<Module> result = new HashSet<Module>();
        for (NestedUnitIdentity unitIdentity : this.getNestedModuleIdentities()) {
            ContainerUtil.addIfNotNull(result, (Object)unitIdentity.getModule());
        }
        return result;
    }

    private void updateAvailableNestedModules() {
        this.myAvailableNestedModules.clear();
        List<Module> possibleNestedModules = this.myNestedUnitProvider.getPossibleNestedModules(this.getEditedConfiguration());
        Set<Module> nestedModules = this.getNestedModules();
        for (Module possibleNestedModule : possibleNestedModules) {
            if (nestedModules.contains(possibleNestedModule)) continue;
            this.myAvailableNestedModules.add(possibleNestedModule);
        }
        this.myNestedBundlesList.updateUI();
        this.updateWarningLabel();
        this.updateEnablement();
    }

    private void updateWarningLabel() {
        boolean hasImpossibleNestedModules = false;
        Ref errorRef = new Ref();
        Module impossibleModule = null;
        for (Module module : this.getNestedModules()) {
            if (NestedUnitProvider.isPossibleNestedModule(module, this.getEditedConfiguration(), (Ref<? super String>)errorRef)) continue;
            hasImpossibleNestedModules = true;
            impossibleModule = module;
            break;
        }
        if (hasImpossibleNestedModules) {
            this.myWarningLabel.setText(DmServerBundle.message("DMModuleCompositeFacetSettingsPanel.error.module", impossibleModule.getName(), errorRef.get()));
        }
        this.myWarningLabel.setVisible(hasImpossibleNestedModules);
    }

    private DMCompositeFacetConfiguration getEditedConfiguration() {
        DMCompositeFacetConfiguration result = new DMCompositeFacetConfiguration();
        this.save(result);
        return result;
    }

    private List<Module> chooseNestedModules() {
        if (this.myAvailableNestedModules.isEmpty()) {
            return Collections.emptyList();
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(this.getProject(), new ArrayList<Module>(this.myAvailableNestedModules), this.myBehavior.getChooseModulesDialogTitle(), null){

            protected Icon getItemIcon(Module item) {
                return DMModuleCompositeFacetSettingsPanel.getModuleIcon(item);
            }
        };
        return dialog.showAndGet() ? dialog.getChosenElements() : Collections.emptyList();
    }

    public Set<NestedUnitIdentity> getNestedModuleIdentities() {
        Set<NestedUnitIdentity> result = this.myBehavior.createNestedModuleIdentitiesSet();
        for (int i = 0; i < this.myNestedBundlesListModel.getSize(); ++i) {
            result.add((NestedUnitIdentity)this.myNestedBundlesListModel.getElementAt(i));
        }
        return result;
    }

    public void setNestedModuleIdentities(Collection<NestedUnitIdentity> nestedUnitIdentities) {
        this.myNestedBundlesListModel.clear();
        for (NestedUnitIdentity unitIdentity : nestedUnitIdentities) {
            Module nextModule = unitIdentity.getModule();
            if (nextModule == null) continue;
            this.myNestedBundlesListModel.addElement(unitIdentity.clone());
        }
        this.nestedBundlesSetChanged();
    }

    private void nestedBundlesSetChanged() {
        this.myTotalBundlesCountLabel.setText(DmServerBundle.message("DMModuleCompositeFacetSettingsPanel.label.total.bundles", this.myNestedBundlesListModel.getSize()));
        this.updateAvailableNestedModules();
    }

    private static Icon getModuleIcon(Module module) {
        Icon result = module == null ? null : (Icon)new DMFacetsSwitch<Icon>(){

            @Override
            protected Icon doProcessBundleFacet(DMBundleFacet bundleFacet) {
                return DmServerSupportIcons.Bundle;
            }

            @Override
            protected Icon doProcessCompositeFacet(DMCompositeFacet compositeFacet) {
                switch (compositeFacet.getConfigurationImpl().getCompositeType()) {
                    case PAR: {
                        return DmServerSupportIcons.Par_bundle;
                    }
                    case PLAN: {
                        return DmServerSupportIcons.DM;
                    }
                }
                return null;
            }

            @Override
            protected Icon doProcessConfigFacet(DMConfigFacet configFacet) {
                return AllIcons.FileTypes.Text;
            }
        }.processModule(module);
        if (result == null) {
            result = PlatformIcons.ERROR_INTRODUCTION_ICON;
        }
        return result;
    }

    @Override
    public void updateEnablement() {
        this.myBehavior.updateEnablement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/facet/DMModuleCompositeFacetSettingsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/facet/DMModuleCompositeFacetSettingsPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        JTextField jTextField2;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel4;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel2;
        JButton jButton4;
        JButton jButton5;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myMainPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNestedBundlesGroup = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel5, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.nested.bundles"), (int)0, (int)0, null, null));
        this.myAddBundleButton = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.add"));
        jPanel5.add((Component)jButton5, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveBundleButton = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.remove"));
        jPanel5.add((Component)jButton4, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(5, 1, 2, 1, 0, 2, 1, 6, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 6, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myNestedBundlesList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        this.myTotalBundlesCountLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.total.zero"));
        jPanel5.add((Component)jLabel2, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myVersionsButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.versions"));
        jPanel5.add((Component)jButton3, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveUpButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.up"));
        jPanel5.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveDownButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.down"));
        jPanel5.add((Component)jButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRadioPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPlatformArchiveRadio = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.platform.archive"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPlanRadio = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.plan"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPlanFlagsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAtomicCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.atomic"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScopedCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.scoped"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVersionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleCompositeFacetSettingsPanel.version"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(100, 20), null));
        this.myNamePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMModuleConfigFacetSettingsPanel.name"));
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(49, 14), null));
        this.myNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        jLabel.setText("warning");
        jPanel6.add((Component)jLabel, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class PlanBehavior
    extends Behavior {
        private PlanBehavior() {
        }

        @Override
        public DMCompositeType getType() {
            return DMCompositeType.PLAN;
        }

        @Override
        public JRadioButton getRadioButton() {
            return DMModuleCompositeFacetSettingsPanel.this.myPlanRadio;
        }

        @Override
        public void updateEnablement() {
            DMModuleCompositeFacetSettingsPanel.this.myScopedCheckBox.setEnabled(true);
            DMModuleCompositeFacetSettingsPanel.this.myAtomicCheckBox.setEnabled(true);
            super.updateEnablement();
            DMModuleCompositeFacetSettingsPanel.this.myVersionsButton.setEnabled(DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesList.getSelectedIndex() >= 0);
            boolean hasExactlyOneSelectedNestedUnit = DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesList.getSelectedIndices().length == 1;
            DMModuleCompositeFacetSettingsPanel.this.myMoveUpButton.setEnabled(hasExactlyOneSelectedNestedUnit && DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesList.getSelectedIndex() > 0);
            DMModuleCompositeFacetSettingsPanel.this.myMoveDownButton.setEnabled(hasExactlyOneSelectedNestedUnit && DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesList.getSelectedIndex() < DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesListModel.size() - 1);
        }

        @Override
        public boolean transformAtomic(boolean atomic) {
            return atomic;
        }

        @Override
        public boolean transformScoped(boolean scoped) {
            return scoped;
        }

        @Override
        protected String getChooseModulesDialogTitle() {
            return DmServerBundle.message("DMModuleCompositeFacetSettingsPanel.PlanBehavior.chooser.title", new Object[0]);
        }

        @Override
        public String getNestedUnitIdentityText(NestedUnitIdentity unitIdentity) {
            return MessageFormat.format("{0} {1}", unitIdentity.getModuleName(), unitIdentity.getVersionRange());
        }

        @Override
        public Set<NestedUnitIdentity> createNestedModuleIdentitiesSet() {
            return new LinkedHashSet<NestedUnitIdentity>();
        }
    }

    private class ParBehavior
    extends Behavior {
        private ParBehavior() {
        }

        @Override
        public DMCompositeType getType() {
            return DMCompositeType.PAR;
        }

        @Override
        public JRadioButton getRadioButton() {
            return DMModuleCompositeFacetSettingsPanel.this.myPlatformArchiveRadio;
        }

        @Override
        public void updateEnablement() {
            DMModuleCompositeFacetSettingsPanel.this.myScopedCheckBox.setEnabled(false);
            DMModuleCompositeFacetSettingsPanel.this.myAtomicCheckBox.setEnabled(false);
            DMModuleCompositeFacetSettingsPanel.this.myVersionsButton.setEnabled(false);
            DMModuleCompositeFacetSettingsPanel.this.myMoveUpButton.setEnabled(false);
            DMModuleCompositeFacetSettingsPanel.this.myMoveDownButton.setEnabled(false);
            super.updateEnablement();
        }

        @Override
        public boolean transformAtomic(boolean atomic) {
            return true;
        }

        @Override
        public boolean transformScoped(boolean scoped) {
            return true;
        }

        @Override
        protected String getChooseModulesDialogTitle() {
            return DmServerBundle.message("DMModuleCompositeFacetSettingsPanel.ParBehavior.chooser.title", new Object[0]);
        }

        @Override
        public String getNestedUnitIdentityText(NestedUnitIdentity unitIdentity) {
            return unitIdentity.getModuleName();
        }

        @Override
        public Set<NestedUnitIdentity> createNestedModuleIdentitiesSet() {
            return new TreeSet<NestedUnitIdentity>();
        }
    }

    private abstract class Behavior {
        private Behavior() {
        }

        public abstract DMCompositeType getType();

        public abstract JRadioButton getRadioButton();

        public void updateEnablement() {
            DMModuleCompositeFacetSettingsPanel.this.myAddBundleButton.setEnabled(!DMModuleCompositeFacetSettingsPanel.this.myAvailableNestedModules.isEmpty());
            DMModuleCompositeFacetSettingsPanel.this.myRemoveBundleButton.setEnabled(DMModuleCompositeFacetSettingsPanel.this.myNestedBundlesList.getSelectedIndex() >= 0);
        }

        protected abstract String getChooseModulesDialogTitle();

        public abstract String getNestedUnitIdentityText(NestedUnitIdentity var1);

        public abstract Set<NestedUnitIdentity> createNestedModuleIdentitiesSet();

        public abstract boolean transformScoped(boolean var1);

        public abstract boolean transformAtomic(boolean var1);
    }

    private class ModuleRenderer
    extends ListCellRendererWrapper<NestedUnitIdentity> {
        ModuleRenderer(ListCellRenderer listCellRenderer) {
        }

        public void customize(JList list, NestedUnitIdentity value, int index, boolean selected, boolean hasFocus) {
            Module module = value.getModule();
            this.setText(DMModuleCompositeFacetSettingsPanel.this.myBehavior.getNestedUnitIdentityText(value));
            this.setIcon(DMModuleCompositeFacetSettingsPanel.getModuleIcon(module));
        }
    }
}

