/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.WithModuleArtifactUtil;
import com.intellij.dmserver.facet.DMFacetConfigurationBase;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommonPart;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.facet.JavaeeFacetListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl;
import com.intellij.util.descriptors.impl.ConfigFileMetaDataRegistryImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DMFacetBase<C extends DMFacetConfigurationBase<C>>
extends JavaeeFacet
implements JavaeeFacetEx {
    private final JavaeeFacetCommonPart myCommonPart;

    public DMFacetBase(@NotNull FacetType dmFacetType, @NotNull Module module, @NotNull String name, @NotNull C configuration, @Nullable Facet underlyingFacet) {
        if (dmFacetType == null) {
            DMFacetBase.$$$reportNull$$$0(0);
        }
        if (module == null) {
            DMFacetBase.$$$reportNull$$$0(1);
        }
        if (name == null) {
            DMFacetBase.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            DMFacetBase.$$$reportNull$$$0(3);
        }
        super(dmFacetType, module, name, configuration, underlyingFacet);
        ConfigFileMetaDataRegistryImpl metaDataProvider = new ConfigFileMetaDataRegistryImpl();
        ConfigFileInfoSetImpl descriptorsConfig = new ConfigFileInfoSetImpl((ConfigFileMetaDataProvider)metaDataProvider);
        this.myCommonPart = new JavaeeFacetCommonPart((JavaeeFacet)this, (ConfigFileMetaDataProvider)metaDataProvider, (ConfigFileInfoSet)descriptorsConfig);
        Disposer.register((Disposable)this, (Disposable)this.myCommonPart);
    }

    public JavaeeFacetCommonPart getCommonPart() {
        return this.myCommonPart;
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myCommonPart.getDescriptorsContainer();
    }

    public ModificationTracker getModificationTracker() {
        return this.myCommonPart.getModificationTracker();
    }

    public void addFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.addListener(listener);
    }

    public void removeFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.removeListener(listener);
    }

    public void onFacetChanged() {
        this.updateMainArtifact();
    }

    public void updateSupportWithArtifact(ModifiableRootModel rootModel, ModulesProvider modulesProvider) {
        this.updateSupport(rootModel, modulesProvider);
        this.updateMainArtifact();
    }

    public void updateMainArtifact() {
        WriteAction.run(() -> {
            DMArtifactTypeBase artifactType = this.selectMainArtifactType();
            Artifact mainArtifact = this.getMainArtifact();
            if (mainArtifact != null && artifactType.isCompatibleArtifact(mainArtifact)) {
                artifactType.synchronizeArtifact(mainArtifact, this.getModule(), this);
                return;
            }
            if (mainArtifact != null) {
                ArtifactManager manager = ArtifactManager.getInstance((Project)this.getModule().getProject());
                ModifiableArtifactModel model = manager.createModifiableModel();
                model.removeArtifact(mainArtifact);
                model.commit();
            }
            artifactType.createArtifactFor(this.getModule(), this);
        });
    }

    public Artifact getMainArtifact() {
        return WithModuleArtifactUtil.findDmBundleArtifactFor(this.getModule());
    }

    public abstract DMArtifactTypeBase selectMainArtifactType();

    public abstract C getConfigurationImpl();

    protected abstract void updateSupport(ModifiableRootModel var1, ModulesProvider var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dmFacetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "com/intellij/dmserver/facet/DMFacetBase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

