/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMBundleFacetConfiguration;
import com.intellij.dmserver.facet.DMFacetSupportProviderBase;
import com.intellij.dmserver.facet.DMWebFacetFrameworkSupportProvider;
import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.run.DMServerRunConfigurationType;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacetType;

public class DMBundleSupportProvider
extends DMFacetSupportProviderBase<DMBundleFacet, DMBundleFacetConfiguration> {
    private final DMWebFacetFrameworkSupportProvider myWebSupportProvider = new DMWebFacetFrameworkSupportProvider();

    public DMBundleSupportProvider() {
        super(DMBundleFacet.ID);
    }

    public DMWebFacetFrameworkSupportProvider getWebSupportProvider() {
        return this.myWebSupportProvider;
    }

    protected void setupConfiguration(DMBundleFacet dmBundleFacet, ModifiableRootModel modifiableRootModel, FrameworkVersion frameworkVersion) {
    }

    public String getUnderlyingFrameworkId() {
        return null;
    }

    @Override
    public void addDMSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
        if (module == null) {
            DMBundleSupportProvider.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            DMBundleSupportProvider.$$$reportNull$$$0(1);
        }
        DMBundleFacet.addRequiredFacet(module, OsmorcFacetType.getInstance(), null);
        super.addDMSupport(module, rootModel);
    }

    @Override
    protected void doFinishAddDMSupport(Module module, ModifiableRootModel rootModel, DMServerInstallation installation, DMBundleFacet facet) {
        if (installation == null || !installation.isValid()) {
            return;
        }
        Project project = module.getProject();
        Artifact artifact = facet.getMainArtifact();
        ApplicationServer appServer = installation.getOrCreateApplicationServer();
        ConfigurationFactory type = DMServerRunConfigurationType.getInstance().getLocalFactory();
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettingsImpl runSettings = (RunnerAndConfigurationSettingsImpl)runManager.createConfiguration(type.getName(), type);
        CommonStrategy configuration = (CommonStrategy)runSettings.getConfiguration();
        configuration.setApplicationServer(appServer);
        if (artifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)project, (RunConfiguration)configuration, (Artifact)artifact);
        }
        runManager.addConfiguration((RunnerAndConfigurationSettings)runSettings);
        runManager.setSelectedConfiguration((RunnerAndConfigurationSettings)runSettings);
        Library apiJar = DMBundleSupportProvider.addRequiredJars(module, DmServerBundle.message("DMBundleSupportProvider.server.library.name", new Object[0]), installation);
        rootModel.addLibraryEntry(apiJar);
        if (artifact != null) {
            WebArtifactUtil.getInstance().addLibrary(apiJar, artifact, project);
        }
    }

    private static Library addRequiredJars(Module module, String libraryName, @Nullable DMServerInstallation installation) {
        return (Library)WriteAction.compute(() -> {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(module.getProject());
            Library library = libraryTable.getLibraryByName(libraryName);
            if (library == null) {
                library = libraryTable.createLibrary(libraryName);
                Library.ModifiableModel model = library.getModifiableModel();
                if (installation != null) {
                    for (VirtualFile nextJar : installation.getSharedLibraries()) {
                        model.addJarDirectory(nextJar, false);
                    }
                }
                model.commit();
            }
            return library;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rootModel";
                break;
            }
        }
        objectArray[1] = "com/intellij/dmserver/facet/DMBundleSupportProvider";
        objectArray[2] = "addDMSupport";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

