/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy.jmx;

import com.intellij.dmserver.deploy.jmx.AbstractDMConnectorCommand;
import com.intellij.dmserver.run.DMServerInstance;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jetbrains.annotations.NonNls;

public class ConnectorForceCheckCommand
extends AbstractDMConnectorCommand<Object> {
    @NonNls
    private static final String JMX_OP_FORCE_CHECK = "forceCheck";

    public ConnectorForceCheckCommand(DMServerInstance dmServer) {
        super(dmServer);
    }

    @Override
    protected Object doExecute(MBeanServerConnection connection) throws JMException, IOException {
        String repositoryName = this.getServerInstance().getRepositoryName();
        if (repositoryName == null) {
            return null;
        }
        ObjectName repositoryMBean = this.getServerVersion().getRepositoryMBean(repositoryName);
        if (repositoryMBean == null) {
            return null;
        }
        ConnectorForceCheckCommand.invokeOperation(connection, repositoryMBean, JMX_OP_FORCE_CHECK, new Object[0]);
        return new Object();
    }
}

