/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.deploy.IDMCommand;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CommandsCollector {
    private final DMServerInstance myServerInstance;
    private final DeploymentModel myModel;

    public CommandsCollector(@NotNull DMServerInstance serverInstance, @NotNull DeploymentModel model) {
        if (serverInstance == null) {
            CommandsCollector.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CommandsCollector.$$$reportNull$$$0(1);
        }
        this.myServerInstance = serverInstance;
        this.myModel = model;
    }

    public List<IDMCommand> collectCommands() throws IOException {
        Artifact artifact = this.getModel().getArtifact();
        if (artifact == null) {
            ArtifactPointer artifactPointer = this.getModel().getArtifactPointer();
            throw new IOException("Deployment fails to access artifact " + (artifactPointer == null ? "" : artifactPointer.getArtifactName()));
        }
        ArrayList<IDMCommand> result = new ArrayList<IDMCommand>();
        ArtifactType type = artifact.getArtifactType();
        if (type instanceof DMArtifactTypeBase) {
            this.collectCommandsForDmArtifact(artifact, (DMArtifactTypeBase)type, result);
        } else if (type instanceof WarArtifactType) {
            this.collectCommandsForWarArtifact(artifact, (WarArtifactType)type, result);
        } else {
            throw new IOException("Unexpected artifact type: " + type.getPresentableName() + " found");
        }
        return result;
    }

    protected final DMServerInstance getServerInstance() {
        return this.myServerInstance;
    }

    protected final DeploymentModel getModel() {
        return this.myModel;
    }

    protected abstract void collectCommandsForDmArtifact(@NotNull Artifact var1, @NotNull DMArtifactTypeBase var2, @NotNull List<IDMCommand> var3) throws IOException;

    protected abstract void collectCommandsForWarArtifact(@NotNull Artifact var1, @NotNull WarArtifactType var2, @NotNull List<IDMCommand> var3) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "serverInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/intellij/dmserver/deploy/CommandsCollector";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

