/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.BytecodeReader;
import com.intellij.zkm.bytecode.Invocation;
import com.intellij.zkm.bytecode.InvocationReader;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

class InvocationReaderImpl
extends BytecodeReader
implements InvocationReader {
    InvocationReaderImpl(@NotNull TypeFactory types) {
        if (types == null) {
            InvocationReaderImpl.$$$reportNull$$$0(0);
        }
        super(types);
    }

    @Override
    @NotNull
    public Map<Signature, Set<Invocation>> read(@NotNull InputStream stream, @NotNull String methodName, int lineNumber) throws IOException {
        if (stream == null) {
            InvocationReaderImpl.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            InvocationReaderImpl.$$$reportNull$$$0(2);
        }
        ClassReader reader = new ClassReader(stream);
        InvocationCollector collector = new InvocationCollector(methodName, lineNumber);
        reader.accept((ClassVisitor)collector, 4);
        Map<Signature, Set<Invocation>> map = collector.getInvocations();
        if (map == null) {
            InvocationReaderImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/InvocationReaderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/InvocationReaderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InvocationCollector
    extends ClassVisitor {
        private final String myMethodName;
        private final int myLineNumber;
        private final Map<Signature, Set<Invocation>> myInvocations;

        InvocationCollector(String methodName, int lineNumber) {
            super(458752);
            this.myInvocations = new HashMap<Signature, Set<Invocation>>();
            this.myMethodName = methodName;
            this.myLineNumber = lineNumber;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return this.myMethodName.equals(name) ? new MyMethodVisitor(InvocationReaderImpl.this.createSignature(access, name, desc)) : null;
        }

        Map<Signature, Set<Invocation>> getInvocations() {
            return Collections.unmodifiableMap(this.myInvocations);
        }

        private class MyMethodVisitor
        extends MethodVisitor {
            private final Signature mySignature;
            private int myCurrentLineNumber;

            MyMethodVisitor(Signature signature) {
                super(458752);
                this.myCurrentLineNumber = -1;
                this.mySignature = signature;
            }

            public void visitLineNumber(int line, Label start) {
                this.myCurrentLineNumber = line;
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (InvocationCollector.this.myLineNumber == -1 || this.myCurrentLineNumber == InvocationCollector.this.myLineNumber) {
                    Set invocations = InvocationCollector.this.myInvocations.computeIfAbsent(this.mySignature, k -> new HashSet());
                    invocations.add(InvocationReaderImpl.this.createInvocation(owner, name, desc));
                }
            }
        }
    }
}

