/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.knopflerfish;

import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.impl.AbstractFrameworkInstanceManager;
import org.osmorc.run.ui.SelectedBundle;

public class KnopflerfishInstanceManager
extends AbstractFrameworkInstanceManager {
    private static final String[] BUNDLE_DIRS = new String[]{"knopflerfish.org/osgi", "knopflerfish.org/osgi/jars/*", "osgi", "osgi/jars/*", "bundles"};
    private static final Pattern SYSTEM_BUNDLE = Pattern.compile("framework.*\\.jar");
    private static final Pattern SHELL_BUNDLES = Pattern.compile("(log_api|cm_api|console_all|consoletty|frameworkcommands).*\\.jar");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String getVersion(@NotNull FrameworkInstanceDefinition instance) {
        Collection<SelectedBundle> bundles;
        if (instance == null) {
            KnopflerfishInstanceManager.$$$reportNull$$$0(0);
        }
        if ((bundles = this.getFrameworkBundles(instance, FrameworkInstanceManager.FrameworkBundleType.SYSTEM)).size() != 1) return null;
        String path = bundles.iterator().next().getBundlePath();
        if (path == null) return null;
        try (JarFile jar = new JarFile(path);){
            ZipEntry entry = jar.getEntry("release");
            if (entry == null) return null;
            String string = FileUtil.loadTextAndClose((InputStream)jar.getInputStream(entry));
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<SelectedBundle> getFrameworkBundles(@NotNull FrameworkInstanceDefinition instance, @NotNull FrameworkInstanceManager.FrameworkBundleType type) {
        if (instance == null) {
            KnopflerfishInstanceManager.$$$reportNull$$$0(1);
        }
        if (type == null) {
            KnopflerfishInstanceManager.$$$reportNull$$$0(2);
        }
        Collection<SelectedBundle> collection = this.collectBundles(instance, type, BUNDLE_DIRS, SYSTEM_BUNDLE, "org.knopflerfish.framework.Main", 1, SHELL_BUNDLES, null, 5);
        if (collection == null) {
            KnopflerfishInstanceManager.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishInstanceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/frameworkintegration/impl/knopflerfish/KnopflerfishInstanceManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkBundles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkBundles";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

