/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.impl.AbstractFrameworkRunner;
import org.osmorc.frameworkintegration.impl.GenericRunProperties;
import org.osmorc.frameworkintegration.impl.equinox.EquinoxRunProperties;
import org.osmorc.run.ui.SelectedBundle;

public class EquinoxRunner
extends AbstractFrameworkRunner {
    static final String MAIN_CLASS = "org.eclipse.core.runtime.adaptor.EclipseStarter";

    @Override
    protected void setupParameters(@NotNull JavaParameters parameters) {
        if (parameters == null) {
            EquinoxRunner.$$$reportNull$$$0(0);
        }
        ParametersList vmParameters = parameters.getVMParametersList();
        ArrayList bundles = ContainerUtil.newArrayList();
        for (SelectedBundle bundle : this.myBundles) {
            String bundlePath = bundle.getBundlePath();
            if (bundlePath == null) continue;
            boolean isFragment = CachingBundleInfoProvider.isFragmentBundle((String)bundlePath);
            String bundleUrl = this.toFileUri(bundlePath);
            if (!isFragment) {
                int startLevel = this.getBundleStartLevel(bundle);
                bundleUrl = bundleUrl + "@" + startLevel;
                if (bundle.isStartAfterInstallation()) {
                    bundleUrl = bundleUrl + ":start";
                }
            }
            bundles.add(bundleUrl);
        }
        if (!bundles.isEmpty()) {
            vmParameters.addProperty("osgi.bundles", StringUtil.join((Collection)bundles, (String)","));
        }
        int startLevel = this.getFrameworkStartLevel();
        vmParameters.addProperty("osgi.startLevel", String.valueOf(startLevel));
        int defaultStartLevel = this.myRunConfiguration.getDefaultStartLevel();
        vmParameters.addProperty("osgi.bundles.defaultStartLevel", String.valueOf(defaultStartLevel));
        if (GenericRunProperties.isStartConsole(this.myAdditionalProperties)) {
            vmParameters.addProperty("osgi.console");
            if (VersionComparatorUtil.compare((String)this.myInstance.getVersion(), (String)"3.8") < 0) {
                vmParameters.addProperty("osgi.console.enable.builtin", "true");
            }
        }
        vmParameters.addProperty("osgi.clean", "true");
        if (GenericRunProperties.isDebugMode(this.myAdditionalProperties)) {
            vmParameters.addProperty("osgi.debug");
            vmParameters.addProperty("eclipse.consoleLog", "true");
        }
        String product = EquinoxRunProperties.getEquinoxProduct(this.myAdditionalProperties);
        String application = EquinoxRunProperties.getEquinoxApplication(this.myAdditionalProperties);
        if (!StringUtil.isEmptyOrSpaces((String)product)) {
            vmParameters.defineProperty("eclipse.product", product);
            vmParameters.defineProperty("eclipse.ignoreApp", "false");
        } else if (!StringUtil.isEmptyOrSpaces((String)application)) {
            vmParameters.defineProperty("eclipse.application", application);
            vmParameters.defineProperty("eclipse.ignoreApp", "false");
        } else {
            vmParameters.defineProperty("eclipse.ignoreApp", "true");
        }
        parameters.setMainClass(MAIN_CLASS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/osmorc/frameworkintegration/impl/equinox/EquinoxRunner", "setupParameters"));
    }
}

