/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.jetbrains.osgi.jps.model.OutputPathType;
import org.jetbrains.osgi.jps.util.OrderedProperties;
import org.osmorc.OsmorcProjectComponent;
import org.osmorc.facet.OsgiCoreLibraryType;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.ui.OsmorcFacetGeneralEditorTab;
import org.osmorc.facet.ui.OsmorcFacetJAREditorTab;
import org.osmorc.facet.ui.OsmorcFacetManifestGenerationEditorTab;
import org.osmorc.settings.ProjectSettings;

public class OsmorcFacetConfiguration
implements FacetConfiguration,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(OsmorcFacetConfiguration.class);
    private static final String MANIFEST_GENERATION_MODE = "manifestGenerationMode";
    private static final String OSMORC_CONTROLS_MANIFEST = "osmorcControlsManifest";
    private static final String USE_BND_FILE = "useBndFile";
    private static final String BND_FILE_LOCATION = "bndFileLocation";
    private static final String USE_BUNDLOR_FILE = "useBundlorFile";
    private static final String BUNDLOR_FILE_LOCATION = "bundlorFileLocation";
    private static final String MANIFEST_LOCATION = "manifestLocation";
    private static final String JAR_FILE_LOCATION = "jarfileLocation";
    private static final String BUNDLE_ACTIVATOR = "bundleActivator";
    private static final String BUNDLE_SYMBOLIC_NAME = "bundleSymbolicName";
    private static final String BUNDLE_VERSION = "bundleVersion";
    private static final String USE_PROJECT_DEFAULT_MANIFEST_FILE_LOCATION = "useProjectDefaultManifestFileLocation";
    private static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String IGNORE_FILE_PATTERN = "ignoreFilePattern";
    private static final String ALWAYS_REBUILD_BUNDLE_JAR = "alwaysRebuildBundleJAR";
    private static final String DO_NOT_SYNCHRONIZE_WITH_MAVEN = "doNotSynchronizeWithMaven";
    private static final String OUTPUT_PATH_TYPE = "outputPathType";
    private static final String PROPERTY = "property";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private OsmorcFacet myFacet;
    private String myManifestLocation;
    private String myJarFileLocation;
    private String myBundleSymbolicName;
    private String myBundleActivator;
    private String myBundleVersion;
    private String myAdditionalProperties;
    private List<Pair<String, String>> myAdditionalJARContents;
    private boolean myUseProjectDefaultManifestFileLocation = true;
    private boolean myDoNotSynchronizeWithMaven = false;
    private String myBndFileLocation;
    private String myBundlorFileLocation;
    private String myIgnoreFilePattern;
    private boolean myAlwaysRebuildBundleJAR;
    private OutputPathType myOutputPathType;
    private ManifestGenerationMode myManifestGenerationMode = ManifestGenerationMode.OsmorcControlled;
    private volatile long myModificationCount = 0L;

    public FacetEditorTab[] createEditorTabs(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        FrameworkLibraryValidator validator = OsgiCoreLibraryType.getValidator(context, validatorsManager);
        validatorsManager.registerValidator((FacetEditorValidator)validator, new JComponent[0]);
        return new FacetEditorTab[]{new OsmorcFacetGeneralEditorTab(context, validatorsManager), new OsmorcFacetJAREditorTab(context, validatorsManager), new OsmorcFacetManifestGenerationEditorTab(context)};
    }

    public void readExternal(Element element) {
        if (element.getAttributeValue(MANIFEST_GENERATION_MODE) == null) {
            boolean osmorcControlsManifest = Boolean.parseBoolean(element.getAttributeValue(OSMORC_CONTROLS_MANIFEST, "true"));
            boolean useBndFile = Boolean.parseBoolean(element.getAttributeValue(USE_BND_FILE, "false"));
            boolean useBundlorFile = Boolean.parseBoolean(element.getAttributeValue(USE_BUNDLOR_FILE, "false"));
            this.setManifestGenerationMode(ManifestGenerationMode.OsmorcControlled);
            if (osmorcControlsManifest && !useBndFile && !useBundlorFile) {
                this.setManifestGenerationMode(ManifestGenerationMode.OsmorcControlled);
            } else if (!osmorcControlsManifest && useBndFile && !useBundlorFile || osmorcControlsManifest && useBndFile && !useBundlorFile) {
                this.setManifestGenerationMode(ManifestGenerationMode.Bnd);
            } else if (!osmorcControlsManifest && !useBndFile && useBundlorFile) {
                this.setManifestGenerationMode(ManifestGenerationMode.Bundlor);
            } else if (!osmorcControlsManifest && !useBndFile) {
                this.setManifestGenerationMode(ManifestGenerationMode.Manually);
            } else {
                String message = "The configuration at least one OSGi facet is invalid and has been reset. Please check your facet settings!";
                OsmorcProjectComponent.IMPORTANT_NOTIFICATIONS.createNotification(message, NotificationType.WARNING).notify(this.myFacet.getModule().getProject());
            }
        } else {
            String manifestGenerationModeName = element.getAttributeValue(MANIFEST_GENERATION_MODE, ManifestGenerationMode.OsmorcControlled.name());
            ManifestGenerationMode manifestGenerationMode = ManifestGenerationMode.valueOf((String)manifestGenerationModeName);
            this.setManifestGenerationMode(manifestGenerationMode);
        }
        this.setBndFileLocation(element.getAttributeValue(BND_FILE_LOCATION));
        this.setBundlorFileLocation(element.getAttributeValue(BUNDLOR_FILE_LOCATION));
        this.setManifestLocation(element.getAttributeValue(MANIFEST_LOCATION));
        String outputPathTypeName = element.getAttributeValue(OUTPUT_PATH_TYPE, OutputPathType.SpecificOutputPath.name());
        OutputPathType outputPathType = OutputPathType.valueOf((String)outputPathTypeName);
        this.setJarFileLocation(element.getAttributeValue(JAR_FILE_LOCATION), outputPathType);
        this.setBundleActivator(element.getAttributeValue(BUNDLE_ACTIVATOR));
        this.setBundleSymbolicName(element.getAttributeValue(BUNDLE_SYMBOLIC_NAME));
        this.setBundleVersion(element.getAttributeValue(BUNDLE_VERSION));
        this.setIgnoreFilePattern(element.getAttributeValue(IGNORE_FILE_PATTERN));
        this.setUseProjectDefaultManifestFileLocation(Boolean.parseBoolean(element.getAttributeValue(USE_PROJECT_DEFAULT_MANIFEST_FILE_LOCATION, "true")));
        this.setAlwaysRebuildBundleJAR(Boolean.parseBoolean(element.getAttributeValue(ALWAYS_REBUILD_BUNDLE_JAR, "false")));
        this.setDoNotSynchronizeWithMaven(Boolean.parseBoolean(element.getAttributeValue(DO_NOT_SYNCHRONIZE_WITH_MAVEN, "false")));
        Element props = element.getChild(ADDITIONAL_PROPERTIES);
        if (props != null) {
            List children = props.getChildren();
            if (children.isEmpty()) {
                this.setAdditionalProperties(props.getText());
            } else {
                StringBuilder builder = new StringBuilder();
                for (Object child : children) {
                    Element prop = (Element)child;
                    builder.append(prop.getAttributeValue(KEY)).append(":").append(prop.getAttributeValue(VALUE)).append("\n");
                }
                this.setAdditionalProperties(builder.toString());
            }
        }
        List<Pair<String, String>> additionalJARContents = this.getAdditionalJARContents();
        Element additionalJARContentsElement = element.getChild("additionalJARContents");
        if (additionalJARContentsElement != null) {
            List children = additionalJARContentsElement.getChildren("entry");
            for (Element entryElement : children) {
                additionalJARContents.add((Pair<String, String>)Pair.create((Object)entryElement.getAttributeValue("source"), (Object)entryElement.getAttributeValue("dest")));
            }
        }
        ++this.myModificationCount;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(MANIFEST_GENERATION_MODE, this.getManifestGenerationMode().name());
        element.setAttribute(MANIFEST_LOCATION, this.getManifestLocation());
        element.setAttribute(JAR_FILE_LOCATION, this.myJarFileLocation != null ? this.myJarFileLocation : "");
        element.setAttribute(OUTPUT_PATH_TYPE, this.getOutputPathType().name());
        element.setAttribute(BND_FILE_LOCATION, this.getBndFileLocation());
        element.setAttribute(BUNDLOR_FILE_LOCATION, this.getBundlorFileLocation());
        element.setAttribute(BUNDLE_ACTIVATOR, this.getBundleActivator());
        element.setAttribute(BUNDLE_SYMBOLIC_NAME, this.getBundleSymbolicName());
        element.setAttribute(BUNDLE_VERSION, this.getBundleVersion());
        element.setAttribute(IGNORE_FILE_PATTERN, this.getIgnoreFilePattern());
        element.setAttribute(USE_PROJECT_DEFAULT_MANIFEST_FILE_LOCATION, String.valueOf(this.isUseProjectDefaultManifestFileLocation()));
        element.setAttribute(ALWAYS_REBUILD_BUNDLE_JAR, String.valueOf(this.isAlwaysRebuildBundleJAR()));
        element.setAttribute(DO_NOT_SYNCHRONIZE_WITH_MAVEN, String.valueOf(this.myDoNotSynchronizeWithMaven));
        Element props = new Element(ADDITIONAL_PROPERTIES);
        Map<String, String> map = this.getAdditionalPropertiesAsMap();
        for (String key : map.keySet()) {
            String value = map.get(key);
            if (key.equals("Include-Resource")) {
                Parameters parameters = OSGiHeader.parseHeader((String)value);
                PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)this.myFacet.getModule());
                StringBuilder result = new StringBuilder(value.length());
                int last = 0;
                for (String pair : parameters.keySet()) {
                    int p;
                    String source;
                    if (StringUtil.startsWithChar((CharSequence)pair, (char)'{') && StringUtil.endsWithChar((CharSequence)pair, (char)'}')) {
                        pair = pair.substring(1, pair.length() - 1).trim();
                    }
                    if (StringUtil.startsWithChar((CharSequence)(source = ((p = pair.indexOf(61)) < 0 ? pair : pair.substring(p + 1)).trim()), (char)'@')) {
                        source = source.substring(1);
                    }
                    String collapsedSource = macroManager.collapsePath(source);
                    int sourceStart = value.indexOf(source, last);
                    result.append(value, last, sourceStart).append(collapsedSource);
                    last = sourceStart + source.length();
                }
                result.append(value, last, value.length());
                value = result.toString();
            }
            Element prop = new Element(PROPERTY);
            prop.setAttribute(KEY, key);
            prop.setAttribute(VALUE, value);
            props.addContent(prop);
        }
        element.addContent(props);
        Element additionalJARContentsElement = new Element("additionalJARContents");
        List<Pair<String, String>> additionalJARContents = this.getAdditionalJARContents();
        for (Pair<String, String> additionalJARContent : additionalJARContents) {
            Element entry = new Element("entry");
            entry.setAttribute("source", (String)additionalJARContent.getFirst());
            entry.setAttribute("dest", (String)additionalJARContent.getSecond());
            additionalJARContentsElement.addContent(entry);
        }
        element.addContent(additionalJARContentsElement);
    }

    public ManifestGenerationMode getManifestGenerationMode() {
        return this.myManifestGenerationMode;
    }

    public void setManifestGenerationMode(@NotNull ManifestGenerationMode manifestGenerationMode) {
        if (manifestGenerationMode == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(0);
        }
        this.myManifestGenerationMode = manifestGenerationMode;
        ++this.myModificationCount;
    }

    public boolean isOsmorcControlsManifest() {
        return this.getManifestGenerationMode() == ManifestGenerationMode.OsmorcControlled;
    }

    public boolean isManifestManuallyEdited() {
        return this.getManifestGenerationMode() == ManifestGenerationMode.Manually;
    }

    public boolean isUseBundlorFile() {
        return this.getManifestGenerationMode() == ManifestGenerationMode.Bundlor;
    }

    public boolean isUseBndFile() {
        return this.getManifestGenerationMode() == ManifestGenerationMode.Bnd;
    }

    @NotNull
    public String getManifestLocation() {
        String string = this.myManifestLocation != null ? this.myManifestLocation : "";
        if (string == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setManifestLocation(String manifestLocation) {
        this.myManifestLocation = manifestLocation;
        ++this.myModificationCount;
    }

    @NotNull
    public String getJarFileLocation() {
        String nullSafeLocation;
        String string = nullSafeLocation = this.myJarFileLocation != null ? this.myJarFileLocation : "";
        if (this.myOutputPathType == null || this.myFacet == null) {
            String string2 = nullSafeLocation;
            if (string2 == null) {
                OsmorcFacetConfiguration.$$$reportNull$$$0(2);
            }
            return string2;
        }
        switch (this.myOutputPathType) {
            case CompilerOutputPath: {
                String moduleCompilerOutputPath = CompilerPaths.getModuleOutputPath((Module)this.myFacet.getModule(), (boolean)false);
                if (moduleCompilerOutputPath != null) {
                    String string3 = PathUtil.getParentPath((String)moduleCompilerOutputPath) + '/' + nullSafeLocation;
                    if (string3 == null) {
                        OsmorcFacetConfiguration.$$$reportNull$$$0(3);
                    }
                    return string3;
                }
                String string4 = nullSafeLocation;
                if (string4 == null) {
                    OsmorcFacetConfiguration.$$$reportNull$$$0(4);
                }
                return string4;
            }
            case OsgiOutputPath: {
                String bundlesOutputPath;
                ProjectSettings projectSettings = (ProjectSettings)ModuleServiceManager.getService((Module)this.myFacet.getModule(), ProjectSettings.class);
                if (projectSettings != null && (bundlesOutputPath = projectSettings.getBundlesOutputPath()) != null && bundlesOutputPath.trim().length() != 0) {
                    String string5 = bundlesOutputPath + "/" + nullSafeLocation;
                    if (string5 == null) {
                        OsmorcFacetConfiguration.$$$reportNull$$$0(5);
                    }
                    return string5;
                }
                String string6 = ProjectSettings.getDefaultBundlesOutputPath(this.myFacet.getModule().getProject()) + "/" + nullSafeLocation;
                if (string6 == null) {
                    OsmorcFacetConfiguration.$$$reportNull$$$0(6);
                }
                return string6;
            }
        }
        String string7 = nullSafeLocation;
        if (string7 == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(7);
        }
        return string7;
    }

    @NotNull
    public String getJarFileName() {
        if (this.myOutputPathType == null) {
            if ("" == null) {
                OsmorcFacetConfiguration.$$$reportNull$$$0(8);
            }
            return "";
        }
        switch (this.myOutputPathType) {
            case CompilerOutputPath: 
            case OsgiOutputPath: 
            case SpecificOutputPath: {
                String completeOutputPath = this.getJarFileLocation();
                File f = new File(completeOutputPath);
                String string = f.getName();
                if (string == null) {
                    OsmorcFacetConfiguration.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        String string = this.getJarFileLocation();
        if (string == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getJarFilePath() {
        if (this.myOutputPathType == null) {
            if ("" == null) {
                OsmorcFacetConfiguration.$$$reportNull$$$0(11);
            }
            return "";
        }
        switch (this.myOutputPathType) {
            case CompilerOutputPath: 
            case OsgiOutputPath: 
            case SpecificOutputPath: {
                String completeOutputPath = this.getJarFileLocation();
                File f = new File(completeOutputPath);
                String parent = f.getParent();
                if (parent == null) {
                    if ("" == null) {
                        OsmorcFacetConfiguration.$$$reportNull$$$0(12);
                    }
                    return "";
                }
                String string = parent;
                if (string == null) {
                    OsmorcFacetConfiguration.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        if ("" == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(14);
        }
        return "";
    }

    public void setJarFileLocation(String jarFileLocation, OutputPathType outputPathType) {
        this.myJarFileLocation = jarFileLocation;
        this.myOutputPathType = outputPathType;
        ++this.myModificationCount;
    }

    public OutputPathType getOutputPathType() {
        return this.myOutputPathType != null ? this.myOutputPathType : OutputPathType.SpecificOutputPath;
    }

    @NotNull
    public String getBundleSymbolicName() {
        String string = this.myBundleSymbolicName != null ? this.myBundleSymbolicName : "";
        if (string == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setBundleSymbolicName(@Nullable String bundleSymbolicName) {
        this.myBundleSymbolicName = bundleSymbolicName;
        ++this.myModificationCount;
    }

    public String getBundleActivator() {
        return this.myBundleActivator != null ? this.myBundleActivator : "";
    }

    public void setBundleActivator(@Nullable String bundleActivator) {
        this.myBundleActivator = bundleActivator;
        ++this.myModificationCount;
    }

    @NotNull
    public String getBundleVersion() {
        String string = this.myBundleVersion != null ? this.myBundleVersion : "1.0.0";
        if (string == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void setBundleVersion(@Nullable String bundleVersion) {
        this.myBundleVersion = bundleVersion;
        ++this.myModificationCount;
    }

    public void setAdditionalProperties(@Nullable String additionalProperties) {
        this.myAdditionalProperties = additionalProperties;
        ++this.myModificationCount;
    }

    @NotNull
    public String getAdditionalProperties() {
        String string = this.myAdditionalProperties != null ? this.myAdditionalProperties : "";
        if (string == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public Map<String, String> getAdditionalPropertiesAsMap() {
        Map map;
        try {
            OrderedProperties p = new OrderedProperties();
            p.load((Reader)new StringReader(this.getAdditionalProperties()));
            map = p.toMap();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            Map<String, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                OsmorcFacetConfiguration.$$$reportNull$$$0(19);
            }
            return map2;
        }
        if (map == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(18);
        }
        return map;
    }

    public void importAdditionalProperties(@NotNull Map<String, String> properties, boolean overwrite) {
        Map<String, String> existing;
        if (properties == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(20);
        }
        Map<String, String> map = existing = overwrite ? properties : this.getAdditionalPropertiesAsMap();
        if (!overwrite) {
            existing.putAll(properties);
        }
        StringBuilder builder = new StringBuilder();
        for (String key : existing.keySet()) {
            String value = existing.get(key);
            value = StringUtil.replace((String)value, (String)"\n", (String)"\\\n");
            builder.append(key).append(": ").append(value).append("\n");
        }
        this.setAdditionalProperties(builder.toString());
    }

    public void setUseProjectDefaultManifestFileLocation(boolean useProjectDefaultManifestFileLocation) {
        this.myUseProjectDefaultManifestFileLocation = useProjectDefaultManifestFileLocation;
        ++this.myModificationCount;
    }

    public boolean isUseProjectDefaultManifestFileLocation() {
        return this.myUseProjectDefaultManifestFileLocation;
    }

    @NotNull
    public String getBndFileLocation() {
        String string = this.myBndFileLocation != null ? this.myBndFileLocation : "";
        if (string == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(21);
        }
        return string;
    }

    public void setBndFileLocation(String bndFileLocation) {
        this.myBndFileLocation = bndFileLocation;
        ++this.myModificationCount;
    }

    @NotNull
    public String getBundlorFileLocation() {
        String string = this.myBundlorFileLocation != null ? this.myBundlorFileLocation : "";
        if (string == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(22);
        }
        return string;
    }

    public void setBundlorFileLocation(String _bundlorFileLocation) {
        this.myBundlorFileLocation = _bundlorFileLocation;
        ++this.myModificationCount;
    }

    @NotNull
    public List<Pair<String, String>> getAdditionalJARContents() {
        if (this.myAdditionalJARContents == null) {
            this.myAdditionalJARContents = new ArrayList<Pair<String, String>>();
        }
        List<Pair<String, String>> list = this.myAdditionalJARContents;
        if (list == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(23);
        }
        return list;
    }

    public void setAdditionalJARContents(@NotNull List<Pair<String, String>> additionalJARContents) {
        if (additionalJARContents == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(24);
        }
        this.myAdditionalJARContents = additionalJARContents;
        ++this.myModificationCount;
    }

    @NotNull
    public String getIgnoreFilePattern() {
        String string = this.myIgnoreFilePattern != null ? this.myIgnoreFilePattern : "";
        if (string == null) {
            OsmorcFacetConfiguration.$$$reportNull$$$0(25);
        }
        return string;
    }

    public void setIgnoreFilePattern(String attributeValue) {
        this.myIgnoreFilePattern = attributeValue;
        ++this.myModificationCount;
    }

    public boolean isAlwaysRebuildBundleJAR() {
        return this.myAlwaysRebuildBundleJAR;
    }

    public void setAlwaysRebuildBundleJAR(boolean alwaysRebuildBundleJAR) {
        this.myAlwaysRebuildBundleJAR = alwaysRebuildBundleJAR;
        ++this.myModificationCount;
    }

    public boolean isDoNotSynchronizeWithMaven() {
        return this.myDoNotSynchronizeWithMaven;
    }

    public void setDoNotSynchronizeWithMaven(boolean doNotSynchronizeWithMaven) {
        this.myDoNotSynchronizeWithMaven = doNotSynchronizeWithMaven;
        ++this.myModificationCount;
    }

    public void setFacet(OsmorcFacet facet) {
        this.myFacet = facet;
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = MANIFEST_GENERATION_MODE;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osmorc/facet/OsmorcFacetConfiguration";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalJARContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osmorc/facet/OsmorcFacetConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManifestLocation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFileLocation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFileName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFilePath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleSymbolicName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleVersion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProperties";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPropertiesAsMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBndFileLocation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundlorFileLocation";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalJARContents";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreFilePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setManifestGenerationMode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "importAdditionalProperties";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalJARContents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

