/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.update;

import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.HotSwapStatusListener;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationDescriptor;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdateContext;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import com.intellij.spring.boot.run.update.TriggerFilePolicy;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UpdateClassesAndTriggerFilePolicy
extends SpringBootApplicationUpdatePolicy
implements TriggerFilePolicy {
    private static final String ID = "UpdateClassesAndTriggerFile";
    private static final String NAME = "Hot swap classes and update trigger file if failed";
    private static final String DESCRIPTION = "<i>In debug mode:</i> <br>compiles all modified and dependent files, hot swaps classes, <br>updates trigger file if hot swap failed. <br><i>Otherwise:</i> <br>compiles all modified and dependent files and update trigger file. <br>Specifies trigger file name by adding VM option <code>-Dspring.devtools.restart.trigger-file=.restartTriggerFile</code>";

    public UpdateClassesAndTriggerFilePolicy() {
        super(ID, NAME, DESCRIPTION);
    }

    public boolean isAvailableOnFrameDeactivation() {
        return false;
    }

    public boolean isAvailableForConfiguration(@NotNull SpringBootApplicationRunConfigurationBase configuration) {
        if (configuration == null) {
            UpdateClassesAndTriggerFilePolicy.$$$reportNull$$$0(0);
        }
        return SpringBootLibraryUtil.hasDevtools((Module)configuration.getModule());
    }

    public void runUpdate(final @NotNull SpringBootApplicationUpdateContext context) {
        if (context == null) {
            UpdateClassesAndTriggerFilePolicy.$$$reportNull$$$0(1);
        }
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)context.getProject());
        context.getDescriptors().forEach(descriptor -> {
            DebugProcess process;
            if (context == null) {
                UpdateClassesAndTriggerFilePolicy.$$$reportNull$$$0(2);
            }
            final DebuggerSession session = (process = debuggerManager.getDebugProcess(descriptor.getProcessHandler())) != null ? debuggerManager.getSession(process) : null;
            ModuleCompileScope compileScope = new ModuleCompileScope(context.getProject(), new Module[]{descriptor.getModule()}, true);
            if (session != null) {
                HotSwapUI.getInstance((Project)context.getProject()).dontPerformHotswapAfterThisCompilation();
            }
            if (context.isOnFrameDeactivation()) {
                CompileDriver.setCompilationStartedAutomatically((CompileScope)compileScope);
            }
            CompileStatusNotification compilerCallback = new CompileStatusNotification((SpringBootApplicationDescriptor)descriptor){
                final /* synthetic */ SpringBootApplicationDescriptor val$descriptor;
                {
                    this.val$descriptor = springBootApplicationDescriptor;
                }

                public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                    if (compileContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!aborted && errors == 0 && !context.getProject().isDisposed()) {
                        if (session != null) {
                            HotSwapUI.getInstance((Project)context.getProject()).reloadChangedClasses(session, false, new HotSwapStatusListener(){

                                public void onFailure(List<DebuggerSession> sessions) {
                                    TriggerFilePolicy.updateTriggerFile(Collections.singleton(val$descriptor.getModule()));
                                }
                            });
                        } else {
                            TriggerFilePolicy.updateTriggerFile(Collections.singleton(this.val$descriptor.getModule()));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/spring/boot/run/update/UpdateClassesAndTriggerFilePolicy$1", "finished"));
                }
            };
            CompilerManager.getInstance((Project)context.getProject()).make((CompileScope)compileScope, compilerCallback);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/update/UpdateClassesAndTriggerFilePolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runUpdate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

