/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.model.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveBeanImpl;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveBeansModelImpl;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveContextImpl;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveResourceImpl;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class LiveBeansSnapshotParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveBeansSnapshotParser");
    private static final Bean[] EMPTY_BEANS = new Bean[0];

    @NotNull
    public LiveBeansModel parse(String snapshot) {
        LiveContextImpl liveContext;
        Gson gson = new GsonBuilder().create();
        Context[] contexts = (Context[])gson.fromJson(snapshot, Context[].class);
        LinkedHashMap<Context, LiveContextImpl> liveContexts = new LinkedHashMap<Context, LiveContextImpl>();
        HashMap<String, LiveContextImpl> liveContextsByName = new HashMap<String, LiveContextImpl>();
        HashMap contextLiveBeans = new HashMap();
        HashMap<String, LiveBeanImpl> allBeans = new HashMap<String, LiveBeanImpl>();
        for (Context context : contexts) {
            if (context.context == null) continue;
            liveContext = new LiveContextImpl(context.context);
            liveContexts.put(context, liveContext);
            liveContextsByName.putIfAbsent(context.context, liveContext);
            HashMap<String, LiveResourceImpl> liveResources = new HashMap<String, LiveResourceImpl>();
            HashMap<String, LiveBeanImpl> liveBeans = new HashMap<String, LiveBeanImpl>();
            contextLiveBeans.put(context, liveBeans);
            for (Bean bean : context.beans) {
                LiveResourceImpl liveResource;
                if (bean.bean == null) continue;
                String resource = bean.resource;
                if (resource == null) {
                    resource = "null";
                }
                if ((liveResource = (LiveResourceImpl)liveResources.get(resource)) == null) {
                    liveResource = new LiveResourceImpl(resource, liveContext);
                    liveResources.put(resource, liveResource);
                }
                LiveBeanImpl liveBean = LiveBeanImpl.createLiveBean(bean.bean, bean.scope, bean.type, liveResource);
                liveResource.addBean(liveBean);
                liveBeans.put(bean.bean, liveBean);
                allBeans.put(bean.bean, liveBean);
            }
            liveContext.addResources(liveResources.values());
        }
        for (Context context : contexts) {
            if (context.context == null) continue;
            if (context.parent != null) {
                liveContext = (LiveContextImpl)liveContexts.get(context);
                LOG.assertTrue(liveContext != null);
                liveContext.setParent((LiveContext)liveContextsByName.get(context.parent));
            }
            for (Bean bean : context.beans) {
                if (bean.bean == null) continue;
                Map liveBeans = (Map)contextLiveBeans.get(context);
                LOG.assertTrue(liveBeans != null);
                LiveBeanImpl liveBean = (LiveBeanImpl)liveBeans.get(bean.bean);
                LOG.assertTrue(liveBean != null);
                for (String dependency : bean.dependencies) {
                    if (dependency == null) continue;
                    LiveBeanImpl dependencyBean = (LiveBeanImpl)liveBeans.get(dependency);
                    if (dependencyBean == null && (dependencyBean = (LiveBeanImpl)allBeans.get(dependency)) == null) {
                        dependencyBean = LiveBeanImpl.createInnerBean(dependency);
                    }
                    liveBean.addDependency(dependencyBean);
                }
            }
        }
        LiveBeansModelImpl liveBeansModelImpl = new LiveBeansModelImpl(liveContexts.values());
        if (liveBeansModelImpl == null) {
            LiveBeansSnapshotParser.$$$reportNull$$$0(0);
        }
        return liveBeansModelImpl;
    }

    static /* synthetic */ Bean[] access$000() {
        return EMPTY_BEANS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveBeansSnapshotParser", "parse"));
    }

    private static class Bean {
        public String bean;
        public String scope;
        public String type;
        public String resource;
        public String[] dependencies = ArrayUtil.EMPTY_STRING_ARRAY;

        private Bean() {
        }
    }

    private static class Context {
        public String context;
        public String parent;
        public Bean[] beans = LiveBeansSnapshotParser.access$000();

        private Context() {
        }
    }
}

