/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.model.impl;

import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class LiveBeansModelImpl
implements LiveBeansModel {
    private final List<LiveContext> myContexts = ContainerUtil.newSmartList();
    private final Map<String, List<LiveBean>> myBeansByName;

    LiveBeansModelImpl(Collection<? extends LiveContext> contexts) {
        this.myContexts.addAll(contexts);
        this.myBeansByName = contexts.stream().flatMap(context -> context.getBeans().stream()).filter(bean -> !bean.isInnerBean()).collect(Collectors.groupingBy(LiveBean::getName, Collectors.toCollection(SmartList::new)));
    }

    @Override
    @NotNull
    public List<LiveContext> getContexts() {
        List contexts = ContainerUtil.newSmartList();
        contexts.addAll(this.myContexts);
        List list = contexts;
        if (list == null) {
            LiveBeansModelImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LiveResource> getResources() {
        List<LiveResource> list = this.myContexts.stream().flatMap(context -> context.getResources().stream()).collect(Collectors.toList());
        if (list == null) {
            LiveBeansModelImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LiveBean> getBeans() {
        List<LiveBean> list = this.myContexts.stream().flatMap(context -> context.getBeans().stream()).collect(Collectors.toList());
        if (list == null) {
            LiveBeansModelImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LiveBean> getBeansByName(String name) {
        List<LiveBean> beans = this.myBeansByName.get(name);
        List<LiveBean> list = beans != null ? Collections.unmodifiableList(beans) : Collections.emptyList();
        if (list == null) {
            LiveBeansModelImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveBeansModelImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeans";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeansByName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

