/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.boot.run.lifecycle.beans.gutter.LiveBeansNavigationHandler;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootRunIcons;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class LiveBeansClassLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public String getId() {
        return "LiveBeansClassLineMarkerProvider";
    }

    public String getName() {
        return "Runtime Beans";
    }

    public Icon getIcon() {
        return SpringBootRunIcons.Gutter.LiveBean;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        if (!LiveBeansNavigationHandler.hasLiveBeansModels(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UDeclaration elementToProcess;
        if (psiElement == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((elementToProcess = UAnnotationUtils.getIdentifierAnnotationOwner((PsiElement)psiElement)) instanceof UClass) {
            LiveBeansClassLineMarkerProvider.annotateAnno(psiElement, (UClass)elementToProcess, result);
        } else if (elementToProcess instanceof UMethod) {
            LiveBeansClassLineMarkerProvider.annotateMethod(psiElement, (UMethod)elementToProcess, result);
        } else {
            elementToProcess = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
            if (elementToProcess instanceof UClass) {
                LiveBeansClassLineMarkerProvider.annotateClass(psiElement, (UClass)elementToProcess, result);
            }
        }
    }

    private static void annotateAnno(@NotNull PsiElement nameIdentifier, @NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiClass psiClass;
        if (nameIdentifier == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (uClass == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)(psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)))) {
            return;
        }
        JamPsiMemberSpringBean springBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)psiClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass);
        if (!(springBean instanceof SpringStereotypeElement)) {
            return;
        }
        String beanName = springBean.getBeanName();
        if (beanName == null) {
            return;
        }
        SpringStereotypeElement stereotypeElement = (SpringStereotypeElement)springBean;
        PsiElement psiAnnotationIdentifier = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)stereotypeElement.getPsiAnnotation()));
        if (psiAnnotationIdentifier != nameIdentifier) {
            return;
        }
        LiveBeansClassLineMarkerProvider.annotateStereotype(nameIdentifier, beanName, psiClass, result);
    }

    private static void annotateStereotype(@NotNull PsiElement nameIdentifier, @NotNull String beanName, @NotNull PsiClass psiClass, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (nameIdentifier == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (beanName == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(9);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(10);
        }
        Predicate<LiveBean> beanMatcher = liveBean -> {
            LiveResource liveResource;
            if (psiClass == null) {
                LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(17);
            }
            if ((liveResource = liveBean.getResource()) == null) {
                return false;
            }
            if (liveResource.hasDescription() && !liveResource.matchesClass(psiClass, true)) {
                return false;
            }
            return liveBean.matches(psiClass);
        };
        LiveBeansNavigationHandler.addLiveBeansGutterIcon(beanName, beanMatcher, psiClass.getProject(), nameIdentifier, result);
    }

    private static void annotateMethod(@NotNull PsiElement nameIdentifier, @NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiMethod psiMethod;
        if (nameIdentifier == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(11);
        }
        if (uMethod == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(12);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(13);
        }
        if ((psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class)) == null) {
            return;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        if (psiMethod.isConstructor()) {
            return;
        }
        ContextJavaBean contextJavaBean = (ContextJavaBean)JamService.getJamService((Project)psiMethod.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)psiMethod);
        if (contextJavaBean == null) {
            return;
        }
        String beanName = contextJavaBean.getBeanName();
        if (beanName == null) {
            return;
        }
        PsiElement psiAnnotationIdentifier = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)contextJavaBean.getPsiAnnotation()));
        if (psiAnnotationIdentifier != nameIdentifier) {
            return;
        }
        Predicate<LiveBean> beanMatcher = liveBean -> {
            LiveResource liveResource = liveBean.getResource();
            return liveResource != null && liveResource.matchesClass(psiClass, false);
        };
        LiveBeansNavigationHandler.addLiveBeansGutterIcon(beanName, beanMatcher, psiMethod.getProject(), nameIdentifier, result);
    }

    private static void annotateClass(@NotNull PsiElement nameIdentifier, @NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiClass psiClass;
        if (nameIdentifier == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(14);
        }
        if (uClass == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(15);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(16);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)(psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)))) {
            return;
        }
        JamPsiMemberSpringBean springBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)psiClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass);
        if (springBean instanceof SpringStereotypeElement) {
            return;
        }
        SpringStereotypeElement stereotypeElement = SpringJamUtils.getInstance().findStereotypeElement(psiClass);
        if (stereotypeElement == null || !stereotypeElement.isValid()) {
            return;
        }
        String beanName = stereotypeElement.getBeanName();
        if (beanName == null) {
            return;
        }
        LiveBeansClassLineMarkerProvider.annotateStereotype(nameIdentifier, beanName, psiClass, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansClassLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateAnno";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateStereotype";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMethod";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateClass";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$annotateStereotype$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

