/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ShortenCommandLineModeCombo;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentSettingsPanel
implements PanelWithAnchor {
    private JPanel myRootPanel;
    private CommonJavaParametersPanel myCommonProgramParameters;
    private LabeledComponent<ModuleDescriptionsComboBox> myModule;
    private LabeledComponent<JBCheckBox> myIncludeProvidedCheckbox;
    private JrePathEditor myJrePathEditor;
    private LabeledComponent<ShortenCommandLineModeCombo> myShortenCommandLineModeCombo;
    private final ConfigurationModuleSelector myModuleSelector;
    private JComponent myAnchor;

    EnvironmentSettingsPanel(final Project project, final EditorTextFieldWithBrowseButton mainClassField) {
        this.$$$setupUI$$$();
        this.myModuleSelector = new ConfigurationModuleSelector(project, (ModuleDescriptionsComboBox)this.myModule.getComponent()){

            public boolean isModuleAccepted(Module module) {
                return SpringBootLibraryUtil.hasSpringBootLibrary((Module)module);
            }
        };
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromSourceRootsDependencies((ModuleDescriptionsComboBox)((ModuleDescriptionsComboBox)this.myModule.getComponent()), (EditorTextFieldWithBrowseButton)mainClassField));
        this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule());
        this.addModuleChangeListener(arg_0 -> ((CommonJavaParametersPanel)this.myCommonProgramParameters).setModuleContext(arg_0));
        this.myIncludeProvidedCheckbox.setComponent((JComponent)new JBCheckBox(ExecutionBundle.message((String)"application.configuration.include.provided.scope", (Object[])new Object[0])));
        this.myShortenCommandLineModeCombo.setComponent((JComponent)new ShortenCommandLineModeCombo(project, this.myJrePathEditor, (ModuleDescriptionsComboBox)this.myModule.getComponent()));
        ((EditorTextField)mainClassField.getChildComponent()).addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DumbService.getInstance((Project)project).isDumb()) {
                    return;
                }
                String mainClass = mainClassField.getText();
                if (EnvironmentSettingsPanel.this.myModuleSelector.getModule() != null && EnvironmentSettingsPanel.this.myModuleSelector.findClass(mainClass) != null) {
                    return;
                }
                JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(project, false);
                PsiClass psiClass = configurationModule.findClass(mainClass);
                if (psiClass == null) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                if (module != null && EnvironmentSettingsPanel.this.myModuleSelector.isModuleAccepted(module)) {
                    ((ModuleDescriptionsComboBox)EnvironmentSettingsPanel.this.myModule.getComponent()).setSelectedModule(module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/run/editor/EnvironmentSettingsPanel$2", "documentChanged"));
            }
        });
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonProgramParameters, this.myJrePathEditor, this.myModule, this.myIncludeProvidedCheckbox, this.myShortenCommandLineModeCombo});
    }

    void resetEditorFrom(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            EnvironmentSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myCommonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        this.myModuleSelector.reset((ModuleBasedConfiguration)configuration);
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        ((JBCheckBox)this.myIncludeProvidedCheckbox.getComponent()).setSelected(configuration.isIncludeProvidedScope());
        ((ShortenCommandLineModeCombo)this.myShortenCommandLineModeCombo.getComponent()).setSelectedItem((Object)configuration.getShortenCommandLine());
    }

    void applyEditorTo(@NotNull SpringBootApplicationRunConfiguration configuration) {
        if (configuration == null) {
            EnvironmentSettingsPanel.$$$reportNull$$$0(1);
        }
        this.myCommonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        this.myModuleSelector.applyTo((ModuleBasedConfiguration)configuration);
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        configuration.setIncludeProvidedScope(((JBCheckBox)this.myIncludeProvidedCheckbox.getComponent()).isSelected());
        configuration.setShortenCommandLine(((ShortenCommandLineModeCombo)this.myShortenCommandLineModeCombo.getComponent()).getSelectedItem());
    }

    ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    void addModuleChangeListener(final @NotNull ModuleChangeListener listener) {
        if (listener == null) {
            EnvironmentSettingsPanel.$$$reportNull$$$0(2);
        }
        ((ModuleDescriptionsComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.moduleChanged(EnvironmentSettingsPanel.this.myModuleSelector.getModule());
            }
        });
    }

    JPanel getComponent() {
        return this.myRootPanel;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myModule.setAnchor(anchor);
        this.myIncludeProvidedCheckbox.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.myShortenCommandLineModeCombo.setAnchor(anchor);
    }

    private void createUIComponents() {
        this.myShortenCommandLineModeCombo = new LabeledComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/editor/EnvironmentSettingsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addModuleChangeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JrePathEditor jrePathEditor;
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)commonJavaParametersPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.myModule = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.application.options.ModuleDescriptionsComboBox");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myIncludeProvidedCheckbox = labeledComponent = new LabeledComponent();
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("");
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<ShortenCommandLineModeCombo> labeledComponent3 = this.myShortenCommandLineModeCombo;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.shorten.command.line.label"));
        jPanel.add((Component)labeledComponent3, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    static interface ModuleChangeListener {
        public void moduleChanged(Module var1);
    }
}

