/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootApplicationUrlPathProviderFactory;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationUrlUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationUrlPathConfigurable
extends DialogWrapper {
    private JPanel myRootPanel;
    private JPanel myFieldPanel;
    private TextFieldWithCompletion myPathField;
    @NotNull
    private final Project myProject;
    @NotNull
    private final SpringBootApplicationRunConfigurationBase myRunConfiguration;
    @NotNull
    private final SpringBootApplicationInfo myInfo;

    public SpringBootApplicationUrlPathConfigurable(@NotNull Project project, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull SpringBootApplicationInfo info) {
        if (project == null) {
            SpringBootApplicationUrlPathConfigurable.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            SpringBootApplicationUrlPathConfigurable.$$$reportNull$$$0(1);
        }
        if (info == null) {
            SpringBootApplicationUrlPathConfigurable.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myInfo = info;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(SpringBootRunBundle.message("spring.boot.application.url.path.dialog.title", new Object[0]));
    }

    private void createUIComponents() {
        TextFieldWithAutoCompletionListProvider provider;
        this.myFieldPanel = new JPanel(new BorderLayout());
        this.myFieldPanel.setPreferredSize((Dimension)new JBDimension(300, -1));
        String text = this.myRunConfiguration.getUrlPath();
        if (text == null) {
            text = "";
        }
        if ((provider = (TextFieldWithAutoCompletionListProvider)Arrays.stream(SpringBootApplicationUrlPathProviderFactory.EP_NAME.getExtensions()).findFirst().map(factory -> factory.createCompletionProvider(this.myInfo)).orElse(null)) == null) {
            provider = new TextFieldWithAutoCompletionListProvider<String>(Collections.emptyList()){

                @NotNull
                protected String getLookupString(@NotNull String item) {
                    if (item == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = item;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "item";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/spring/boot/run/SpringBootApplicationUrlPathConfigurable$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationUrlPathConfigurable$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getLookupString";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getLookupString";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        this.myPathField = new TextFieldWithAutoCompletion(this.myProject, provider, true, text);
        this.myFieldPanel.add((Component)this.myPathField, "Center");
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPathField;
    }

    protected void doOKAction() {
        SpringBootApplicationUrlUtil.getInstance().updatePath(this.myProject, this.myRunConfiguration, this.myPathField.getText());
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/run/SpringBootApplicationUrlPathConfigurable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/SpringBootRunBundle").getString("spring.boot.application.url.path.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = this.myFieldPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

