/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class OgnlBlock
implements ASTBlock {
    private final ASTNode astNode;
    private final SpacingBuilder spacingBuilder;
    private List<Block> blocks;

    OgnlBlock(ASTNode astNode, SpacingBuilder spacingBuilder) {
        this.astNode = astNode;
        this.spacingBuilder = spacingBuilder;
    }

    public ASTNode getNode() {
        return this.astNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.astNode.getTextRange();
        if (textRange == null) {
            OgnlBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.blocks == null) {
            this.blocks = this.buildSubBlocks();
        }
        ArrayList<Block> arrayList = new ArrayList<Block>(this.blocks);
        if (arrayList == null) {
            OgnlBlock.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private List<Block> buildSubBlocks() {
        ArrayList<OgnlBlock> myBlocks = new ArrayList<OgnlBlock>();
        for (ASTNode child = this.astNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getTextRange().getLength() == 0 || child.getElementType() == TokenType.WHITE_SPACE) continue;
            myBlocks.add(new OgnlBlock(child, this.spacingBuilder));
        }
        return Collections.unmodifiableList(myBlocks);
    }

    public Wrap getWrap() {
        return null;
    }

    public Indent getIndent() {
        return Indent.getNoneIndent();
    }

    public Alignment getAlignment() {
        return null;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            OgnlBlock.$$$reportNull$$$0(2);
        }
        return this.spacingBuilder.getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            OgnlBlock.$$$reportNull$$$0(3);
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return this.astNode.getFirstChildNode() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ognl/formatting/OgnlBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ognl/formatting/OgnlBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

