/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.providers;

import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.jboss.jpdl.utils.JpdlCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiTarget;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProcessNamesReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            ProcessNamesReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ProcessNamesReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module != null && literalExpression.getValue() instanceof String) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new JpdlProcessPsiReference(literalExpression, module)};
                if (psiReferenceArray == null) {
                    ProcessNamesReferenceProvider.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            ProcessNamesReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jboss/jpdl/providers/ProcessNamesReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jboss/jpdl/providers/ProcessNamesReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JpdlProcessPsiReference
    extends PsiReferenceBase<PsiLiteralExpression> {
        private final Module myModule;

        JpdlProcessPsiReference(PsiLiteralExpression literalExpression, Module module) {
            super((PsiElement)literalExpression, false);
            this.myModule = module;
        }

        public boolean isSoft() {
            return false;
        }

        public PsiElement resolve() {
            String value = this.getValue();
            for (ProcessDefinition definition : JpdlCommonUtils.getProcessDefinitions(this.myModule)) {
                if (!value.equals(definition.getName().getStringValue())) continue;
                return PomService.convertToPsi((PsiTarget)DomTarget.getTarget((DomElement)definition));
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            List<String> names = JpdlCommonUtils.getProcessNames(this.myModule);
            Object[] objectArray = names.toArray();
            if (objectArray == null) {
                JpdlProcessPsiReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/providers/ProcessNamesReferenceProvider$JpdlProcessPsiReference", "getVariants"));
        }
    }
}

