/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.graph;

import com.intellij.jboss.jpdl.graph.JpdlEdge;
import com.intellij.jboss.jpdl.graph.JpdlNode;
import com.intellij.jboss.jpdl.graph.renderers.DefaultJpdlNodeRenderer;
import com.intellij.jboss.jpdl.model.xml.JpdlNamedActivity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.SimpleNodeCellEditor;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.renderer.BasicGraphNodeRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.OrientationLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.JBColor;
import com.intellij.util.OpenSourceUtil;
import java.awt.Color;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class JpdlPresentationModel
extends BasicGraphPresentationModel<JpdlNode, JpdlEdge> {
    private final Project myProject;
    private BasicGraphNodeRenderer myRenderer;

    public JpdlPresentationModel(Graph2D graph, Project project) {
        super((Graph)graph);
        this.myProject = project;
        this.setShowEdgeLabels(true);
        JpdlPresentationModel.customizeDefaultSettings(this.getSettings());
    }

    private static void customizeDefaultSettings(GraphSettings settings) {
        HierarchicGroupLayouter groupLayouter = settings.getGroupLayouter();
        groupLayouter.setOrientationLayouter((LayoutStage)GraphManager.getGraphManager().createOrientationLayouter(OrientationLayouter.TOP_TO_BOTTOM));
        groupLayouter.setMinimalNodeDistance(20.0);
        groupLayouter.setMinimalLayerDistance(50.0);
        groupLayouter.setRoutingStyle(HierarchicLayouter.ROUTE_POLYLINE);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(JpdlNode node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"JpdlNodeRenderer", (NodeCellRenderer)this.getRenderer());
        if (nodeRealizer == null) {
            JpdlPresentationModel.$$$reportNull$$$0(0);
        }
        return nodeRealizer;
    }

    public BasicGraphNodeRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new DefaultJpdlNodeRenderer((GraphBuilder<JpdlNode, JpdlEdge>)this.getGraphBuilder());
        }
        return this.myRenderer;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(JpdlEdge edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        edgeRealizer.setLineType(LineType.LINE_1);
        edgeRealizer.setLineColor((Color)JBColor.GRAY);
        edgeRealizer.setArrow(Arrow.STANDARD);
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            JpdlPresentationModel.$$$reportNull$$$0(1);
        }
        return polyLineEdgeRealizer;
    }

    public boolean editNode(JpdlNode node) {
        return super.editNode((Object)node);
    }

    public boolean editEdge(JpdlEdge jpdlEdge) {
        XmlElement xmlElement = jpdlEdge.getIdentifyingElement().getXmlElement();
        if (xmlElement instanceof Navigatable) {
            OpenSourceUtil.navigate((boolean)true, (Navigatable[])new Navigatable[]{(Navigatable)xmlElement});
            return true;
        }
        return super.editEdge((Object)jpdlEdge);
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getNodeTooltip(JpdlNode node) {
        XmlElement xmlElement = node.getIdentifyingElement().getXmlElement();
        if (xmlElement != null) {
            return xmlElement.getText();
        }
        return node.getName();
    }

    public String getEdgeTooltip(JpdlEdge edge) {
        XmlElement xmlElement = edge.getIdentifyingElement().getXmlElement();
        if (xmlElement != null) {
            return xmlElement.getText();
        }
        return edge.getName();
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        editMode.allowEdgeCreation(true);
        editMode.allowBendCreation(false);
        view.setFitContentOnResize(false);
        view.fitContent();
    }

    public DeleteProvider getDeleteProvider() {
        return new DeleteProvider<JpdlNode, JpdlEdge>(){

            public boolean canDeleteNode(@NotNull JpdlNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !((CellEditorMode)JpdlPresentationModel.this.getGraphBuilder().getEditMode().getEditNodeMode()).isCellEditing();
            }

            public boolean canDeleteEdge(@NotNull JpdlEdge edge) {
                if (edge == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean deleteNode(@NotNull JpdlNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                WriteCommandAction.writeCommandAction((Project)JpdlPresentationModel.this.getProject()).run(() -> {
                    if (node == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    node.getIdentifyingElement().undefine();
                });
                return true;
            }

            public boolean deleteEdge(@NotNull JpdlEdge edge) {
                if (edge == null) {
                    1.$$$reportNull$$$0(3);
                }
                WriteCommandAction.writeCommandAction((Project)JpdlPresentationModel.this.getProject()).run(() -> {
                    if (edge == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    edge.getIdentifyingElement().undefine();
                });
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "edge";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/jboss/jpdl/graph/JpdlPresentationModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canDeleteNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canDeleteEdge";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deleteNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deleteEdge";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$deleteEdge$1";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$deleteNode$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public NodeCellEditor getCustomNodeCellEditor(JpdlNode jpdlNode) {
        return new SimpleNodeCellEditor<JpdlNode>(jpdlNode, this.getProject()){

            protected String getEditorValue(JpdlNode value) {
                String s = value.getName();
                return s == null ? "" : s;
            }

            protected void setEditorValue(JpdlNode value, String newValue) {
                Object element = value.getIdentifyingElement();
                if (element instanceof JpdlNamedActivity) {
                    WriteCommandAction.writeCommandAction((Project)JpdlPresentationModel.this.myProject).run(() -> ((JpdlNamedActivity)element).getName().setStringValue(newValue));
                }
                IdeFocusManager.getInstance((Project)JpdlPresentationModel.this.getProject()).requestFocus((Component)JpdlPresentationModel.this.getGraphBuilder().getView().getJComponent(), true);
            }
        };
    }

    public DefaultActionGroup getNodeActionGroup(JpdlNode jpdlNode) {
        DefaultActionGroup group = super.getNodeActionGroup((Object)jpdlNode);
        group.add(ActionManager.getInstance().getAction("Jpdl.Designer"), Constraints.FIRST);
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jboss/jpdl/graph/JpdlPresentationModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

