/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.graph;

import com.intellij.jboss.jpdl.graph.JpdlEdge;
import com.intellij.jboss.jpdl.graph.JpdlNode;
import com.intellij.jboss.jpdl.graph.nodes.CustomNode;
import com.intellij.jboss.jpdl.graph.nodes.DecisionNode;
import com.intellij.jboss.jpdl.graph.nodes.EndActivityNode;
import com.intellij.jboss.jpdl.graph.nodes.ForkNode;
import com.intellij.jboss.jpdl.graph.nodes.GroupNode;
import com.intellij.jboss.jpdl.graph.nodes.HqlNode;
import com.intellij.jboss.jpdl.graph.nodes.JavaNode;
import com.intellij.jboss.jpdl.graph.nodes.JoinNode;
import com.intellij.jboss.jpdl.graph.nodes.JpdlBasicEdge;
import com.intellij.jboss.jpdl.graph.nodes.MailNode;
import com.intellij.jboss.jpdl.graph.nodes.RulesDecisionNode;
import com.intellij.jboss.jpdl.graph.nodes.RulesNode;
import com.intellij.jboss.jpdl.graph.nodes.ScriptNode;
import com.intellij.jboss.jpdl.graph.nodes.SqlNode;
import com.intellij.jboss.jpdl.graph.nodes.StartNode;
import com.intellij.jboss.jpdl.graph.nodes.StateNode;
import com.intellij.jboss.jpdl.graph.nodes.SubProcessNode;
import com.intellij.jboss.jpdl.graph.nodes.TaskNode;
import com.intellij.jboss.jpdl.model.JpdlDomModelManager;
import com.intellij.jboss.jpdl.model.JpdlModel;
import com.intellij.jboss.jpdl.model.xml.Custom;
import com.intellij.jboss.jpdl.model.xml.Decision;
import com.intellij.jboss.jpdl.model.xml.End;
import com.intellij.jboss.jpdl.model.xml.EndCancel;
import com.intellij.jboss.jpdl.model.xml.EndError;
import com.intellij.jboss.jpdl.model.xml.Fork;
import com.intellij.jboss.jpdl.model.xml.Group;
import com.intellij.jboss.jpdl.model.xml.Hql;
import com.intellij.jboss.jpdl.model.xml.Join;
import com.intellij.jboss.jpdl.model.xml.JpdlNamedActivity;
import com.intellij.jboss.jpdl.model.xml.Mail;
import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.jboss.jpdl.model.xml.Rules;
import com.intellij.jboss.jpdl.model.xml.RulesDecision;
import com.intellij.jboss.jpdl.model.xml.Script;
import com.intellij.jboss.jpdl.model.xml.Sql;
import com.intellij.jboss.jpdl.model.xml.Start;
import com.intellij.jboss.jpdl.model.xml.State;
import com.intellij.jboss.jpdl.model.xml.SubProcess;
import com.intellij.jboss.jpdl.model.xml.Task;
import com.intellij.jboss.jpdl.model.xml.Transition;
import com.intellij.jboss.jpdl.model.xml.TransitionOwner;
import com.intellij.jboss.jpdl.model.xml.wireObjectGroup.JavaActivity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpdlDataModel
extends GraphDataModel<JpdlNode, JpdlEdge> {
    private final Collection<JpdlNode> myNodes = new HashSet<JpdlNode>();
    private final Collection<JpdlEdge> myEdges = new HashSet<JpdlEdge>();
    protected final Map<PsiFile, NodesGroup> myGroups = new HashMap<PsiFile, NodesGroup>();
    private final Project myProject;
    private final XmlFile myFile;
    @NonNls
    private static final String UNDEFINED_NAME = "Undefined";

    public JpdlDataModel(XmlFile file) {
        this.myFile = file;
        this.myProject = file.getProject();
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<JpdlNode> getNodes() {
        Collection<JpdlNode> collection = this.getNodes(true);
        if (collection == null) {
            JpdlDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<JpdlNode> getNodes(boolean refresh) {
        if (refresh) {
            this.refreshDataModel();
        }
        Collection<JpdlNode> collection = this.myNodes;
        if (collection == null) {
            JpdlDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<JpdlEdge> getEdges() {
        Collection<JpdlEdge> collection = this.myEdges;
        if (collection == null) {
            JpdlDataModel.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public JpdlNode getSourceNode(JpdlEdge jpdlBasicEdge) {
        JpdlNode jpdlNode = jpdlBasicEdge.getSource();
        if (jpdlNode == null) {
            JpdlDataModel.$$$reportNull$$$0(3);
        }
        return jpdlNode;
    }

    @NotNull
    public JpdlNode getTargetNode(JpdlEdge jpdlBasicEdge) {
        JpdlNode jpdlNode = jpdlBasicEdge.getTarget();
        if (jpdlNode == null) {
            JpdlDataModel.$$$reportNull$$$0(4);
        }
        return jpdlNode;
    }

    @NotNull
    public String getNodeName(JpdlNode jpdlBasicNode) {
        if ("" == null) {
            JpdlDataModel.$$$reportNull$$$0(5);
        }
        return "";
    }

    @NotNull
    public String getEdgeName(JpdlEdge jpdlBasicEdge) {
        String string = jpdlBasicEdge.getName();
        if (string == null) {
            JpdlDataModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public JpdlEdge createEdge(@NotNull JpdlNode from, @NotNull JpdlNode to) {
        if (from == null) {
            JpdlDataModel.$$$reportNull$$$0(7);
        }
        if (to == null) {
            JpdlDataModel.$$$reportNull$$$0(8);
        }
        String toName = to.getName();
        Object element = from.getIdentifyingElement();
        if (element instanceof TransitionOwner) {
            return (JpdlEdge)WriteCommandAction.writeCommandAction((Project)this.myProject).compute(() -> {
                if (from == null) {
                    JpdlDataModel.$$$reportNull$$$0(9);
                }
                if (to == null) {
                    JpdlDataModel.$$$reportNull$$$0(10);
                }
                Transition transition = ((TransitionOwner)element).addTransition();
                transition.getTo().setStringValue(toName);
                return new JpdlBasicEdge(from, to, (Transition)transition.createStableCopy(), false);
            });
        }
        return null;
    }

    public void dispose() {
    }

    private void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public void updateDataModel() {
        ProcessDefinition processDefinition = this.getProcessDefinition();
        if (processDefinition == null) {
            return;
        }
        HashMap<String, List<JpdlNode>> allNodes = new HashMap<String, List<JpdlNode>>();
        this.addActivityNodes(processDefinition.getStarts(), start -> new StartNode((Start)start), allNodes);
        this.addActivityNodes(processDefinition.getStates(), state -> new StateNode((State)state), allNodes);
        this.addActivityNodes(processDefinition.getDecisions(), decision -> new DecisionNode((Decision)decision), allNodes);
        this.addActivityNodes(processDefinition.getTasks(), task -> new TaskNode((Task)task), allNodes);
        this.addActivityNodes(processDefinition.getForks(), fork -> new ForkNode((Fork)fork), allNodes);
        this.addActivityNodes(processDefinition.getJoins(), join -> new JoinNode((Join)join), allNodes);
        this.addActivityNodes(processDefinition.getEnds(), end -> new EndActivityNode.EndNode((End)end), allNodes);
        this.addActivityNodes(processDefinition.getEndCancels(), end -> new EndActivityNode.EndCancelNode((EndCancel)end), allNodes);
        this.addActivityNodes(processDefinition.getEndErrors(), endError -> new EndActivityNode.EndErrorNode((EndError)endError), allNodes);
        this.addActivityNodes(processDefinition.getSubProcesses(), subProcess -> new SubProcessNode((SubProcess)subProcess), allNodes);
        this.addActivityNodes(processDefinition.getJavas(), javaActivity -> new JavaNode((JavaActivity)javaActivity), allNodes);
        this.addActivityNodes(processDefinition.getCustoms(), custom -> new CustomNode((Custom)custom), allNodes);
        this.addActivityNodes(processDefinition.getSqls(), sql -> new SqlNode((Sql)sql), allNodes);
        this.addActivityNodes(processDefinition.getHqls(), hql -> new HqlNode((Hql)hql), allNodes);
        this.addActivityNodes(processDefinition.getRules(), rules -> new RulesNode((Rules)rules), allNodes);
        this.addActivityNodes(processDefinition.getRulesDecisions(), rulesDecision -> new RulesDecisionNode((RulesDecision)rulesDecision), allNodes);
        this.addActivityNodes(processDefinition.getScripts(), script -> new ScriptNode((Script)script), allNodes);
        this.addActivityNodes(processDefinition.getMails(), mail -> new MailNode((Mail)mail), allNodes);
        this.addActivityNodes(processDefinition.getGroups(), group -> new GroupNode((Group)group), allNodes);
        for (List sourceNodes : allNodes.values()) {
            for (JpdlNode sourceNode : sourceNodes) {
                Object identifyingElement = sourceNode.getIdentifyingElement();
                if (!(identifyingElement instanceof TransitionOwner)) continue;
                List<Transition> transitions = ((TransitionOwner)identifyingElement).getTransitions();
                this.addTransitions(sourceNode, transitions, allNodes);
            }
        }
    }

    private void addTransitions(JpdlNode sourceNode, List<Transition> transitions, Map<String, List<JpdlNode>> allNodes) {
        for (Transition transition : transitions) {
            List<JpdlNode> targetNodes;
            String targetNodeName = transition.getTo().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)targetNodeName) || (targetNodes = allNodes.get(targetNodeName)) == null) continue;
            for (JpdlNode targetNode : targetNodes) {
                this.addTransition(new JpdlBasicEdge(sourceNode, targetNode, (Transition)transition.createStableCopy(), targetNodes.size() > 1));
            }
        }
    }

    private void addNode(JpdlNode node) {
        this.myNodes.add(node);
    }

    private void addTransition(JpdlEdge edge) {
        this.myEdges.add(edge);
    }

    private <jpdlNode extends JpdlNode, jpdlActivity extends JpdlNamedActivity> void addActivityNodes(List<jpdlActivity> activities, Function<jpdlActivity, jpdlNode> function, Map<String, List<JpdlNode>> nodes) {
        for (JpdlNamedActivity activity : activities) {
            if (!DomUtil.hasXml((DomElement)activity)) continue;
            String name = activity.getName().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                name = UNDEFINED_NAME;
            }
            if (!nodes.containsKey(name)) {
                nodes.put(name, new ArrayList());
            }
            JpdlNode node = (JpdlNode)function.fun((Object)activity.createStableCopy());
            nodes.get(name).add(node);
            this.addNode(node);
        }
    }

    @Nullable
    public ProcessDefinition getProcessDefinition() {
        JpdlModel model = this.getModel();
        if (model == null || model.getRoots().size() != 1) {
            return null;
        }
        return (ProcessDefinition)((DomFileElement)model.getRoots().get(0)).getRootElement();
    }

    public JpdlModel getModel() {
        return JpdlDomModelManager.getInstance(this.myProject).getJpdlModel(this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jboss/jpdl/graph/JpdlDataModel";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jboss/jpdl/graph/JpdlDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createEdge$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

