/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram.managers;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.jboss.jbpm.diagram.BpmnDiagramPresentationConstants;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.Bpmn20DomElementWrapper;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnDefinitionsWrapper;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnModuleWrapper;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnUnknownNodeElementWrapper;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.BpmnDomModelManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnDiagramElementManager
extends AbstractDiagramElementManager<BpmnElementWrapper> {
    public BpmnElementWrapper findInDataContext(DataContext context) {
        List<BpmnDomModel> models;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (psiFile instanceof XmlFile && !(psiFile instanceof JspFile) && BpmnDomModelManager.getInstance(psiFile.getProject()).isBpmnDomModel((XmlFile)psiFile)) {
            return new BpmnDefinitionsWrapper((XmlFile)psiFile);
        }
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        if (module != null && !DumbService.isDumb((Project)module.getProject()) && !(models = BpmnDomModelManager.getInstance(module.getProject()).getAllModels(module)).isEmpty()) {
            return new BpmnModuleWrapper(module);
        }
        return null;
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof BpmnElementWrapper;
    }

    public String getElementTitle(BpmnElementWrapper element) {
        return element.isValid() ? element.getName() : "<invalid>";
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof Bpmn20DomElementWrapper) {
            Bpmn20DomElementWrapper wrapper = (Bpmn20DomElementWrapper)element;
            if (!wrapper.isValid()) {
                return BpmnDiagramPresentationConstants.INVALID_SIMPLE_COLORED_TEXT;
            }
            SimpleColoredText customText = BpmnDiagramElementManager.createCustomNodePresentableName(wrapper);
            if (customText != null) {
                return customText;
            }
            boolean isStartAction = wrapper.getUserData(Bpmn20DomElementWrapper.IS_START_STATE) == Boolean.TRUE;
            return new SimpleColoredText(wrapper.getName(), isStartAction ? SimpleTextAttributes.LINK_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        if (element instanceof DomElement) {
            DomElement domElement = (DomElement)element;
            String name = BpmnDiagramElementManager.getDomElementPresentableName(domElement);
            return new SimpleColoredText(name, DEFAULT_TEXT_ATTR);
        }
        if (element instanceof SimpleColoredText) {
            return (SimpleColoredText)element;
        }
        if (element instanceof BpmnUnknownNodeElementWrapper) {
            return new SimpleColoredText(((BpmnUnknownNodeElementWrapper)element).getName(), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        return new SimpleColoredText("???" + element + "???", SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    @Nullable
    private static SimpleColoredText createCustomNodePresentableName(Bpmn20DomElementWrapper wrapper) {
        DomElement domElement = (DomElement)wrapper.getElement();
        return null;
    }

    @NotNull
    private static String getDomElementPresentableName(DomElement domElement) {
        if (!domElement.isValid()) {
            if ("<invalid>" == null) {
                BpmnDiagramElementManager.$$$reportNull$$$0(0);
            }
            return "<invalid>";
        }
        String presentationName = domElement.getPresentation().getElementName();
        if (presentationName != null) {
            String string = presentationName;
            if (string == null) {
                BpmnDiagramElementManager.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = "<<unknown>>" + domElement.getClass();
        if (string == null) {
            BpmnDiagramElementManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String getAssignmentPresentableName(GenericAttributeValue name, GenericDomValue value) {
        return name.getStringValue() + BpmnDiagramPresentationConstants.LABEL_ASSIGNMENT_OPERATOR + value.getStringValue();
    }

    public String getNodeTooltip(BpmnElementWrapper element) {
        Object o = element.getElement();
        if (o instanceof DomElement) {
            DomElement domElement = (DomElement)o;
            if (!domElement.isValid()) {
                return "<invalid>";
            }
            return domElement.getPresentation().getTypeName();
        }
        return element.getName();
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        if (element instanceof SimpleColoredText) {
            return EmptyIcon.ICON_0;
        }
        if (element instanceof DomElement) {
            DomElement domElement = (DomElement)element;
            if (!domElement.isValid()) {
                return PlatformIcons.ERROR_INTRODUCTION_ICON;
            }
            Icon icon = domElement.getPresentation().getIcon();
            return icon != null ? icon : EmptyIcon.ICON_16;
        }
        return super.getItemIcon(element, presentation);
    }

    public SimpleColoredText getItemType(Object element) {
        if (element instanceof DomElement && !((DomElement)element).isValid()) {
            return BpmnDiagramPresentationConstants.INVALID_SIMPLE_COLORED_TEXT;
        }
        return super.getItemType(element);
    }

    public String getEditorTitle(BpmnElementWrapper element, DiagramState presentation, Collection<BpmnElementWrapper> additionalElements) {
        return element.getName();
    }

    @Nullable
    private static SimpleColoredText createPsiClassPresentableType(GenericAttributeValue<PsiClass> clazzAttribute) {
        PsiClass value = (PsiClass)clazzAttribute.getValue();
        if (value == null) {
            return null;
        }
        return new SimpleColoredText(value.getName(), DEFAULT_TEXT_ATTR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/managers/BpmnDiagramElementManager", "getDomElementPresentableName"));
    }
}

