/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.agent;

import com.intellij.javaee.oss.geronimo.agent.GeronimoAgentBase;
import java.io.IOException;
import java.util.Set;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.management.ObjectName;
import org.apache.geronimo.deployment.plugin.factories.DeploymentFactoryImpl;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.jmx.KernelDelegate;

public class Geronimo10Agent
extends GeronimoAgentBase {
    private Kernel myKernel;

    protected boolean connectKernel() {
        try {
            return this.getKernel().isRunning() && Geronimo10Agent.isStarted(this.getKernel());
        }
        catch (Exception e) {
            this.getLog().debugEx(e);
            return false;
        }
    }

    private Kernel getKernel() throws IOException {
        if (this.myKernel == null) {
            this.myKernel = new KernelDelegate(this.createConnection());
        }
        return this.myKernel;
    }

    private static boolean isStarted(Kernel k) throws Exception {
        Set configs = k.listGBeans(new GBeanQuery(null, PersistentConfigurationList.class.getName()));
        return !configs.isEmpty() && Boolean.TRUE.equals(k.getAttribute((ObjectName)configs.iterator().next(), "kernelFullyStarted"));
    }

    protected DeploymentFactory getDeploymentFactory() {
        return new DeploymentFactoryImpl();
    }

    protected boolean matches(TargetModuleID module, String name) {
        return module.getModuleID().equals(name);
    }
}

