/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.model.impl;

import com.intellij.openapi.util.JDOMExternalizerUtil;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.devkit.model.JpsIdeaSdkProperties;
import org.jetbrains.jps.devkit.model.JpsIdeaSdkType;
import org.jetbrains.jps.devkit.model.JpsPluginModuleProperties;
import org.jetbrains.jps.devkit.model.JpsPluginModuleType;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;

public class JpsDevKitModelSerializerExtension
extends JpsModelSerializerExtension {
    @NotNull
    public List<? extends JpsModulePropertiesSerializer<?>> getModulePropertiesSerializers() {
        List<JpsPluginModulePropertiesSerializer> list = Arrays.asList(new JpsPluginModulePropertiesSerializer());
        if (list == null) {
            JpsDevKitModelSerializerExtension.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsSdkPropertiesSerializer<?>> getSdkPropertiesSerializers() {
        List<JpsIdeaSdkPropertiesSerializer> list = Arrays.asList(new JpsIdeaSdkPropertiesSerializer());
        if (list == null) {
            JpsDevKitModelSerializerExtension.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePropertiesSerializers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPropertiesSerializers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class JpsPluginModulePropertiesSerializer
    extends JpsModulePropertiesSerializer<JpsSimpleElement<JpsPluginModuleProperties>> {
        private static final String URL_ATTRIBUTE = "url";
        private static final String MANIFEST_ATTRIBUTE = "manifest";

        private JpsPluginModulePropertiesSerializer() {
            super((JpsModuleType)JpsPluginModuleType.INSTANCE, "PLUGIN_MODULE", "DevKit.ModuleBuildProperties");
        }

        public JpsSimpleElement<JpsPluginModuleProperties> loadProperties(@Nullable Element componentElement) {
            String pluginXmlUrl = componentElement != null ? componentElement.getAttributeValue(URL_ATTRIBUTE) : null;
            String manifestFileUrl = componentElement != null ? componentElement.getAttributeValue(MANIFEST_ATTRIBUTE) : null;
            return JpsElementFactory.getInstance().createSimpleElement((Object)new JpsPluginModuleProperties(pluginXmlUrl, manifestFileUrl));
        }

        public void saveProperties(@NotNull JpsSimpleElement<JpsPluginModuleProperties> element, @NotNull Element componentElement) {
            String manifestFileUrl;
            String pluginXmlUrl;
            if (element == null) {
                JpsPluginModulePropertiesSerializer.$$$reportNull$$$0(0);
            }
            if (componentElement == null) {
                JpsPluginModulePropertiesSerializer.$$$reportNull$$$0(1);
            }
            if ((pluginXmlUrl = ((JpsPluginModuleProperties)element.getData()).getPluginXmlUrl()) != null) {
                componentElement.setAttribute(URL_ATTRIBUTE, pluginXmlUrl);
            }
            if ((manifestFileUrl = ((JpsPluginModuleProperties)element.getData()).getManifestFileUrl()) != null) {
                componentElement.setAttribute(MANIFEST_ATTRIBUTE, manifestFileUrl);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentElement";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsPluginModulePropertiesSerializer";
            objectArray[2] = "saveProperties";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JpsIdeaSdkPropertiesSerializer
    extends JpsSdkPropertiesSerializer<JpsSimpleElement<JpsIdeaSdkProperties>> {
        private static final String SANDBOX_HOME_FIELD = "mySandboxHome";
        private static final String JDK_NAME_ATTRIBUTE = "sdk";

        JpsIdeaSdkPropertiesSerializer() {
            super("IDEA JDK", (JpsSdkType)JpsIdeaSdkType.INSTANCE);
        }

        @NotNull
        public JpsSimpleElement<JpsIdeaSdkProperties> loadProperties(@Nullable Element propertiesElement) {
            String sandboxHome = null;
            String jdkName = null;
            if (propertiesElement != null) {
                sandboxHome = JDOMExternalizerUtil.readField((Element)propertiesElement, (String)SANDBOX_HOME_FIELD);
                jdkName = propertiesElement.getAttributeValue(JDK_NAME_ATTRIBUTE);
            }
            JpsSimpleElement jpsSimpleElement = JpsElementFactory.getInstance().createSimpleElement((Object)new JpsIdeaSdkProperties(sandboxHome, jdkName));
            if (jpsSimpleElement == null) {
                JpsIdeaSdkPropertiesSerializer.$$$reportNull$$$0(0);
            }
            return jpsSimpleElement;
        }

        public void saveProperties(@NotNull JpsSimpleElement<JpsIdeaSdkProperties> properties, @NotNull Element element) {
            if (properties == null) {
                JpsIdeaSdkPropertiesSerializer.$$$reportNull$$$0(1);
            }
            if (element == null) {
                JpsIdeaSdkPropertiesSerializer.$$$reportNull$$$0(2);
            }
            JDOMExternalizerUtil.writeField((Element)element, (String)SANDBOX_HOME_FIELD, (String)((JpsIdeaSdkProperties)properties.getData()).getSandboxHome());
            element.setAttribute(JDK_NAME_ATTRIBUTE, ((JpsIdeaSdkProperties)properties.getData()).getJdkName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsIdeaSdkPropertiesSerializer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadProperties";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsIdeaSdkPropertiesSerializer";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "saveProperties";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

