/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.VtlFileIndex;
import com.intellij.velocity.VtlGlobalMacroProvider;
import com.intellij.velocity.VtlGlobalVariableProvider;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.files.VtlFileProxy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.template.TemplatesManager;

class ProviderBuilder {
    private final VtlFile myFile;

    ProviderBuilder(@NotNull VtlFile file) {
        if (file == null) {
            ProviderBuilder.$$$reportNull$$$0(0);
        }
        this.myFile = file;
    }

    CachedValueProvider<Collection<VtlVariable>> createGlobalVarsProvider() {
        return () -> {
            ArrayList<VtlVariable> result = new ArrayList<VtlVariable>();
            for (VtlGlobalVariableProvider provider : VtlGlobalVariableProvider.EP_NAME.getExtensionList()) {
                result.addAll(provider.getGlobalVariables(this.myFile));
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{this.myFile});
        };
    }

    CachedValueProvider<Map<String, Set<VtlMacro>>> createAllMacrosProvider() {
        return () -> {
            THashMap result = new THashMap();
            PsiUtil.processDeclarations(new PsiScopeProcessor((Map)result){
                final /* synthetic */ Map val$result;
                {
                    this.val$result = map;
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element instanceof VtlMacro) {
                        ProviderBuilder.registerMacro((VtlMacro)element, this.val$result);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/velocity/psi/files/ProviderBuilder$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, ResolveState.initial(), null, null, this.myFile);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        };
    }

    private static void registerMacro(VtlMacro macro, Map<String, Set<VtlMacro>> result) {
        String macroName = macro.getName();
        if (macroName == null) {
            return;
        }
        THashSet sameNameMacros = result.get(macroName);
        if (sameNameMacros == null) {
            sameNameMacros = new THashSet();
            result.put(macroName, (Set<VtlMacro>)sameNameMacros);
        }
        sameNameMacros.add((VtlMacro)macro);
    }

    static CachedValueProvider<Map<String, VtlImplicitVariable>> createImplicitVarsProvider(VtlFile root) {
        return () -> {
            Map implicits;
            THashMap result = new THashMap();
            Properties defaultVariables = (Properties)root.getViewProvider().getUserData(FileTemplateManager.DEFAULT_TEMPLATE_PROPERTIES);
            if (defaultVariables != null) {
                for (Map.Entry<Object, Object> entry : defaultVariables.entrySet()) {
                    String name = (String)entry.getKey();
                    VtlImplicitVariable var = ProviderBuilder.getOrCreate((Map<String, VtlImplicitVariable>)result, root, null, name, name, null);
                    var.setType((String)entry.getValue());
                }
            }
            if ((implicits = (Map)root.getOriginalFile().getViewProvider().getUserData(TemplatesManager.TEMPLATE_IMPLICITS)) != null) {
                for (Map.Entry entry : implicits.entrySet()) {
                    String name = (String)entry.getKey();
                    VtlImplicitVariable var = ProviderBuilder.getOrCreate((Map<String, VtlImplicitVariable>)result, root, root, name, name, null);
                    var.setPsiType((PsiType)entry.getValue());
                }
            }
            root.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Map)result, root){
                final /* synthetic */ Map val$result;
                final /* synthetic */ VtlFile val$root;
                {
                    this.val$result = map;
                    this.val$root = vtlFile;
                }

                public void visitComment(PsiComment comment) {
                    String text = comment.getText();
                    String[] nameAndTypeAndScopeFilePath = VtlFile.findVariableNameAndTypeAndScopeFilePath(text);
                    if (nameAndTypeAndScopeFilePath == null) {
                        return;
                    }
                    VtlFile scopeFile = ProviderBuilder.findVtlFile(comment, text, nameAndTypeAndScopeFilePath[2]);
                    String key = nameAndTypeAndScopeFilePath[0];
                    if (nameAndTypeAndScopeFilePath[2] != null) {
                        if (scopeFile == null) {
                            return;
                        }
                        key = key + nameAndTypeAndScopeFilePath[2];
                    }
                    VtlImplicitVariable var = ProviderBuilder.getOrCreate(this.val$result, this.val$root, (PsiElement)comment, key, nameAndTypeAndScopeFilePath[0], scopeFile);
                    var.setType(nameAndTypeAndScopeFilePath[1]);
                }
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{root.getContainingFile()});
        };
    }

    public CachedValueProvider<Collection<VtlMacro>> createGlobalMacrosProvider() {
        return () -> {
            ArrayList<VtlMacro> result = new ArrayList<VtlMacro>();
            for (VtlGlobalMacroProvider provider : VtlGlobalMacroProvider.EP_NAME.getExtensionList()) {
                result.addAll(provider.getGlobalMacros(this.myFile));
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{this.myFile});
        };
    }

    public CachedValueProvider<Collection<VtlFileProxy>> createMacroLibrariesProvider() {
        return () -> {
            THashSet result = new THashSet();
            this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Collection)result){
                final /* synthetic */ Collection val$result;
                {
                    this.val$result = collection;
                }

                public void visitComment(PsiComment comment) {
                    String text = comment.getText();
                    String[] pathAndScopeFilePath = VtlFile.findMacroLibraryPathAndScopeFilePath(text);
                    if (pathAndScopeFilePath == null) {
                        return;
                    }
                    VtlFile libraryFile = ProviderBuilder.findVtlFile(comment, text, pathAndScopeFilePath[0]);
                    if (libraryFile == null) {
                        return;
                    }
                    VtlFile scopeFile = ProviderBuilder.findVtlFile(comment, text, pathAndScopeFilePath[1]);
                    if (pathAndScopeFilePath[1] == null || scopeFile != null) {
                        this.val$result.add(new VtlFileProxy(libraryFile, scopeFile));
                    }
                }
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this.myFile});
        };
    }

    @Nullable
    private static VtlFile findVtlFile(PsiComment comment, String text, @Nullable String filePath) {
        return ProviderBuilder.findFile(comment, text, filePath, VtlFile.class);
    }

    @Nullable
    private static <T extends PsiFile> T findFile(PsiComment comment, String text, @Nullable String filePath, Class<T> fileClass) {
        if (filePath == null) {
            return null;
        }
        FileReference[] fileReferences = PsiUtil.getFileReferences(filePath, (PsiElement)comment, text.indexOf(filePath), false);
        return PsiUtil.findFile((PsiReference[])fileReferences, fileClass);
    }

    public CachedValueProvider<VelocityPropertiesProvider> createVelocityPropertiesProvider() {
        return new CachedValueProvider<VelocityPropertiesProvider>(){

            public CachedValueProvider.Result<VelocityPropertiesProvider> compute() {
                final HashSet<Key> dependencies = new HashSet<Key>(3);
                final Ref result = new Ref();
                PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

                    public void visitFile(PsiFile file) {
                        dependencies.add(file);
                        super.visitFile(file);
                    }

                    public void visitComment(PsiComment comment) {
                        if (result.get() != null) {
                            return;
                        }
                        String text = comment.getText();
                        String[] velocityPropertiesPathAndScopeFilePath = VtlFile.findVelocityPropertiesPathAndScopeFilePath(text);
                        if (velocityPropertiesPathAndScopeFilePath == null) {
                            return;
                        }
                        VtlFile scopeFile = ProviderBuilder.findVtlFile(comment, text, velocityPropertiesPathAndScopeFilePath[2]);
                        if (!(velocityPropertiesPathAndScopeFilePath[2] == null || scopeFile != null && ProviderBuilder.isOriginalEquivalent(ProviderBuilder.this.myFile, scopeFile))) {
                            return;
                        }
                        PropertiesFileImpl velocityPropertiesFile = (PropertiesFileImpl)ProviderBuilder.findFile(comment, text, velocityPropertiesPathAndScopeFilePath[0], PropertiesFileImpl.class);
                        if (velocityPropertiesFile == null) {
                            return;
                        }
                        dependencies.add(velocityPropertiesFile);
                        VirtualFile runtimeRoot = ProviderBuilder.findRuntimeRoot(comment.getContainingFile(), velocityPropertiesPathAndScopeFilePath[1]);
                        result.set((Object)new VelocityPropertiesProvider((PropertiesFile)velocityPropertiesFile, runtimeRoot));
                    }
                };
                ProviderBuilder.this.myFile.accept((PsiElementVisitor)visitor);
                if (result.get() == null) {
                    Collection<VtlFile> implicitlyIncludedFiles = VtlFileIndex.getImplicitlyIncludedFiles((PsiFile)ProviderBuilder.this.myFile);
                    if (implicitlyIncludedFiles.isEmpty()) {
                        dependencies.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                    }
                    for (VtlFile implicitlyIncludedFile : implicitlyIncludedFiles) {
                        implicitlyIncludedFile.accept((PsiElementVisitor)visitor);
                        if (result.get() == null) continue;
                        break;
                    }
                }
                return CachedValueProvider.Result.create((Object)result.get(), (Object[])dependencies.toArray());
            }
        };
    }

    @Nullable
    private static VirtualFile findRuntimeRoot(@NotNull PsiFile contextFile, @Nullable String path) {
        if (contextFile == null) {
            ProviderBuilder.$$$reportNull$$$0(1);
        }
        PsiDirectory parent = contextFile.getParent();
        if (path == null || path.isEmpty() || parent == null) {
            return null;
        }
        VirtualFile context = parent.getVirtualFile();
        if (path.charAt(0) != '/') {
            return context.findFileByRelativePath(path);
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)contextFile);
        if (module == null) {
            return null;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        if (moduleRootManager == null) {
            return null;
        }
        for (VirtualFile root : moduleRootManager.getContentRoots()) {
            if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)context, (boolean)false)) continue;
            return path.length() == 1 ? root : root.findFileByRelativePath(path.substring(1));
        }
        return null;
    }

    private static boolean isOriginalEquivalent(@NotNull VtlFile file1, @NotNull VtlFile file2) {
        if (file1 == null) {
            ProviderBuilder.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ProviderBuilder.$$$reportNull$$$0(3);
        }
        return file1.getOriginalFile().isEquivalentTo((PsiElement)file2.getOriginalFile());
    }

    private static VtlImplicitVariable getOrCreate(@NotNull Map<String, VtlImplicitVariable> mapToAddTo, @NotNull PsiElement parent, @Nullable PsiElement comment, String key, String name, @Nullable VtlFile scopeFile) {
        if (mapToAddTo == null) {
            ProviderBuilder.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            ProviderBuilder.$$$reportNull$$$0(5);
        }
        assert (comment == null || comment.getContainingFile() == parent.getContainingFile());
        return (VtlImplicitVariable)ContainerUtil.getOrCreate(mapToAddTo, (Object)key, () -> {
            if (parent == null) {
                ProviderBuilder.$$$reportNull$$$0(6);
            }
            return new VtlImplicitVariable(parent, comment, name, scopeFile);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapToAddTo";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/psi/files/ProviderBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findRuntimeRoot";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isOriginalEquivalent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getOrCreate$5";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

