/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.reactor.inspections;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.frameworks.reactor.ReactorCoreBundle;
import com.intellij.frameworks.reactor.inspections.BaseNonBlockingScopeInspection;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;

public class BlockingOperatorInNonBlockingScopeInspection
extends BaseNonBlockingScopeInspection {
    private static final String BLOCKING_NAME_PREFIX = "block";

    @Override
    protected void report(@NotNull ProblemsHolder holder, @NotNull PsiElement methodIdentifierPsi) {
        if (holder == null) {
            BlockingOperatorInNonBlockingScopeInspection.$$$reportNull$$$0(0);
        }
        if (methodIdentifierPsi == null) {
            BlockingOperatorInNonBlockingScopeInspection.$$$reportNull$$$0(1);
        }
        holder.registerProblem(methodIdentifierPsi, ReactorCoreBundle.message("inspections.blocking.operator.in.non.blocking.scope.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    @Override
    protected boolean shouldReportCall(UExpression receiver, UCallExpression expression) {
        String methodName = expression.getMethodName();
        if (methodName != null && methodName.startsWith(BLOCKING_NAME_PREFIX)) {
            return true;
        }
        String expressionReturnTypeQualifiedName = AnalysisUastUtil.getExpressionReturnTypePsiClassFqn((UCallExpression)expression);
        if (BlockingOperatorInNonBlockingScopeInspection.isPublisherTypeFqnName(expressionReturnTypeQualifiedName)) {
            return false;
        }
        PsiType returnType = expression.getReturnType();
        if (Objects.equals(BlockingOperatorInNonBlockingScopeInspection.getContainingType(receiver.getExpressionType()), BlockingOperatorInNonBlockingScopeInspection.getContainingType(returnType))) {
            if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.lang.Iterable")) {
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.Stream")) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiType getContainingType(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiType[] parameters = ((PsiClassType)type).getParameters();
        if (parameters.length != 1) {
            return null;
        }
        return GenericsUtil.eliminateWildcards((PsiType)parameters[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "methodIdentifierPsi";
                break;
            }
        }
        objectArray[1] = "com/intellij/frameworks/reactor/inspections/BlockingOperatorInNonBlockingScopeInspection";
        objectArray[2] = "report";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

