/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.storage.ValidityState;

public class AndroidFileSetState
implements ValidityState {
    private final Map<String, Long> myTimestamps;

    public AndroidFileSetState(@NotNull Collection<String> roots, final @NotNull Condition<File> filter, boolean recursively) {
        if (roots == null) {
            AndroidFileSetState.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            AndroidFileSetState.$$$reportNull$$$0(1);
        }
        this.myTimestamps = new HashMap();
        for (String rootPath : roots) {
            File root = new File(rootPath);
            if (recursively) {
                FileUtil.processFilesRecursively((File)root, (Processor)new Processor<File>(){

                    public boolean process(File file) {
                        if (filter.value((Object)file)) {
                            AndroidFileSetState.this.myTimestamps.put(FileUtil.toSystemIndependentName((String)file.getPath()), FSOperations.lastModified((File)file));
                        }
                        return true;
                    }
                });
                continue;
            }
            if (!filter.value((Object)root)) continue;
            this.myTimestamps.put(FileUtil.toSystemIndependentName((String)root.getPath()), FSOperations.lastModified((File)root));
        }
    }

    public AndroidFileSetState(DataInput in) throws IOException {
        int resourcesCount = in.readInt();
        this.myTimestamps = new HashMap(resourcesCount);
        for (int i = 0; i < resourcesCount; ++i) {
            String filePath = in.readUTF();
            long timestamp = in.readLong();
            this.myTimestamps.put(filePath, timestamp);
        }
    }

    public boolean equalsTo(ValidityState otherState) {
        return otherState instanceof AndroidFileSetState && ((AndroidFileSetState)otherState).myTimestamps.equals(this.myTimestamps);
    }

    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myTimestamps.size());
        for (Map.Entry<String, Long> entry : this.myTimestamps.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeLong(entry.getValue());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "roots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filter";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/android/AndroidFileSetState";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

