/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.jam.context.SeamJamRaiseEvent;
import com.intellij.seam.model.references.BasicEventTypeReference;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SeamObserverEventTypeReference<T extends PsiElement>
extends BasicEventTypeReference<T> {
    public SeamObserverEventTypeReference(T element) {
        super(element);
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<String> eventTypes = new ArrayList<String>();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            SeamObserverEventTypeReference.addRaisedEventTypeFromMethodCalls(eventTypes, module);
            SeamObserverEventTypeReference.addAnnotatedRaisedEvents(eventTypes, module);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(eventTypes);
        if (objectArray == null) {
            SeamObserverEventTypeReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    private static void addAnnotatedRaisedEvents(List<String> eventTypes, Module module) {
        for (SeamJamComponent seamJamComponent : SeamJamModel.getModel(module).getSeamComponents()) {
            for (SeamJamRaiseEvent seamJamRaiseEvent : seamJamComponent.getRaiseEvents()) {
                String eventType = seamJamRaiseEvent.getEventType();
                if (StringUtil.isEmptyOrSpaces((String)eventType)) continue;
                eventTypes.add(eventType);
            }
        }
    }

    private static void addRaisedEventTypeFromMethodCalls(List<String> eventTypes, Module module) {
        PsiClass eventClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.jboss.seam.core.Events", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false));
        if (eventClass != null) {
            for (PsiMethod psiMethod : eventClass.getMethods()) {
                if (!psiMethod.getName().startsWith("raise")) continue;
                for (PsiReference reference : MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), (boolean)false)) {
                    PsiMethodCallExpression expression;
                    PsiExpression[] psiExpressions;
                    PsiElement element = reference.getElement().getParent();
                    if (!(element instanceof PsiMethodCallExpression) || (psiExpressions = (expression = (PsiMethodCallExpression)element).getArgumentList().getExpressions()).length <= 0 || !(psiExpressions[0] instanceof PsiLiteralExpression)) continue;
                    eventTypes.add((String)((PsiLiteralExpression)psiExpressions[0]).getValue());
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/references/SeamObserverEventTypeReference", "getVariants"));
    }
}

