/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.IdeBundle;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.xml.impl.SessionBeanImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.seam.facet.SeamFacet;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.jsf.SeamJamConverter;
import com.intellij.seam.model.jam.jsf.SeamJamValidator;
import com.intellij.seam.model.jam.lifecycle.SeamJamCreate;
import com.intellij.seam.model.jam.lifecycle.SeamJamDestroy;
import com.intellij.seam.resources.SeamBundle;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamJamComponentInspection
extends SeamJamModelInspectionBase {
    private static final String JSF_VALIDATOR_CLASSNAME = "javax.faces.validator.Validator";
    private static final String JSF_CONVERTEWR_CLASSNAME = "javax.faces.convert.Converter";

    @Override
    protected void checkSeamJamComponent(SeamJamComponent seamJamComponent, ProblemsHolder holder) {
        SeamJamComponentInspection.checkEmptyName(holder, seamJamComponent);
        SeamJamComponentInspection.checkDublicatesAnnotations(holder, seamJamComponent);
        SeamJamComponentInspection.checkRemoveAnnotation(holder, seamJamComponent);
        SeamJamComponentInspection.checkValidatorAnnotation(holder, seamJamComponent);
        SeamJamComponentInspection.checkConverterAnnotation(holder, seamJamComponent);
    }

    private SeamFacet getFacet(SeamJamComponent seamJamComponent) {
        Module module = seamJamComponent.getModule();
        return SeamFacet.getInstance(module);
    }

    private static void checkEmptyName(ProblemsHolder holder, SeamJamComponent seamJamComponent) {
        PsiAnnotation annotation;
        String s = seamJamComponent.getComponentName();
        if (StringUtil.isEmptyOrSpaces((String)s) && (annotation = seamJamComponent.getIdentifyingAnnotation()) != null) {
            holder.registerProblem((PsiElement)annotation, IdeBundle.message((String)"value.must.not.be.empty", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkDublicatesAnnotations(ProblemsHolder holder, SeamJamComponent seamJamComponent) {
        List<SeamJamDestroy> destroys;
        List<SeamJamCreate> jamCreates = seamJamComponent.getCreates();
        if (jamCreates.size() > 1) {
            for (SeamJamCreate jamCreate : jamCreates) {
                holder.registerProblem((PsiElement)jamCreate.getIdentifyingAnnotation(), SeamInspectionBundle.message("jam.component.dublicated.annotation", "@Create"), new LocalQuickFix[0]);
            }
        }
        if ((destroys = seamJamComponent.getDestroys()).size() > 1) {
            for (SeamJamDestroy destroy : destroys) {
                holder.registerProblem((PsiElement)destroy.getIdentifyingAnnotation(), SeamInspectionBundle.message("jam.component.dublicated.annotation", "@Destroy"), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkConverterAnnotation(ProblemsHolder holder, SeamJamComponent jamComponent) {
        PsiClass psiClass;
        SeamJamConverter seamJamConverter = jamComponent.getConverter();
        if (seamJamConverter != null && !SeamJamComponentInspection.isAssignable(psiClass = jamComponent.getPsiElement(), JSF_CONVERTEWR_CLASSNAME)) {
            holder.registerProblem((PsiElement)seamJamConverter.getIdentifyingAnnotation(), SeamBundle.message("converter.must.be.implemented", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkValidatorAnnotation(ProblemsHolder holder, SeamJamComponent jamComponent) {
        PsiClass psiClass;
        SeamJamValidator seamJamValidator = jamComponent.getValidator();
        if (seamJamValidator != null && !SeamJamComponentInspection.isAssignable(psiClass = jamComponent.getPsiElement(), JSF_VALIDATOR_CLASSNAME)) {
            holder.registerProblem((PsiElement)seamJamValidator.getIdentifyingAnnotation(), SeamBundle.message("validator.must.be.implemented", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isAssignable(PsiClass aClass, String className) {
        Project project = aClass.getProject();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        return psiClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)psiClass, (boolean)true);
    }

    private static void checkRemoveAnnotation(ProblemsHolder holder, SeamJamComponent seamJamComponent) {
        for (EjbClassRole ejbRole : SeamCommonUtils.getEjbRoles(seamJamComponent)) {
            PsiAnnotation annotation;
            EnterpriseBean bean = ejbRole.getEnterpriseBean();
            if (!(bean instanceof SessionBean) || !SeamCommonUtils.isStateful((SessionBean)bean) || SeamJamComponentInspection.hasRemove((SessionBean)bean) || (annotation = seamJamComponent.getIdentifyingAnnotation()) == null) continue;
            holder.registerProblem((PsiElement)annotation, SeamInspectionBundle.message("jam.component.session.stateful.must.have.remove", bean.getEjbName().getStringValue()), new LocalQuickFix[0]);
        }
    }

    private static boolean hasRemove(SessionBean bean) {
        com.intellij.javaee.model.annotations.ejb.SessionBeanImpl sessionBean;
        PsiClass member;
        if (bean instanceof SessionBeanImpl) {
            SessionBeanImpl domSessionBean = (SessionBeanImpl)bean;
            return domSessionBean.getRemoveMethods().size() > 0;
        }
        if (bean instanceof com.intellij.javaee.model.annotations.ejb.SessionBeanImpl && (member = (sessionBean = (com.intellij.javaee.model.annotations.ejb.SessionBeanImpl)bean).getPsiClass()) != null) {
            for (PsiMethod method : member.getMethods()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"javax.ejb.Remove"});
                if (annotation == null) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("jam.component.inspection.name", new Object[0]);
        if (string == null) {
            SeamJamComponentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamJamComponentInspection" == null) {
            SeamJamComponentInspection.$$$reportNull$$$0(1);
        }
        return "SeamJamComponentInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            SeamJamComponentInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/highlighting/jam/SeamJamComponentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

