/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ViewReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private ViewResolver myResolver;
    private final List<? extends ViewResolver> myResolvers;
    private static final Logger LOG = Logger.getInstance(ViewReference.class);

    ViewReference(PsiElement element, List<? extends ViewResolver> resolvers, TextRange range, boolean soft) {
        super(element, range, soft);
        this.myResolvers = resolvers;
    }

    public PsiElement resolve() {
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(this.getElement());
        if (model == null) {
            return null;
        }
        String viewName = this.getCanonicalText();
        for (ViewResolver viewResolver : this.myResolvers) {
            PsiElement psiElement = viewResolver.resolveView(this.getElement(), viewName, model);
            if (psiElement == null) continue;
            this.myResolver = viewResolver;
            return psiElement;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(this.getElement());
        if (model == null) {
            if (EMPTY_ARRAY == null) {
                ViewReference.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        ArrayList allViews = new ArrayList();
        for (ViewResolver viewResolver : this.myResolvers) {
            allViews.addAll(viewResolver.getAllViews(this.getElement(), model));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(allViews);
        if (objectArray == null) {
            ViewReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ViewReference.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(this.myResolver != null, (Object)("Trying to bind a non-resolved reference? Resolvers: " + this.myResolvers + ", element: " + element));
        String newName = this.myResolver.bindToElement(element);
        return newName == null ? this.getElement() : ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), newName);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ViewReference.$$$reportNull$$$0(3);
        }
        return super.handleElementRename(this.myResolver.handleElementRename(newElementName));
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = this.myResolvers.isEmpty() ? "No view resolvers found" : "Cannot resolve MVC View ''{0}''";
        if (string == null) {
            ViewReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/views/ViewReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/views/ViewReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

